/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.particles;

import com.song.nuclear_craft.entities.AtomicBombEntity;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.BasicParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NukeParticle
extends SpriteTexturedParticle {
    protected NukeParticle(ClientWorld world, double x, double y, double z) {
        this(world, x, y, z, 0.0, 0.0, 0.0);
    }

    protected NukeParticle(ClientWorld world, double x, double y, double z, double x_speed, double y_speed, double z_speed) {
        super(world, x, y, z, x_speed, y_speed, z_speed);
    }

    protected NukeParticle(ClientWorld world, double x, double y, double z, double x_speed, double y_speed, double z_speed, int age, int maxAge, float avg_scale) {
        super(world, x, y, z, x_speed, y_speed, z_speed);
        this.field_70546_d = age;
        this.field_70547_e = maxAge;
        this.field_70544_f = avg_scale * (4.5f + new Random().nextFloat()) / 5.0f;
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217602_b;
    }

    public static class BigSmokeFactory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite iAnimatedSprite;
        private static Random random = new Random();

        public BigSmokeFactory(IAnimatedSprite iAnimatedSprite) {
            this.iAnimatedSprite = iAnimatedSprite;
        }

        @Nullable
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            NukeParticle bigParticle = new NukeParticle(worldIn, x, y + 0.5, z, 0.0, 0.07, 0.0, 0, 700 + (int)(300.0f * random.nextFloat()), 4.0f);
            bigParticle.func_217568_a(this.iAnimatedSprite);
            bigParticle.func_70538_b(1.0f, 1.0f, 1.0f);
            return bigParticle;
        }
    }

    public static class NukeParticleFactory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite iAnimatedSprite;

        public NukeParticleFactory(IAnimatedSprite iAnimatedSprite) {
            this.iAnimatedSprite = iAnimatedSprite;
        }

        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            NukeParticle nukeParticle = new NukeParticle(worldIn, x, y + 0.5, z, 0.0, 0.07, 0.0, 0, 100, 4.0f * AtomicBombEntity.NUKE_RADIUS / 80.0f);
            nukeParticle.func_217568_a(this.iAnimatedSprite);
            nukeParticle.func_70538_b(1.0f, 1.0f, 1.0f);
            return nukeParticle;
        }
    }
}

