/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.blocks.tileentity;

import com.song.nuclear_craft.blocks.C4Bomb;
import com.song.nuclear_craft.blocks.container.C4BombContainer;
import com.song.nuclear_craft.network.C4BombSynPacket;
import com.song.nuclear_craft.network.NuclearCraftPacketHandler;
import com.song.nuclear_craft.network.SoundPacket;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;

public class C4BombTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    private static final int DEFAULT_FUSE_TIME = 800;
    protected boolean is_active = false;
    protected int fuse_age = 0;
    protected int explode_time = 800;
    protected int threshold1 = (int)((double)this.explode_time * 0.33);
    protected int threshold2 = (int)((double)this.explode_time * 0.66);
    public String inputPanel = "";

    public C4BombTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public C4BombTileEntity(TileEntityType<?> tileEntityTypeIn, int explode_time) {
        this(tileEntityTypeIn);
        this.explode_time = explode_time;
    }

    private int getBeepInterval() {
        if (this.fuse_age > this.explode_time - 40) {
            return 2;
        }
        if (this.fuse_age > this.threshold2) {
            return 8;
        }
        if (this.fuse_age > this.threshold1) {
            return 15;
        }
        return 20;
    }

    public void func_73660_a() {
        if (this.is_active) {
            assert (this.field_145850_b != null);
            if (!this.field_145850_b.field_72995_K) {
                ++this.fuse_age;
                this.func_70296_d();
                if (this.fuse_age % this.getBeepInterval() == 0) {
                    NuclearCraftPacketHandler.C4_SETTING_CHANNEL.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)20.0, (RegistryKey)this.field_145850_b.func_234923_W_())), (Object)new SoundPacket(this.field_174879_c, "c4_beep"));
                    this.synToClient();
                }
                if (this.fuse_age >= this.explode_time) {
                    C4Bomb block = (C4Bomb)this.func_195044_w().func_177230_c();
                    World world = this.field_145850_b;
                    BlockPos pos = this.func_174877_v();
                    this.func_145843_s();
                    world.func_217377_a(pos, false);
                    block.explode(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
            }
        }
    }

    private void setActive() {
        this.is_active = true;
        assert (this.field_145850_b != null);
        if (!this.field_145850_b.field_72995_K) {
            NuclearCraftPacketHandler.C4_SETTING_CHANNEL.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)7.0, (RegistryKey)this.field_145850_b.func_234923_W_())), (Object)new SoundPacket(this.field_174879_c, "c4_activate"));
        }
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory inventory, PlayerEntity entity) {
        return new C4BombContainer(id, inventory, this);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(String.format("menu.%s.c4_bomb.display_name", "nuclear_craft"));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        CompoundNBT nbt = super.func_189515_b(compound);
        nbt.func_74768_a("fuse_age", this.fuse_age);
        nbt.func_74768_a("explode_time", this.explode_time);
        nbt.func_74757_a("is_active", this.is_active);
        nbt.func_74768_a("threshold1", this.threshold1);
        nbt.func_74768_a("threshold2", this.threshold2);
        nbt.func_74778_a("inputPanel", this.inputPanel);
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.fuse_age = nbt.func_74762_e("fuse_age");
        this.explode_time = nbt.func_74762_e("explode_time");
        this.is_active = nbt.func_74767_n("is_active");
        this.threshold1 = nbt.func_74762_e("threshold1");
        this.threshold2 = nbt.func_74762_e("threshold2");
        this.inputPanel = nbt.func_74779_i("inputPanel");
        this.synToClient();
    }

    public void delete() {
        if (!this.is_active) {
            this.inputPanel = "";
            this.synToClient();
            this.func_70296_d();
        }
    }

    public void addNum(int num) {
        if (!this.is_active) {
            this.inputPanel = this.inputPanel + num;
            this.synToClient();
            this.func_70296_d();
        }
    }

    public void activate() {
        if (!this.is_active) {
            this.explode_time = !this.inputPanel.isEmpty() ? Integer.parseInt(this.inputPanel) * 20 : 800;
            this.setActive();
            this.synToClient();
        }
    }

    public void synToClient() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            NuclearCraftPacketHandler.C4_SETTING_CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> {
                assert (this.field_145850_b != null);
                return this.field_145850_b.func_175726_f(this.field_174879_c);
            }), (Object)new C4BombSynPacket(this.field_174879_c, this.inputPanel, this.fuse_age, this.explode_time, this.is_active));
        }
    }

    public int getCounter() {
        return (this.explode_time - this.fuse_age) / 20;
    }

    public boolean isActive() {
        return this.is_active;
    }

    public void setAttr(String inputPanel, int fuse_age, int explode_time, boolean is_active) {
        this.inputPanel = inputPanel;
        this.fuse_age = fuse_age;
        this.explode_time = explode_time;
        this.is_active = is_active;
    }
}

