/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.entities;

import com.song.nuclear_craft.entities.EntityList;
import com.song.nuclear_craft.items.AbstractAmmo;
import com.song.nuclear_craft.items.Ammo.AmmoSize;
import com.song.nuclear_craft.items.Ammo.AmmoType;
import com.song.nuclear_craft.items.ItemList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class AbstractAmmoEntity
extends ProjectileItemEntity {
    private double energy;
    private double initSpeed;
    private double gravity = 0.03f;
    protected double baseDamage = 30.0;
    private int age = 0;
    private double bulletSize;
    private final IntOpenHashSet piercedEntities = new IntOpenHashSet(100);
    private boolean isMyImpact = false;
    private double initEnergy;
    private static final DataParameter<Float> CURRENT_MOTION_X = EntityDataManager.func_187226_a(ProjectileItemEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> CURRENT_MOTION_Y = EntityDataManager.func_187226_a(ProjectileItemEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> CURRENT_MOTION_Z = EntityDataManager.func_187226_a(ProjectileItemEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> BULLET_SIZE = EntityDataManager.func_187226_a(ProjectileItemEntity.class, (IDataSerializer)DataSerializers.field_187193_c);

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CURRENT_MOTION_X, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(CURRENT_MOTION_Y, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(CURRENT_MOTION_Z, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(BULLET_SIZE, (Object)Float.valueOf(0.0f));
    }

    public AbstractAmmoEntity(EntityType<? extends AbstractAmmoEntity> type, World world) {
        super(type, world);
    }

    public AbstractAmmoEntity(FMLPlayMessages.SpawnEntity entity, World world) {
        this((EntityType<? extends AbstractAmmoEntity>)((EntityType)EntityList.BULLET_ENTITY.get()), world);
        this.func_213293_j(entity.getVelX(), entity.getVelY(), entity.getVelZ());
        this.func_208000_a(entity.getYaw(), entity.getPitch());
        this.func_70107_b(entity.getPosX(), entity.getPosY(), entity.getPosZ());
    }

    public AbstractAmmoEntity(double x, double y, double z, World world, ItemStack itemStack, PlayerEntity shooter) {
        super((EntityType)EntityList.BULLET_ENTITY.get(), x, y, z, world);
        this.func_213884_b(itemStack);
        this.func_212361_a((Entity)shooter);
        this.bulletSize = ((AbstractAmmo)itemStack.func_77973_b()).getSize().getSize();
        this.field_70180_af.func_187227_b(BULLET_SIZE, (Object)Float.valueOf((float)this.bulletSize));
        this.setBaseDamage(((AbstractAmmo)itemStack.func_77973_b()).getBaseDamage());
    }

    public void setGravity(double gravity) {
        this.gravity = gravity;
    }

    public void setBaseDamage(double baseDamage) {
        this.baseDamage = baseDamage;
    }

    public double getBaseDamage() {
        return this.baseDamage;
    }

    public void func_70071_h_() {
        Vector3d vector3d;
        double kEBefore = -1.0;
        if (this.age == 0) {
            this.initSpeed = this.func_213322_ci().func_72433_c();
            this.bulletSize = ((Float)this.field_70180_af.func_187225_a(BULLET_SIZE)).floatValue();
            this.initEnergy = this.energy = this.getEnergy(this.initSpeed);
        }
        if (this.field_70170_p.field_72995_K) {
            this.func_213293_j(((Float)this.field_70180_af.func_187225_a(CURRENT_MOTION_X)).floatValue(), ((Float)this.field_70180_af.func_187225_a(CURRENT_MOTION_Y)).floatValue(), ((Float)this.field_70180_af.func_187225_a(CURRENT_MOTION_Z)).floatValue());
        } else {
            vector3d = this.func_213322_ci();
            this.field_70180_af.func_187227_b(CURRENT_MOTION_X, (Object)Float.valueOf((float)vector3d.field_72450_a));
            this.field_70180_af.func_187227_b(CURRENT_MOTION_Y, (Object)Float.valueOf((float)vector3d.field_72448_b));
            this.field_70180_af.func_187227_b(CURRENT_MOTION_Z, (Object)Float.valueOf((float)vector3d.field_72449_c));
        }
        this.isMyImpact = true;
        if (!this.field_70170_p.field_72995_K) {
            RayTraceResult raytraceresult = ProjectileHelper.func_234618_a_((Entity)this, this::func_230298_a_);
            while (!this.field_70128_L && raytraceresult != null) {
                raytraceresult = ProjectileHelper.func_234618_a_((Entity)this, this::func_230298_a_);
                if (raytraceresult != null && raytraceresult.func_216346_c() == RayTraceResult.Type.ENTITY) {
                    Entity entity = ((EntityRayTraceResult)raytraceresult).func_216348_a();
                    Entity indirect = this.func_234616_v_();
                    if (entity instanceof PlayerEntity && indirect instanceof PlayerEntity && !((PlayerEntity)indirect).func_96122_a((PlayerEntity)entity)) {
                        raytraceresult = null;
                    }
                }
                if (raytraceresult != null && raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((ThrowableEntity)this, (RayTraceResult)raytraceresult)) {
                    this.func_70227_a(raytraceresult);
                }
                if (raytraceresult == null || raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) continue;
            }
        }
        this.isMyImpact = false;
        super.func_70071_h_();
        if (this.energy <= 0.0) {
            this.func_70106_y();
        }
        this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -this.gravity, 0.0));
        ++this.age;
        vector3d = this.func_213322_ci();
        float f = MathHelper.func_76133_a((double)AbstractAmmoEntity.func_213296_b((Vector3d)vector3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vector3d.field_72450_a, (double)vector3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vector3d.field_72448_b, (double)f) * 57.2957763671875);
        if (this.age >= 1000) {
            this.func_70106_y();
        }
    }

    protected void func_213868_a(EntityRayTraceResult entityRayTraceResult) {
        Entity entity = entityRayTraceResult.func_216348_a();
        this.piercedEntities.add(entity.func_145782_y());
        if (entity instanceof ItemEntity) {
            return;
        }
        double damage = this.baseDamage * this.getEnergy(this.func_213322_ci().func_72433_c()) / this.initEnergy;
        DamageSource damageSource = new IndirectEntityDamageSource(new ResourceLocation("nuclear_craft", "bullet").toString(), (Entity)this, this.func_234616_v_()).func_76349_b();
        entity.func_70097_a(damageSource, (float)damage);
        this.energy = entity instanceof LivingEntity ? (this.energy -= 30.0) : (this.energy -= 10.0);
    }

    protected void func_70227_a(RayTraceResult result) {
        double kEBefore = this.energy;
        if (this.isMyImpact && !this.field_70170_p.field_72995_K) {
            super.func_70227_a(result);
        }
        if (this.energy <= 0.0) {
            this.func_70106_y();
        }
        double factor = Math.sqrt(this.energy / kEBefore);
        this.func_213317_d(this.func_213322_ci().func_216372_d(factor, factor, factor));
    }

    protected boolean func_230298_a_(Entity p_230298_1_) {
        return super.func_230298_a_(p_230298_1_) || this.piercedEntities == null || !this.piercedEntities.contains(p_230298_1_.func_145782_y());
    }

    protected void func_230299_a_(@Nonnull BlockRayTraceResult blockRayTraceResult) {
        Block block = this.field_70170_p.func_180495_p(blockRayTraceResult.func_216350_a()).func_177230_c();
        double blastResist = block.func_149638_a();
        if (blastResist > this.getBlockBreakThreshold() + 0.001) {
            Direction blockDirection = blockRayTraceResult.func_216354_b();
            this.ricochetSpeed(blockDirection);
            this.teleportToHitPoint((RayTraceResult)blockRayTraceResult);
            this.energy -= this.initEnergy * this.getRicochetEnergyLoss();
        } else {
            this.field_70170_p.func_175655_b(blockRayTraceResult.func_216350_a(), true);
            this.energy -= this.getEnergyLoss(blastResist);
        }
        this.piercedEntities.clear();
    }

    protected void teleportToHitPoint(RayTraceResult rayTraceResult) {
        Vector3d hitResult = rayTraceResult.func_216347_e();
        this.func_70107_b(hitResult.field_72450_a, hitResult.field_72448_b, hitResult.field_72449_c);
    }

    public double getRicochetEnergyLoss() {
        return 0.5;
    }

    public double getBlockBreakThreshold() {
        return 3.0;
    }

    public double getEnergyLoss(double blastResist) {
        return 25.0 + 10.0 * (blastResist - 2.0);
    }

    private void ricochetSpeed(Direction direction) {
        switch (direction) {
            case UP: 
            case DOWN: {
                this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, -1.0, 1.0));
                break;
            }
            case EAST: 
            case WEST: {
                this.func_213317_d(this.func_213322_ci().func_216372_d(-1.0, 1.0, 1.0));
                break;
            }
            case NORTH: 
            case SOUTH: {
                this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 1.0, -1.0));
                break;
            }
        }
    }

    protected double getEnergy(double speed) {
        return 0.5 * speed * speed * (this.bulletSize / 9.0);
    }

    protected Item func_213885_i() {
        return (Item)ItemList.AMMO_REGISTRIES_TYPE.get((Object)AmmoSize.SIZE_9MM).get((Object)AmmoType.NORMAL).get();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

