/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.entities;

import com.google.common.collect.Lists;
import com.song.nuclear_craft.misc.Config;
import com.song.nuclear_craft.misc.NukeExplosion;
import com.song.nuclear_craft.network.MySExplosionPacket;
import com.song.nuclear_craft.network.NuclearCraftPacketHandler;
import com.song.nuclear_craft.particles.ParticleList;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SExplosionPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;

public class AtomicBombEntity
extends TNTEntity {
    public static final float NUKE_RADIUS = ((Double)Config.NUKE_RADIUS.get()).floatValue();
    public static final double MAX_BLAST_POWER = (Double)Config.NUKE_BLAST_POWER.get();
    private int fuse;

    public AtomicBombEntity(World worldIn, double x, double y, double z, @Nullable LivingEntity igniter) {
        this(worldIn, x, y, z, igniter, 10);
    }

    public AtomicBombEntity(World world, double x, double y, double z, @Nullable LivingEntity igniter, int fuse) {
        super(world, x, y, z, igniter);
        this.fuse = fuse;
    }

    public AtomicBombEntity(EntityType<? extends AtomicBombEntity> entityType, World world) {
        super(entityType, world);
    }

    public static double getBlastPower(double dist, double radius) {
        double decay_rd = radius * 0.95;
        if (dist < decay_rd) {
            return 1.1;
        }
        return -(1.0 / (radius - decay_rd)) * (dist - decay_rd) + 1.0;
    }

    public static Explosion nukeExplode(World world, Entity entity, double x, double y, double z, float radius, boolean spawnCloud, double max_blast_power) {
        ArrayList affectedBlockPositions = Lists.newArrayList();
        int radius_int = (int)Math.ceil(radius);
        for (int dx = -radius_int; dx < radius_int + 1; ++dx) {
            int y_lim = (int)Math.sqrt(radius_int * radius_int - dx * dx);
            for (int dy = -y_lim; dy < y_lim + 1; ++dy) {
                int z_lim = (int)Math.sqrt(radius_int * radius_int - dx * dx - dy * dy);
                for (int dz = -z_lim; dz < z_lim + 1; ++dz) {
                    float resistance;
                    BlockPos blockPos = new BlockPos(x + (double)dx, y + (double)dy, z + (double)dz);
                    double power = AtomicBombEntity.getBlastPower(Math.sqrt(dx * dx + dy * dy + dz * dz), radius);
                    if (!(power > 1.0)) {
                        Random random = new Random();
                        if (!(power > random.nextDouble())) continue;
                    }
                    if (!((double)(resistance = world.func_180495_p(blockPos).func_177230_c().func_149638_a()) < max_blast_power)) continue;
                    affectedBlockPositions.add(blockPos);
                }
            }
        }
        NukeExplosion nukeExplosion = new NukeExplosion(world, entity, x, y, z, radius, affectedBlockPositions);
        nukeExplosion.func_77278_a();
        nukeExplosion.func_77279_a(false);
        for (PlayerEntity playerentity : world.func_217369_A()) {
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)playerentity;
            if (!(serverplayerentity.func_70092_e(x, y, z) < 65536.0)) continue;
            serverplayerentity.field_71135_a.func_147359_a((IPacket)new SExplosionPacket(x, y, z, radius, nukeExplosion.func_180343_e(), (Vector3d)nukeExplosion.func_77277_b().get(serverplayerentity)));
            if (!spawnCloud) continue;
            NuclearCraftPacketHandler.EXPLOSION_CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverplayerentity), (Object)new MySExplosionPacket(radius, x, y, z));
        }
        AtomicBombEntity.playNukeSound(world, x, y, z, radius);
        world.func_217385_a(entity, x, y, z, radius * 0.8f, Explosion.Mode.BREAK);
        return nukeExplosion;
    }

    public static Explosion nukeExplode(World world, Entity entity, double x, double y, double z, float radius, boolean spawnCloud) {
        return AtomicBombEntity.nukeExplode(world, entity, x, y, z, radius, spawnCloud, MAX_BLAST_POWER);
    }

    public static void playNukeSound(World world, double x, double y, double z, double radius) {
        world.func_184148_a(null, x, y, z, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, (float)(40.0 * radius / (double)NUKE_RADIUS), (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
    }

    @Deprecated
    public static void multiExplode(World world, Entity entity, double x, double y, double z, float radius, int intensity) {
        float hf_rd = radius / 4.0f;
        for (int i = -intensity; i < intensity + 1; ++i) {
            for (int j = -intensity; j < intensity + 1; ++j) {
                for (int k = -intensity; k < 1; ++k) {
                    if (!(Math.sqrt(i * i + j * j + k * k) < (double)intensity + 0.1)) continue;
                    world.func_217385_a(entity, x + (double)(hf_rd * (float)i), y + (double)(hf_rd * (float)k), z + (double)(hf_rd * (float)j), radius, Explosion.Mode.BREAK);
                }
            }
        }
    }

    protected void func_70515_d() {
        AtomicBombEntity.nukeExplode(this.field_70170_p, (Entity)this, this.func_226277_ct_(), this.func_226283_e_(0.0625), this.func_226281_cx_(), NUKE_RADIUS, true);
    }

    public static void mushroomCloud(double x, double y, double z, double radius) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world.field_72995_K) {
            int MAX_STEP_Y = (int)Math.ceil(1.25 * radius);
            double step_y = 2.986 * radius / (double)MAX_STEP_Y;
            for (int step = 0; step < MAX_STEP_Y; ++step) {
                double this_r = 0.0;
                double delta_y = (double)step * step_y;
                if (delta_y < radius / 3.0) {
                    this_r = radius - delta_y * 2.0;
                } else if (delta_y < radius) {
                    this_r = radius / 3.0;
                } else if (delta_y < 2.98 * radius) {
                    this_r = Math.sqrt(radius * radius - (1.986 * radius - delta_y) * (1.986 * radius - delta_y));
                }
                int n_render = (int)Math.ceil(0.75 * this_r);
                double theta_step = 6.28 / (double)n_render;
                for (int i = 0; i < n_render; ++i) {
                    double theta = theta_step * (double)i;
                    double delta_x = this_r * Math.cos(theta);
                    double delta_z = this_r * Math.sin(theta);
                    if (delta_y > radius) {
                        world.func_195590_a((IParticleData)ParticleList.NUKE_PARTICLE_FIRE.get(), true, x + delta_x, y + delta_y, z + delta_z, 0.0, 0.07, 0.0);
                        continue;
                    }
                    world.func_195590_a((IParticleData)ParticleList.NUKE_PARTICLE_SMOKE.get(), true, x + delta_x, y + delta_y, z + delta_z, 0.0, 0.07, 0.0);
                }
            }
        }
    }

    public void func_70071_h_() {
        if (!this.func_189652_ae()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        this.func_213317_d(this.func_213322_ci().func_186678_a(0.98));
        if (this.field_70122_E) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(0.7, -0.5, 0.7));
        }
        --this.fuse;
        if (this.fuse <= 0) {
            this.func_70106_y();
            if (!this.field_70170_p.field_72995_K) {
                this.func_70515_d();
            }
        } else {
            this.func_233566_aG_();
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
        }
    }
}

