/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.entities;

import com.song.nuclear_craft.misc.Config;
import com.song.nuclear_craft.network.NuclearCraftPacketHandler;
import com.song.nuclear_craft.network.SmokeBombPacket;
import com.song.nuclear_craft.particles.ParticleList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;

public class SmokeRocketEntity
extends FireworkRocketEntity {
    public static double SMOKE_RADIUS = ((Double)Config.SMOKE_RADIUS.get()).floatValue();

    public SmokeRocketEntity(EntityType<? extends FireworkRocketEntity> p_i50164_1_, World p_i50164_2_) {
        super(p_i50164_1_, p_i50164_2_);
    }

    public SmokeRocketEntity(World worldIn, double x, double y, double z, ItemStack givenItem) {
        super(worldIn, x, y, z, givenItem);
    }

    public SmokeRocketEntity(World p_i231581_1_, @Nullable Entity p_i231581_2_, double p_i231581_3_, double p_i231581_5_, double p_i231581_7_, ItemStack p_i231581_9_) {
        super(p_i231581_1_, p_i231581_2_, p_i231581_3_, p_i231581_5_, p_i231581_7_, p_i231581_9_);
    }

    public SmokeRocketEntity(World p_i47367_1_, ItemStack p_i47367_2_, LivingEntity p_i47367_3_) {
        super(p_i47367_1_, p_i47367_2_, p_i47367_3_);
    }

    public SmokeRocketEntity(World p_i50165_1_, ItemStack p_i50165_2_, double p_i50165_3_, double p_i50165_5_, double p_i50165_7_, boolean p_i50165_9_) {
        super(p_i50165_1_, p_i50165_2_, p_i50165_3_, p_i50165_5_, p_i50165_7_, p_i50165_9_);
    }

    public SmokeRocketEntity(World p_i231582_1_, ItemStack p_i231582_2_, Entity p_i231582_3_, double p_i231582_4_, double p_i231582_6_, double p_i231582_8_, boolean p_i231582_10_) {
        super(p_i231582_1_, p_i231582_2_, p_i231582_3_, p_i231582_4_, p_i231582_6_, p_i231582_8_, p_i231582_10_);
    }

    protected void func_213868_a(EntityRayTraceResult p_213868_1_) {
        this.explode();
    }

    protected void func_230299_a_(BlockRayTraceResult p_230299_1_) {
        this.explode();
    }

    private void explode() {
        this.func_70106_y();
        if (!this.field_70170_p.field_72995_K) {
            SmokeRocketEntity.sendSmokePacket(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
    }

    public static void sendSmokePacket(World world, double x, double y, double z) {
        world.func_184148_a(null, x, y, z, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 20.0f, 1.0f);
        for (PlayerEntity playerEntity : world.func_217369_A()) {
            ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)playerEntity;
            NuclearCraftPacketHandler.SMOKE_BOMB_CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayerEntity), (Object)new SmokeBombPacket(x, y, z));
        }
    }

    public static void generateSmoke(double x, double y, double z) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        Random random = new Random();
        for (double deltaX = -SMOKE_RADIUS; deltaX <= SMOKE_RADIUS; deltaX += 3.0) {
            for (double deltaY = -SMOKE_RADIUS; deltaY <= SMOKE_RADIUS; deltaY += 3.0) {
                for (double deltaZ = -SMOKE_RADIUS; deltaZ <= SMOKE_RADIUS; deltaZ += 3.0) {
                    if (!(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ < SMOKE_RADIUS * SMOKE_RADIUS) || !(random.nextDouble() > 0.7) || world.func_180495_p(new BlockPos(x + deltaX, y + deltaY, z + deltaZ)) != Blocks.field_150350_a.func_176223_P()) continue;
                    world.func_195594_a((IParticleData)ParticleList.BIG_SMOKE.get(), x + deltaX, y + deltaY, z + deltaZ, 0.03 * (random.nextDouble() - 0.5), 0.03 * (random.nextDouble() - 0.5), 0.03 * (random.nextDouble() - 0.5));
                }
            }
        }
    }
}

