/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.items;

import com.song.nuclear_craft.items.Ammo.AmmoSize;
import com.song.nuclear_craft.items.Ammo.AmmoType;
import com.song.nuclear_craft.misc.Config;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class AbstractAmmo
extends Item {
    private final AmmoSize size;
    private final AmmoType type;

    public AbstractAmmo(Item.Properties properties, AmmoSize size, AmmoType type) {
        super(properties);
        this.size = size;
        this.type = type;
    }

    @Nonnull
    public AmmoSize getSize() {
        return this.size;
    }

    @Nonnull
    public AmmoType getType() {
        return this.type;
    }

    public double getBaseDamage() {
        return (Double)Config.DAMAGE_MAP.get((Object)this.size).get((Object)this.type).get();
    }

    public float getBaseSpeed() {
        return ((Double)Config.SPEED_MAP.get((Object)this.size).get((Object)this.type).get()).floatValue();
    }

    public double getGravity() {
        return (Double)Config.GRAVITY_MAP.get((Object)this.size).get((Object)this.type).get();
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent(String.format("tooltip.%s.ammo.desc1", "nuclear_craft")));
        tooltip.add((ITextComponent)new TranslationTextComponent(String.format("tooltip.%s.ammo.desc2", "nuclear_craft")));
        tooltip.add((ITextComponent)new TranslationTextComponent(String.format("tooltip.%s.ammo.base_damage", "nuclear_craft")).func_230529_a_((ITextComponent)new StringTextComponent(String.format(" %.2f", this.getBaseDamage()))));
        tooltip.add((ITextComponent)new TranslationTextComponent(String.format("tooltip.%s.ammo.base_speed", "nuclear_craft")).func_230529_a_((ITextComponent)new StringTextComponent(String.format(" %.2f m/s", Float.valueOf(20.0f * this.getBaseSpeed())))));
        tooltip.add((ITextComponent)new TranslationTextComponent(String.format("tooltip.%s.ammo.gravity", "nuclear_craft")).func_230529_a_((ITextComponent)new StringTextComponent(String.format(" %.2f m/s^2", 400.0 * this.getGravity()))));
    }
}

