/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.misc;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.ProtectionEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.ExplosionContext;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class NukeExplosion
extends Explosion {
    private static final ExplosionContext field_242407_a = new ExplosionContext();
    private final boolean causesFire;
    private final Explosion.Mode mode;
    private final Random random = new Random();
    private final World world;
    private final double x;
    private final double y;
    private final double z;
    @Nullable
    private final Entity exploder;
    private final float size;
    private final List<BlockPos> affectedBlockPositions = Lists.newArrayList();
    private final Map<PlayerEntity, Vector3d> playerKnockbackMap = Maps.newHashMap();
    private final Vector3d position;

    public NukeExplosion(World worldIn, @Nullable Entity entityIn, double x, double y, double z, float size, List<BlockPos> affectedPositions) {
        super(worldIn, entityIn, null, null, x, y, z, size, false, Explosion.Mode.DESTROY);
        this.world = worldIn;
        this.exploder = entityIn;
        this.size = size;
        this.x = x;
        this.y = y;
        this.z = z;
        this.causesFire = false;
        this.mode = Explosion.Mode.DESTROY;
        this.position = new Vector3d(this.x, this.y, this.z);
        this.affectedBlockPositions.addAll(affectedPositions);
    }

    public void addAffected(BlockPos blockPos) {
        this.affectedBlockPositions.add(blockPos);
    }

    public void func_77278_a() {
        float f2 = this.size * 2.0f;
        int k1 = MathHelper.func_76128_c((double)(this.x - (double)f2 - 1.0));
        int l1 = MathHelper.func_76128_c((double)(this.x + (double)f2 + 1.0));
        int i2 = MathHelper.func_76128_c((double)(this.y - (double)f2 - 1.0));
        int i1 = MathHelper.func_76128_c((double)(this.y + (double)f2 + 1.0));
        int j2 = MathHelper.func_76128_c((double)(this.z - (double)f2 - 1.0));
        int j1 = MathHelper.func_76128_c((double)(this.z + (double)f2 + 1.0));
        List list = this.world.func_72839_b(this.exploder, new AxisAlignedBB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        ForgeEventFactory.onExplosionDetonate((World)this.world, (Explosion)this, (List)list, (double)f2);
        Vector3d vector3d = new Vector3d(this.x, this.y, this.z);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            PlayerEntity playerentity;
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            Entity entity = (Entity)list.get(k2);
            if (entity.func_180427_aV() || !((d12 = (double)(MathHelper.func_76133_a((double)entity.func_195048_a(vector3d)) / f2)) <= 1.0) || (d13 = (double)MathHelper.func_76133_a((double)((d5 = entity.func_226277_ct_() - this.x) * d5 + (d7 = (entity instanceof TNTEntity ? entity.func_226278_cu_() : entity.func_226280_cw_()) - this.y) * d7 + (d9 = entity.func_226281_cx_() - this.z) * d9))) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = NukeExplosion.func_222259_a((Vector3d)vector3d, (Entity)entity);
            double d10 = (1.0 - d12) * d14;
            entity.func_70097_a(this.func_199591_b(), (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f2 + 1.0)));
            double d11 = d10;
            if (entity instanceof LivingEntity) {
                d11 = ProtectionEnchantment.func_92092_a((LivingEntity)((LivingEntity)entity), (double)d10);
            }
            entity.func_213317_d(entity.func_213322_ci().func_72441_c(d5 * d11, d7 * d11, d9 * d11));
            if (!(entity instanceof PlayerEntity) || (playerentity = (PlayerEntity)entity).func_175149_v() || playerentity.func_184812_l_() && playerentity.field_71075_bZ.field_75100_b) continue;
            this.playerKnockbackMap.put(playerentity, new Vector3d(d5 * d10, d7 * d10, d9 * d10));
        }
    }

    public void func_77279_a(boolean spawnParticles) {
        boolean flag;
        if (this.world.field_72995_K) {
            this.world.func_184134_a(this.x, this.y, this.z, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.world.field_73012_v.nextFloat() - this.world.field_73012_v.nextFloat()) * 0.2f) * 0.7f, false);
        }
        boolean bl = flag = this.mode != Explosion.Mode.NONE;
        if (spawnParticles) {
            if (!(this.size < 2.0f) && flag) {
                this.world.func_195594_a((IParticleData)ParticleTypes.field_197626_s, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            } else {
                this.world.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            }
        }
        if (flag) {
            ObjectArrayList objectarraylist = new ObjectArrayList();
            Collections.shuffle(this.affectedBlockPositions, this.world.field_73012_v);
            for (BlockPos blockpos : this.affectedBlockPositions) {
                BlockState blockstate = this.world.func_180495_p(blockpos);
                Block block = blockstate.func_177230_c();
                if (blockstate.isAir((IBlockReader)this.world, blockpos)) continue;
                BlockPos blockpos1 = blockpos.func_185334_h();
                this.world.func_217381_Z().func_76320_a("explosion_blocks");
                if (blockstate.canDropFromExplosion((IBlockReader)this.world, blockpos, (Explosion)this) && this.world instanceof ServerWorld) {
                    TileEntity tileentity = blockstate.hasTileEntity() ? this.world.func_175625_s(blockpos) : null;
                    LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.world).func_216023_a(this.world.field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)blockpos)).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216021_b(LootParameters.field_216288_h, (Object)tileentity).func_216021_b(LootParameters.field_216281_a, (Object)this.exploder);
                    if (this.mode == Explosion.Mode.DESTROY) {
                        lootcontext$builder.func_216015_a(LootParameters.field_216290_j, (Object)Float.valueOf(this.size));
                    }
                    blockstate.func_215693_a(lootcontext$builder).forEach(p_229977_2_ -> NukeExplosion.func_229976_a_((ObjectArrayList<Pair<ItemStack, BlockPos>>)objectarraylist, p_229977_2_, blockpos1));
                }
                blockstate.onBlockExploded(this.world, blockpos, (Explosion)this);
                this.world.func_217381_Z().func_76319_b();
            }
            for (Pair pair : objectarraylist) {
                Block.func_180635_a((World)this.world, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
            }
        }
        if (this.causesFire) {
            for (BlockPos blockpos2 : this.affectedBlockPositions) {
                if (this.random.nextInt(3) != 0 || !this.world.func_180495_p(blockpos2).func_196958_f() || !this.world.func_180495_p(blockpos2.func_177977_b()).func_200015_d((IBlockReader)this.world, blockpos2.func_177977_b())) continue;
                this.world.func_175656_a(blockpos2, AbstractFireBlock.func_235326_a_((IBlockReader)this.world, (BlockPos)blockpos2));
            }
        }
    }

    private static void func_229976_a_(ObjectArrayList<Pair<ItemStack, BlockPos>> p_229976_0_, ItemStack p_229976_1_, BlockPos p_229976_2_) {
        int i = p_229976_0_.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)p_229976_0_.get(j);
            ItemStack itemstack = (ItemStack)pair.getFirst();
            if (!ItemEntity.func_226532_a_((ItemStack)itemstack, (ItemStack)p_229976_1_)) continue;
            ItemStack itemstack1 = ItemEntity.func_226533_a_((ItemStack)itemstack, (ItemStack)p_229976_1_, (int)16);
            p_229976_0_.set(j, (Object)Pair.of((Object)itemstack1, (Object)pair.getSecond()));
            if (!p_229976_1_.func_190926_b()) continue;
            return;
        }
        p_229976_0_.add((Object)Pair.of((Object)p_229976_1_, (Object)p_229976_2_));
    }
}

