/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.network;

import com.song.nuclear_craft.items.AbstractGunItem;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.INetHandler;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class GunLoadingPacket {
    public int slot;

    public GunLoadingPacket(int slot) {
        this.slot = slot;
    }

    public GunLoadingPacket(PacketBuffer packetBuffer) {
        this.slot = packetBuffer.readInt();
    }

    public void encode(PacketBuffer packetBuffer) {
        packetBuffer.writeInt(this.slot);
    }

    public static void handle(GunLoadingPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            NetworkEvent.Context context = (NetworkEvent.Context)ctx.get();
            INetHandler handler = context.getNetworkManager().func_150729_e();
            if (handler instanceof ServerPlayNetHandler) {
                ServerWorld world = (ServerWorld)((ServerPlayNetHandler)handler).field_147369_b.field_70170_p;
                ServerPlayerEntity playerEntity = ((ServerPlayNetHandler)handler).field_147369_b;
                AbstractGunItem.tryLoadAmmo(world, (PlayerEntity)playerEntity, packet.slot);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

