/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skins.api;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import lain.mods.skins.api.SkinProviderAPI;
import lain.mods.skins.api.interfaces.ISkin;

public class SkinBundle
implements ISkin {
    protected final AtomicReference<Collection<ISkin>> ref = new AtomicReference(Collections.emptyList());
    protected final Collection<Consumer<ISkin>> listeners = new CopyOnWriteArrayList<Consumer<ISkin>>();
    protected final Collection<Function<ByteBuffer, ByteBuffer>> filters = new CopyOnWriteArrayList<Function<ByteBuffer, ByteBuffer>>();

    protected Optional<ISkin> find() {
        Collection<ISkin> skins = this.ref.get();
        if (skins.isEmpty()) {
            return Optional.empty();
        }
        return skins.stream().filter(ISkin::isDataReady).findFirst();
    }

    @Override
    public ByteBuffer getData() {
        return this.find().orElse(SkinProviderAPI.DUMMY).getData();
    }

    @Override
    public String getSkinType() {
        return this.find().orElse(SkinProviderAPI.DUMMY).getSkinType();
    }

    @Override
    public boolean isDataReady() {
        return this.find().orElse(SkinProviderAPI.DUMMY).isDataReady();
    }

    @Override
    public void onRemoval() {
        this.set(Collections.emptyList());
    }

    public SkinBundle set(Collection<ISkin> c) {
        Collection<ISkin> skins;
        Objects.requireNonNull(c);
        if (!c.isEmpty()) {
            for (ISkin e : c) {
                this.listeners.forEach(e::setRemovalListener);
                this.filters.forEach(e::setSkinFilter);
            }
        }
        if (!(skins = this.ref.getAndSet(c)).isEmpty()) {
            skins.forEach(ISkin::onRemoval);
        }
        return this;
    }

    @Override
    public boolean setRemovalListener(Consumer<ISkin> listener) {
        if (listener == null || this.listeners.contains(listener)) {
            return false;
        }
        if (this.listeners.add(listener)) {
            Collection<ISkin> skins = this.ref.get();
            if (!skins.isEmpty()) {
                skins.forEach(e -> e.setRemovalListener(listener));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean setSkinFilter(Function<ByteBuffer, ByteBuffer> filter) {
        if (filter == null || this.filters.contains(filter)) {
            return false;
        }
        if (this.filters.add(filter)) {
            Collection<ISkin> skins = this.ref.get();
            if (!skins.isEmpty()) {
                skins.forEach(e -> e.setSkinFilter(filter));
            }
            return true;
        }
        return false;
    }
}

