/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skins.init.fabric;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.authlib.GameProfile;
import java.io.BufferedWriter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import lain.mods.skins.api.SkinProviderAPI;
import lain.mods.skins.api.interfaces.ISkin;
import lain.mods.skins.impl.ConfigOptions;
import lain.mods.skins.impl.PlayerProfile;
import lain.mods.skins.impl.fabric.CustomSkinTexture;
import lain.mods.skins.impl.fabric.ImageUtils;
import lain.mods.skins.providers.CrafatarCapeProvider;
import lain.mods.skins.providers.CrafatarSkinProvider;
import lain.mods.skins.providers.CustomServerCapeProvider;
import lain.mods.skins.providers.CustomServerCapeProvider2;
import lain.mods.skins.providers.CustomServerSkinProvider;
import lain.mods.skins.providers.CustomServerSkinProvider2;
import lain.mods.skins.providers.MojangCapeProvider;
import lain.mods.skins.providers.MojangSkinProvider;
import lain.mods.skins.providers.UserManagedCapeProvider;
import lain.mods.skins.providers.UserManagedSkinProvider;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1044;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class FabricOfflineSkins
implements ClientModInitializer {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final Set<String> DefaultSkins = ImmutableSet.of((Object)"textures/entity/player/slim/alex.png", (Object)"textures/entity/player/slim/ari.png", (Object)"textures/entity/player/slim/efe.png", (Object)"textures/entity/player/slim/kai.png", (Object)"textures/entity/player/slim/makena.png", (Object)"textures/entity/player/slim/noor.png", (Object[])new String[]{"textures/entity/player/slim/steve.png", "textures/entity/player/slim/sunny.png", "textures/entity/player/slim/zuri.png", "textures/entity/player/wide/alex.png", "textures/entity/player/wide/ari.png", "textures/entity/player/wide/efe.png", "textures/entity/player/wide/kai.png", "textures/entity/player/wide/makena.png", "textures/entity/player/wide/noor.png", "textures/entity/player/wide/steve.png", "textures/entity/player/wide/sunny.png", "textures/entity/player/wide/zuri.png"});
    private static final Map<ByteBuffer, CustomSkinTexture> textures = new WeakHashMap<ByteBuffer, CustomSkinTexture>();
    private static final boolean skinPass = false;
    private static final boolean capePass = false;
    private static final boolean overwrite = true;

    private static class_2960 generateRandomLocation() {
        return new class_2960("offlineskins", String.format("textures/generated/%s", UUID.randomUUID()));
    }

    public static class_2960 getLocationCape(GameProfile profile, class_2960 result) {
        ISkin skin = SkinProviderAPI.CAPE.getSkin(PlayerProfile.wrapGameProfile(profile));
        if (skin != null && skin.isDataReady()) {
            return FabricOfflineSkins.getOrCreateTexture(skin.getData(), skin).getLocation();
        }
        return null;
    }

    public static class_2960 getLocationSkin(GameProfile profile, class_2960 result) {
        ISkin skin = SkinProviderAPI.SKIN.getSkin(PlayerProfile.wrapGameProfile(profile));
        if (skin != null && skin.isDataReady()) {
            return FabricOfflineSkins.getOrCreateTexture(skin.getData(), skin).getLocation();
        }
        return null;
    }

    private static CustomSkinTexture getOrCreateTexture(ByteBuffer data, ISkin skin) {
        if (!textures.containsKey(data)) {
            CustomSkinTexture texture = new CustomSkinTexture(FabricOfflineSkins.generateRandomLocation(), data);
            class_310.method_1551().method_1531().method_4616(texture.getLocation(), (class_1044)texture);
            textures.put(data, texture);
            if (skin != null) {
                skin.setRemovalListener(s -> {
                    if (data == s.getData()) {
                        class_310.method_1551().execute(() -> {
                            class_310.method_1551().method_1531().method_4615(texture.getLocation());
                            textures.remove(data);
                        });
                    }
                });
            }
        }
        return textures.get(data);
    }

    public static String getSkinType(GameProfile profile, String result) {
        ISkin skin;
        class_2960 location = FabricOfflineSkins.getLocationSkin(profile, null);
        if (location != null && (skin = SkinProviderAPI.SKIN.getSkin(PlayerProfile.wrapGameProfile(profile))) != null && skin.isDataReady()) {
            return skin.getSkinType();
        }
        return null;
    }

    private static boolean isDefaultSkin(class_2960 id) {
        return "minecraft".equals(id.method_12836()) && DefaultSkins.contains(id.method_12832());
    }

    public void onInitializeClient() {
        ClientTickEvents.END_CLIENT_TICK.register(mc -> {
            if (mc.field_1687 != null) {
                for (class_1657 player : mc.field_1687.method_18456()) {
                    SkinProviderAPI.SKIN.getSkin(PlayerProfile.wrapGameProfile(player.method_7334()));
                    SkinProviderAPI.CAPE.getSkin(PlayerProfile.wrapGameProfile(player.method_7334()));
                }
            }
        });
        this.reloadConfig();
    }

    public void reloadConfig() {
        Path pathToConfig = Paths.get(".", "config", "offlineskins.json");
        pathToConfig.toFile().getParentFile().mkdirs();
        if (!pathToConfig.toFile().exists()) {
            try (BufferedWriter w = Files.newBufferedWriter(pathToConfig, StandardCharsets.UTF_8, new OpenOption[0]);){
                gson.toJson((Object)new ConfigOptions().defaultOptions(), (Appendable)w);
            }
            catch (Throwable t) {
                t.printStackTrace();
                System.err.println("[OfflineSkins] Failed to write default config file.");
            }
        }
        ConfigOptions config = null;
        try {
            config = (ConfigOptions)gson.fromJson(Files.lines(pathToConfig, StandardCharsets.UTF_8).collect(Collectors.joining(System.getProperty("line.separator"))), ConfigOptions.class);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.err.println("[OfflineSkins] Failed to read config file.");
            config = new ConfigOptions();
        }
        config.validate();
        SkinProviderAPI.SKIN.clearProviders();
        SkinProviderAPI.SKIN.registerProvider(new UserManagedSkinProvider(Paths.get(".", "cachedImages")).withFilter(ImageUtils::legacyFilter));
        if (config.useCustomServer) {
            SkinProviderAPI.SKIN.registerProvider(new CustomServerSkinProvider().setHost(config.hostCustomServer).withFilter(ImageUtils::legacyFilter));
        }
        if (config.useCustomServer2) {
            SkinProviderAPI.SKIN.registerProvider(new CustomServerSkinProvider2().setHost(config.hostCustomServer2Skin).withFilter(ImageUtils::legacyFilter));
        }
        if (config.useMojang) {
            SkinProviderAPI.SKIN.registerProvider(new MojangSkinProvider().withFilter(ImageUtils::legacyFilter));
        }
        if (config.useCrafatar) {
            SkinProviderAPI.SKIN.registerProvider(new CrafatarSkinProvider().withFilter(ImageUtils::legacyFilter));
        }
        SkinProviderAPI.CAPE.clearProviders();
        SkinProviderAPI.CAPE.registerProvider(new UserManagedCapeProvider(Paths.get(".", "cachedImages")));
        if (config.useCustomServer) {
            SkinProviderAPI.CAPE.registerProvider(new CustomServerCapeProvider().setHost(config.hostCustomServer));
        }
        if (config.useCustomServer2) {
            SkinProviderAPI.CAPE.registerProvider(new CustomServerCapeProvider2().setHost(config.hostCustomServer2Cape));
        }
        if (config.useMojang) {
            SkinProviderAPI.CAPE.registerProvider(new MojangCapeProvider());
        }
        if (config.useCrafatar) {
            SkinProviderAPI.CAPE.registerProvider(new CrafatarCapeProvider());
        }
    }
}

