/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skins.init.forge;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.authlib.GameProfile;
import java.io.BufferedWriter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import lain.mods.skins.api.SkinProviderAPI;
import lain.mods.skins.api.interfaces.ISkin;
import lain.mods.skins.impl.ConfigOptions;
import lain.mods.skins.impl.PlayerProfile;
import lain.mods.skins.impl.forge.CustomSkinTexture;
import lain.mods.skins.impl.forge.ImageUtils;
import lain.mods.skins.init.forge.ForgeOfflineSkins;
import lain.mods.skins.providers.CrafatarCapeProvider;
import lain.mods.skins.providers.CrafatarSkinProvider;
import lain.mods.skins.providers.CustomServerCapeProvider;
import lain.mods.skins.providers.CustomServerCapeProvider2;
import lain.mods.skins.providers.CustomServerSkinProvider;
import lain.mods.skins.providers.CustomServerSkinProvider2;
import lain.mods.skins.providers.MojangCapeProvider;
import lain.mods.skins.providers.MojangSkinProvider;
import lain.mods.skins.providers.UserManagedCapeProvider;
import lain.mods.skins.providers.UserManagedSkinProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

enum Proxy {
    INSTANCE;

    Map<ByteBuffer, CustomSkinTexture> textures = new WeakHashMap<ByteBuffer, CustomSkinTexture>();

    ResourceLocation generateRandomLocation() {
        return new ResourceLocation("offlineskins", String.format("textures/generated/%s", UUID.randomUUID()));
    }

    ResourceLocation getLocationCape(GameProfile profile) {
        ByteBuffer data;
        ISkin skin = SkinProviderAPI.CAPE.getSkin(PlayerProfile.wrapGameProfile(profile));
        if (skin != null && skin.isDataReady() && (data = skin.getData()) != null) {
            return this.getOrCreateTexture(data, skin).getLocation();
        }
        return null;
    }

    ResourceLocation getLocationSkin(GameProfile profile) {
        ByteBuffer data;
        ISkin skin = SkinProviderAPI.SKIN.getSkin(PlayerProfile.wrapGameProfile(profile));
        if (skin != null && skin.isDataReady() && (data = skin.getData()) != null) {
            return this.getOrCreateTexture(data, skin).getLocation();
        }
        return null;
    }

    CustomSkinTexture getOrCreateTexture(ByteBuffer data, ISkin skin) {
        if (!this.textures.containsKey(data)) {
            CustomSkinTexture texture = new CustomSkinTexture(this.generateRandomLocation(), data);
            Minecraft.m_91087_().m_91097_().m_118495_(texture.getLocation(), (AbstractTexture)texture);
            this.textures.put(data, texture);
            if (skin != null) {
                skin.setRemovalListener(s -> {
                    if (data == s.getData()) {
                        Minecraft.m_91087_().execute(() -> {
                            Minecraft.m_91087_().m_91097_().m_118513_(texture.getLocation());
                            this.textures.remove(data);
                        });
                    }
                });
            }
        }
        return this.textures.get(data);
    }

    String getSkinType(GameProfile profile) {
        ByteBuffer data;
        ISkin skin;
        ResourceLocation location = this.getLocationSkin(profile);
        if (location != null && (skin = SkinProviderAPI.SKIN.getSkin(PlayerProfile.wrapGameProfile(profile))) != null && skin.isDataReady() && (data = skin.getData()) != null) {
            return skin.getSkinType();
        }
        return null;
    }

    void handleClientTickEvent(TickEvent.ClientTickEvent event) {
        ClientLevel world;
        if (event.phase == TickEvent.Phase.START && (world = Minecraft.m_91087_().f_91073_) != null) {
            for (Player player : world.m_6907_()) {
                SkinProviderAPI.SKIN.getSkin(PlayerProfile.wrapGameProfile(player.m_36316_()));
                SkinProviderAPI.CAPE.getSkin(PlayerProfile.wrapGameProfile(player.m_36316_()));
            }
        }
    }

    void init() {
        Logger logger = LogManager.getLogger(ForgeOfflineSkins.class);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Path pathToConfig = Paths.get(".", "config", "offlineskins.json");
        pathToConfig.toFile().getParentFile().mkdirs();
        if (!pathToConfig.toFile().exists()) {
            try (BufferedWriter w = Files.newBufferedWriter(pathToConfig, StandardCharsets.UTF_8, new OpenOption[0]);){
                gson.toJson((Object)new ConfigOptions().defaultOptions(), (Appendable)w);
            }
            catch (Throwable t) {
                logger.error("[OfflineSkins] Failed to write default config file.", t);
            }
        }
        ConfigOptions config = null;
        try {
            config = (ConfigOptions)gson.fromJson(Files.lines(pathToConfig, StandardCharsets.UTF_8).collect(Collectors.joining(System.getProperty("line.separator"))), ConfigOptions.class);
        }
        catch (Throwable t) {
            logger.error("[OfflineSkins] Failed to read config file.", t);
            config = new ConfigOptions();
        }
        config.validate();
        SkinProviderAPI.SKIN.clearProviders();
        SkinProviderAPI.SKIN.registerProvider(new UserManagedSkinProvider(Paths.get(".", "cachedImages")).withFilter(ImageUtils::legacyFilter));
        if (config.useCustomServer) {
            SkinProviderAPI.SKIN.registerProvider(new CustomServerSkinProvider().setHost(config.hostCustomServer).withFilter(ImageUtils::legacyFilter));
        }
        if (config.useCustomServer2) {
            SkinProviderAPI.SKIN.registerProvider(new CustomServerSkinProvider2().setHost(config.hostCustomServer2Skin).withFilter(ImageUtils::legacyFilter));
        }
        if (config.useMojang) {
            SkinProviderAPI.SKIN.registerProvider(new MojangSkinProvider().withFilter(ImageUtils::legacyFilter));
        }
        if (config.useCrafatar) {
            SkinProviderAPI.SKIN.registerProvider(new CrafatarSkinProvider().withFilter(ImageUtils::legacyFilter));
        }
        SkinProviderAPI.CAPE.clearProviders();
        SkinProviderAPI.CAPE.registerProvider(new UserManagedCapeProvider(Paths.get(".", "cachedImages")));
        if (config.useCustomServer) {
            SkinProviderAPI.CAPE.registerProvider(new CustomServerCapeProvider().setHost(config.hostCustomServer));
        }
        if (config.useCustomServer2) {
            SkinProviderAPI.CAPE.registerProvider(new CustomServerCapeProvider2().setHost(config.hostCustomServer2Cape));
        }
        if (config.useMojang) {
            SkinProviderAPI.CAPE.registerProvider(new MojangCapeProvider());
        }
        if (config.useCrafatar) {
            SkinProviderAPI.CAPE.registerProvider(new CrafatarCapeProvider());
        }
        MinecraftForge.EVENT_BUS.addListener(this::handleClientTickEvent);
    }
}

