/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skins.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.util.UUIDTypeAdapter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lain.mods.skins.impl.Shared;
import lain.mods.skins.impl.forge.MinecraftUtils;

public class MojangService {
    private static final LoadingCache<GameProfile, Optional<GameProfile>> filledProfiles = CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.HOURS).refreshAfterWrite(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<GameProfile, Optional<GameProfile>>(){

        public Optional<GameProfile> load(GameProfile key) throws Exception {
            if (key.getId() == null || key.getProperties() == null || key == Shared.DUMMY) {
                return Optional.empty();
            }
            if (!key.getProperties().isEmpty()) {
                return Optional.of(key);
            }
            GameProfile filled = Shared.call(() -> MinecraftUtils.getSessionService().fetchProfile(key.getId(), false).profile(), key, null);
            if (filled == key) {
                return Optional.empty();
            }
            if (filled.getProperties().isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(filled);
        }

        public ListenableFuture<Optional<GameProfile>> reload(GameProfile key, Optional<GameProfile> oldValue) throws Exception {
            if (oldValue.isPresent()) {
                return Futures.immediateFuture(oldValue);
            }
            return Shared.submitTask(() -> this.load(key));
        }
    });
    private static final LoadingCache<String, Optional<GameProfile>> resolvedProfiles = CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.HOURS).refreshAfterWrite(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Optional<GameProfile>>(){
        private final Gson gson = new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).create();

        public Optional<GameProfile> load(String key) throws Exception {
            if (Shared.isBlank(key)) {
                return Optional.of(Shared.DUMMY);
            }
            return Optional.ofNullable(Shared.call(() -> this.makeRequest(String.format("https://api.mojang.com/users/profiles/minecraft/%s", key)), null, null));
        }

        private GameProfile makeRequest(String request) throws IOException {
            HttpURLConnection conn = (HttpURLConnection)new URL(request).openConnection(MinecraftUtils.getProxy());
            conn.setConnectTimeout(30000);
            conn.setReadTimeout(10000);
            conn.setUseCaches(false);
            conn.connect();
            int code = conn.getResponseCode();
            if (code == 204 || code == 404) {
                return Shared.DUMMY;
            }
            if (code / 100 == 2) {
                try (InputStream in = conn.getInputStream();){
                    StringBuilder buf = new StringBuilder();
                    this.readLines(in, buf);
                    GameProfile constructed = (GameProfile)this.gson.fromJson(buf.toString(), GameProfile.class);
                    if (Shared.isOfflinePlayer(constructed.getId(), constructed.getName())) {
                        GameProfile gameProfile = Shared.DUMMY;
                        return gameProfile;
                    }
                    GameProfile gameProfile = new GameProfile(constructed.getId(), constructed.getName());
                    return gameProfile;
                }
            }
            return null;
        }

        private void readLines(InputStream in, StringBuilder buf) throws IOException {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            String newLine = System.getProperty("line.separator");
            while ((line = reader.readLine()) != null) {
                if (buf.length() > 0) {
                    buf.append(newLine);
                }
                buf.append(line);
            }
        }

        public ListenableFuture<Optional<GameProfile>> reload(String key, Optional<GameProfile> oldValue) throws Exception {
            if (oldValue.isPresent()) {
                if (oldValue.get() == Shared.DUMMY) {
                    return Futures.immediateFuture(Optional.empty());
                }
                return Futures.immediateFuture(oldValue);
            }
            return Shared.submitTask(() -> this.load(key));
        }
    });

    public static ListenableFuture<GameProfile> fillProfile(GameProfile profile) {
        if (profile == null) {
            return Futures.immediateFailedFuture((Throwable)new NullPointerException("profile must not be null"));
        }
        Optional cachedResult = (Optional)filledProfiles.getIfPresent((Object)profile);
        if (cachedResult != null) {
            return Futures.immediateFuture((Object)cachedResult.orElse(profile));
        }
        return Shared.submitTask(() -> ((Optional)filledProfiles.getUnchecked((Object)profile)).orElse(profile));
    }

    public static ListenableFuture<GameProfile> getProfile(String username) {
        if (username == null) {
            return Futures.immediateFailedFuture((Throwable)new NullPointerException("username must not be null"));
        }
        Optional cachedResult = (Optional)resolvedProfiles.getIfPresent((Object)username);
        if (cachedResult != null) {
            return Futures.immediateFuture((Object)cachedResult.orElse(Shared.DUMMY));
        }
        return Shared.submitTask(() -> ((Optional)resolvedProfiles.getUnchecked((Object)username)).orElse(Shared.DUMMY));
    }
}

