/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skins.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.mojang.authlib.GameProfile;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lain.lib.Retries;
import lain.lib.SharedPool;
import lain.lib.SimpleDownloader;
import lain.mods.skins.impl.neoforge.MinecraftUtils;

public class Shared {
    public static final GameProfile DUMMY = new GameProfile(UUID.fromString("ae9460f5-bf72-468e-89b6-4eead59001ad"), "");
    private static final Cache<UUID, Boolean> offlines = CacheBuilder.newBuilder().weakKeys().build();

    public static <T> T call(Callable<T> callable, T defaultValue, Consumer<Throwable> consumer) {
        if (callable == null) {
            return defaultValue;
        }
        try {
            return callable.call();
        }
        catch (Throwable t) {
            if (consumer != null) {
                consumer.accept(t);
            }
            return defaultValue;
        }
    }

    public static byte[] readFile(File file, byte[] defaultContents, Consumer<Throwable> consumer) {
        if (file == null) {
            return defaultContents;
        }
        return Shared.call(() -> {
            try (FileChannel channel = FileChannel.open(file.toPath(), StandardOpenOption.READ);){
                byte[] byArray;
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    channel.transferTo(0L, Long.MAX_VALUE, Channels.newChannel(baos));
                    byArray = baos.toByteArray();
                }
                return byArray;
            }
        }, defaultContents, consumer);
    }

    public static CompletableFuture<Optional<byte[]>> downloadSkin(String resource, Executor executor) {
        return SimpleDownloader.start(Shared.encodeURL(resource), null, MinecraftUtils.getProxy(), 2, null, executor, null, Shared::preConnect, Shared::stopIfHttpClientError).thenApply(Shared::readAndDelete);
    }

    private static String encodeURL(String url) {
        try {
            return new URI(url).toASCIIString();
        }
        catch (NullPointerException | URISyntaxException e) {
            return url;
        }
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isOfflinePlayer(UUID id, String name) {
        if (id == null || Shared.isBlank(name)) {
            return true;
        }
        try {
            return (Boolean)offlines.get((Object)id, () -> UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(StandardCharsets.UTF_8)).equals(id));
        }
        catch (Throwable t) {
            return true;
        }
    }

    private static void preConnect(URLConnection conn) {
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(30000);
        conn.setUseCaches(true);
        conn.setDoInput(true);
        conn.setDoOutput(false);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Optional<byte[]> readAndDelete(Optional<Path> path) {
        try (FileChannel channel = FileChannel.open(path.orElseThrow(FileNotFoundException::new), StandardOpenOption.READ, StandardOpenOption.DELETE_ON_CLOSE);){
            Optional<byte[]> optional;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                channel.transferTo(0L, Long.MAX_VALUE, Channels.newChannel(baos));
                optional = Optional.of(baos.toByteArray());
            }
            return optional;
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    public static boolean sleep(long millis) {
        try {
            Thread.sleep(millis);
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    private static boolean stopIfHttpClientError(URLConnection conn) {
        if (conn instanceof HttpURLConnection) {
            try {
                if (((HttpURLConnection)conn).getResponseCode() / 100 == 4) {
                    return false;
                }
            }
            catch (IOException e) {
                Retries.rethrow(e);
            }
        }
        return true;
    }

    public static <T> ListenableFuture<T> submitTask(Callable<T> callable) {
        ListenableFutureTask future = ListenableFutureTask.create(callable);
        SharedPool.execute((Runnable)future);
        return future;
    }

    private static interface SupplierBlocker<T>
    extends Supplier<T>,
    ForkJoinPool.ManagedBlocker {
    }
}

