/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skins.impl.neoforge;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import lain.mods.skins.api.interfaces.ISkinTexture;
import net.minecraft.client.renderer.texture.HttpTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public class CustomSkinTexture
extends HttpTexture
implements ISkinTexture {
    private final WeakReference<ByteBuffer> _data;

    public CustomSkinTexture(ResourceLocation location, ByteBuffer data) {
        super(null, null, location, false, null);
        if (data == null) {
            throw new IllegalArgumentException("buffer must not be null");
        }
        this._data = new WeakReference<ByteBuffer>(data);
    }

    @Override
    public ByteBuffer getData() {
        return (ByteBuffer)this._data.get();
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    public NativeImage getImage() throws IOException {
        ByteBuffer buffer = this.getData();
        if (buffer == null) {
            throw new FileNotFoundException();
        }
        return NativeImage.read((ByteBuffer)buffer);
    }

    public void load(ResourceManager manager) throws IOException {
        NativeImage image = this.getImage();
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> this.upload(image));
        } else {
            this.upload(image);
        }
    }

    private void upload(NativeImage image) {
        TextureUtil.prepareImage((int)this.getId(), (int)0, (int)image.getWidth(), (int)image.getHeight());
        image.upload(0, 0, 0, true);
    }
}

