/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skins.impl.neoforge;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.authlib.GameProfile;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import lain.mods.skins.init.neoforge.Hooks;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;

public class SkinUtils {
    private static final Function<GameProfile, ResourceLocation> SKIN = profile -> Hooks.getSkinLocation(profile, null);
    private static final Function<GameProfile, ResourceLocation> CAPE = profile -> Hooks.getCapeLocation(profile, null);
    private static final Function<GameProfile, PlayerSkin.Model> MODEL = profile -> PlayerSkin.Model.byName((String)Hooks.getModelName(profile, null));
    private static final LoadingCache<GameProfile, Supplier<PlayerSkin>> skinSuppliers = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<GameProfile, Supplier<PlayerSkin>>(){

        public Supplier<PlayerSkin> load(GameProfile profile) throws Exception {
            AtomicReference HOLDER = new AtomicReference();
            return () -> {
                PlayerSkin skins = (PlayerSkin)HOLDER.get();
                ResourceLocation skinTexture = SKIN.apply(profile);
                ResourceLocation capeTexture = CAPE.apply(profile);
                PlayerSkin.Model model = MODEL.apply(profile);
                if (skins == null) {
                    if (skinTexture != null && !HOLDER.compareAndSet(null, skins = new PlayerSkin(skinTexture, null, capeTexture, null, model, false))) {
                        skins = (PlayerSkin)HOLDER.get();
                    }
                } else if (!(skinTexture == null || skins.texture() == skinTexture && skins.capeTexture() == capeTexture && skins.model() == model || HOLDER.compareAndSet(skins, skins = new PlayerSkin(skinTexture, null, capeTexture, null, model, false)))) {
                    skins = (PlayerSkin)HOLDER.get();
                }
                return skins;
            };
        }
    });

    public static PlayerSkin skins(GameProfile profile) {
        return (PlayerSkin)((Supplier)skinSuppliers.getUnchecked((Object)profile)).get();
    }
}

