/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skins.providers;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import lain.lib.SharedPool;
import lain.mods.skins.api.interfaces.IPlayerProfile;
import lain.mods.skins.api.interfaces.ISkin;
import lain.mods.skins.api.interfaces.ISkinProvider;
import lain.mods.skins.impl.Shared;
import lain.mods.skins.impl.SkinData;
import lain.mods.skins.impl.forge.ImageUtils;
import lain.mods.skins.impl.forge.MinecraftUtils;

public class MojangSkinProvider
implements ISkinProvider {
    private Function<ByteBuffer, ByteBuffer> _filter;

    @Override
    public ISkin getSkin(IPlayerProfile profile) {
        SkinData skin = new SkinData();
        if (this._filter != null) {
            skin.setSkinFilter(this._filter);
        }
        SharedPool.execute(() -> {
            MinecraftProfileTexture texture;
            if (!Shared.isOfflinePlayer(profile.getPlayerID(), profile.getPlayerName()) && (texture = MinecraftUtils.getSessionService().getTextures((GameProfile)profile.getOriginal()).skin()) != null) {
                ((CompletableFuture)Shared.downloadSkin(texture.getUrl(), Runnable::run).thenApply(Optional::get)).thenAccept(data -> {
                    if (ImageUtils.validateData(data)) {
                        skin.put((byte[])data, "slim".equals(texture.getMetadata("model")) ? "slim" : "default");
                    }
                });
            }
        });
        return skin;
    }

    public MojangSkinProvider withFilter(Function<ByteBuffer, ByteBuffer> filter) {
        this._filter = filter;
        return this;
    }
}

