/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import com.mojang.blaze3d.platform.GLX;
import java.nio.IntBuffer;
import java.util.List;
import net.optifine.reflect.Reflector;
import net.optifine.render.GlBlendState;
import net.optifine.render.GlCullState;
import net.optifine.render.ICamera;
import net.optifine.render.RenderTypes;
import net.optifine.shaders.ClippingHelperDummy;
import net.optifine.shaders.Shaders;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class ShadersRender {
    private static final vk END_PORTAL_TEXTURE = new vk("textures/entity/end_portal.png");

    public static void setFrustrumPosition(ICamera frustum, double x2, double y, double z) {
        frustum.setCameraPosition(x2, y, z);
    }

    public static void beginTerrainSolid() {
        if (Shaders.isRenderingWorld) {
            Shaders.fogEnabled = true;
            Shaders.useProgram(Shaders.ProgramTerrain);
        }
    }

    public static void beginTerrainCutoutMipped() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(Shaders.ProgramTerrain);
        }
    }

    public static void beginTerrainCutout() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(Shaders.ProgramTerrain);
        }
    }

    public static void endTerrain() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(Shaders.ProgramTexturedLit);
        }
    }

    public static void beginTranslucent() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(Shaders.ProgramWater);
        }
    }

    public static void endTranslucent() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(Shaders.ProgramTexturedLit);
        }
    }

    public static void renderHand0(dzz er, dfm matrixStackIn, djk activeRenderInfo, float partialTicks) {
        if (!Shaders.isShadowPass) {
            boolean blockTranslucentMain = Shaders.isItemToRenderMainTranslucent();
            boolean blockTranslucentOff = Shaders.isItemToRenderOffTranslucent();
            if (!blockTranslucentMain || !blockTranslucentOff) {
                Shaders.readCenterDepth();
                Shaders.beginHand(matrixStackIn, false);
                GL30.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Shaders.setSkipRenderHands(blockTranslucentMain, blockTranslucentOff);
                er.renderHand(matrixStackIn, activeRenderInfo, partialTicks, true, false, false);
                Shaders.endHand(matrixStackIn);
                Shaders.setHandsRendered(!blockTranslucentMain, !blockTranslucentOff);
                Shaders.setSkipRenderHands(false, false);
            }
        }
    }

    public static void renderHand1(dzz er, dfm matrixStackIn, djk activeRenderInfo, float partialTicks) {
        if (!Shaders.isShadowPass && !Shaders.isBothHandsRendered()) {
            Shaders.readCenterDepth();
            dem.o();
            Shaders.beginHand(matrixStackIn, true);
            GL30.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Shaders.setSkipRenderHands(Shaders.isHandRenderedMain(), Shaders.isHandRenderedOff());
            er.renderHand(matrixStackIn, activeRenderInfo, partialTicks, true, false, true);
            Shaders.endHand(matrixStackIn);
            Shaders.setHandsRendered(true, true);
            Shaders.setSkipRenderHands(false, false);
        }
    }

    public static void renderItemFP(eac itemRenderer, float partialTicks, dfm matrixStackIn, eag.a bufferIn, dzm playerEntityIn, int combinedLightIn, boolean renderTranslucent) {
        dem.a((boolean)true);
        if (renderTranslucent) {
            dem.b((int)519);
            matrixStackIn.a();
            IntBuffer drawBuffers = Shaders.activeDrawBuffers;
            Shaders.setDrawBuffers(Shaders.drawBuffersNone);
            Shaders.renderItemKeepDepthMask = true;
            itemRenderer.a(partialTicks, matrixStackIn, bufferIn, playerEntityIn, combinedLightIn);
            Shaders.renderItemKeepDepthMask = false;
            Shaders.setDrawBuffers(drawBuffers);
            matrixStackIn.b();
        }
        dem.b((int)515);
        GL30.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        itemRenderer.a(partialTicks, matrixStackIn, bufferIn, playerEntityIn, combinedLightIn);
    }

    public static void renderFPOverlay(dzz er, dfm matrixStackIn, djk activeRenderInfo, float partialTicks) {
        if (!Shaders.isShadowPass) {
            Shaders.beginFPOverlay();
            er.renderHand(matrixStackIn, activeRenderInfo, partialTicks, false, true, false);
            Shaders.endFPOverlay();
        }
    }

    public static void beginBlockDamage() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(Shaders.ProgramDamagedBlock);
            if (Shaders.ProgramDamagedBlock.getId() == Shaders.ProgramTerrain.getId()) {
                Shaders.setDrawBuffers(Shaders.drawBuffersColorAtt0);
                dem.a((boolean)false);
            }
        }
    }

    public static void endBlockDamage() {
        if (Shaders.isRenderingWorld) {
            dem.a((boolean)true);
            Shaders.useProgram(Shaders.ProgramTexturedLit);
        }
    }

    public static void renderShadowMap(dzz entityRenderer, djk activeRenderInfo, int pass, float partialTicks, long finishTimeNano) {
        if (Shaders.usedShadowDepthBuffers > 0 && --Shaders.shadowPassCounter <= 0) {
            djz mc = djz.C();
            mc.au().b("shadow pass");
            eae renderGlobal = mc.e;
            Shaders.isShadowPass = true;
            Shaders.shadowPassCounter = Shaders.shadowPassInterval;
            Shaders.checkGLError("pre shadow");
            GL30.glMatrixMode((int)5889);
            GL11.glPushMatrix();
            GL30.glMatrixMode((int)5888);
            GL11.glPushMatrix();
            mc.au().b("shadow clear");
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)Shaders.sfb);
            Shaders.checkGLError("shadow bind sfb");
            mc.au().b("shadow camera");
            ShadersRender.updateActiveRenderInfo(activeRenderInfo, mc, partialTicks);
            dfm matrixStack = new dfm();
            Shaders.setCameraShadow(matrixStack, activeRenderInfo, partialTicks);
            Shaders.checkGLError("shadow camera");
            Shaders.useProgram(Shaders.ProgramShadow);
            GL30.glDrawBuffers((IntBuffer)Shaders.sfbDrawBuffers);
            Shaders.checkGLError("shadow drawbuffers");
            GL30.glReadBuffer((int)0);
            Shaders.checkGLError("shadow readbuffer");
            EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36096, (int)3553, (int)Shaders.sfbDepthTextures.get(0), (int)0);
            if (Shaders.usedShadowColorBuffers != 0) {
                EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36064, (int)3553, (int)Shaders.sfbColorTextures.get(0), (int)0);
            }
            Shaders.checkFramebufferStatus("shadow fb");
            GL30.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL30.glClear((int)(Shaders.usedShadowColorBuffers != 0 ? 16640 : 256));
            Shaders.checkGLError("shadow clear");
            mc.au().b("shadow frustum");
            ClippingHelperDummy frustum = new ClippingHelperDummy();
            mc.au().b("shadow culling");
            dcn cameraPos = activeRenderInfo.b();
            frustum.a(cameraPos.b, cameraPos.c, cameraPos.d);
            dem.t((int)7425);
            dem.m();
            dem.b((int)515);
            dem.a((boolean)true);
            dem.a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            dem.lockCull((GlCullState)new GlCullState(false));
            dem.lockBlend((GlBlendState)new GlBlendState(false));
            mc.au().b("shadow prepareterrain");
            mc.M().a(ekb.d);
            mc.au().b("shadow setupterrain");
            int frameCount = mc.e.getNextFrameCount();
            renderGlobal.a(activeRenderInfo, (ecz)frustum, false, frameCount, mc.s.a_());
            mc.au().b("shadow updatechunks");
            mc.au().b("shadow terrain");
            double x2 = cameraPos.a();
            double y = cameraPos.b();
            double z = cameraPos.c();
            dem.w((int)5888);
            dem.Q();
            dem.d();
            renderGlobal.a(RenderTypes.SOLID, matrixStack, x2, y, z);
            Shaders.checkGLError("shadow terrain solid");
            dem.e();
            renderGlobal.a(RenderTypes.CUTOUT_MIPPED, matrixStack, x2, y, z);
            Shaders.checkGLError("shadow terrain cutoutmipped");
            mc.M().b(ekb.d).a(false, false);
            renderGlobal.a(RenderTypes.CUTOUT, matrixStack, x2, y, z);
            Shaders.checkGLError("shadow terrain cutout");
            mc.M().b(ekb.d).restoreLastBlurMipmap();
            dem.t((int)7424);
            dem.a((int)516, (float)0.1f);
            dem.w((int)5888);
            dem.R();
            dem.Q();
            mc.au().b("shadow entities");
            eae wr = mc.e;
            eet renderManager = mc.ac();
            eag.a irendertypebuffer = wr.getRenderTypeTextures().b();
            boolean playerShadowPass = Shaders.isShadowPass && !mc.s.a_();
            for (eae.a info : wr.getRenderInfosEntities()) {
                ecu.c renderChunk = info.b;
                cgh chunk = renderChunk.getChunk();
                aes cimm = chunk.z()[renderChunk.e().v() / 16];
                for (aqa entity : cimm) {
                    if (!renderManager.a(entity, (ecz)frustum, x2, y, z) && !entity.y((aqa)mc.s) || entity == activeRenderInfo.g() && !playerShadowPass && !activeRenderInfo.i() && (!(activeRenderInfo.g() instanceof aqm) || !((aqm)activeRenderInfo.g()).em()) || entity instanceof dzm && activeRenderInfo.g() != entity) continue;
                    wr.renderedEntity = entity;
                    Shaders.nextEntity(entity);
                    wr.a(entity, x2, y, z, partialTicks, matrixStack, (eag)irendertypebuffer);
                    wr.renderedEntity = null;
                }
            }
            wr.a(matrixStack);
            irendertypebuffer.a(eao.b((vk)ekb.d));
            irendertypebuffer.a(eao.c((vk)ekb.d));
            irendertypebuffer.a(eao.d((vk)ekb.d));
            irendertypebuffer.a(eao.i((vk)ekb.d));
            Shaders.endEntities();
            Shaders.beginBlockEntities();
            ecn.updateTextRenderDistance();
            boolean forgeRenderBoundingBox = Reflector.IForgeTileEntity_getRenderBoundingBox.exists();
            ClippingHelperDummy camera = frustum;
            for (eae.a worldrenderer$localrenderinformationcontainer : wr.getRenderInfosTileEntities()) {
                List list = worldrenderer$localrenderinformationcontainer.b.c().b();
                if (list.isEmpty()) continue;
                for (ccj tileentity1 : list) {
                    dci aabb;
                    if (forgeRenderBoundingBox && (aabb = (dci)Reflector.call(tileentity1, Reflector.IForgeTileEntity_getRenderBoundingBox, new Object[0])) != null && !camera.a(aabb)) continue;
                    Shaders.nextBlockEntity(tileentity1);
                    fx blockpos3 = tileentity1.o();
                    matrixStack.a();
                    matrixStack.a((double)blockpos3.u() - x2, (double)blockpos3.v() - y, (double)blockpos3.w() - z);
                    ecd.a.a(tileentity1, partialTicks, matrixStack, (eag)irendertypebuffer);
                    matrixStack.b();
                }
            }
            wr.a(matrixStack);
            irendertypebuffer.a(eao.c());
            irendertypebuffer.a(ear.g());
            irendertypebuffer.a(ear.h());
            irendertypebuffer.a(ear.c());
            irendertypebuffer.a(ear.d());
            irendertypebuffer.a(ear.e());
            irendertypebuffer.a(ear.f());
            irendertypebuffer.a();
            Shaders.endBlockEntities();
            Shaders.checkGLError("shadow entities");
            dem.w((int)5888);
            dem.R();
            dem.a((boolean)true);
            dem.n();
            dem.unlockCull();
            dem.C();
            dem.b((int)770, (int)771, (int)1, (int)0);
            dem.a((int)516, (float)0.1f);
            if (Shaders.usedShadowDepthBuffers >= 2) {
                dem.q((int)33989);
                Shaders.checkGLError("pre copy shadow depth");
                GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)Shaders.shadowMapWidth, (int)Shaders.shadowMapHeight);
                Shaders.checkGLError("copy shadow depth");
                dem.q((int)33984);
            }
            dem.n();
            dem.a((boolean)true);
            mc.M().a(ekb.d);
            dem.t((int)7425);
            Shaders.checkGLError("shadow pre-translucent");
            GL30.glDrawBuffers((IntBuffer)Shaders.sfbDrawBuffers);
            Shaders.checkGLError("shadow drawbuffers pre-translucent");
            Shaders.checkFramebufferStatus("shadow pre-translucent");
            if (Shaders.isRenderShadowTranslucent()) {
                mc.au().b("shadow translucent");
                renderGlobal.a(RenderTypes.TRANSLUCENT, matrixStack, x2, y, z);
                Shaders.checkGLError("shadow translucent");
            }
            dem.unlockBlend();
            dem.t((int)7424);
            dem.a((boolean)true);
            dem.C();
            dem.n();
            GL30.glFlush();
            Shaders.checkGLError("shadow flush");
            Shaders.isShadowPass = false;
            mc.au().b("shadow postprocess");
            if (Shaders.hasGlGenMipmap) {
                if (Shaders.usedShadowDepthBuffers >= 1) {
                    if (Shaders.shadowMipmapEnabled[0]) {
                        dem.q((int)33988);
                        dem.s((int)Shaders.sfbDepthTextures.get(0));
                        GL30.glGenerateMipmap((int)3553);
                        GL30.glTexParameteri((int)3553, (int)10241, (int)(Shaders.shadowFilterNearest[0] ? 9984 : 9987));
                    }
                    if (Shaders.usedShadowDepthBuffers >= 2 && Shaders.shadowMipmapEnabled[1]) {
                        dem.q((int)33989);
                        dem.s((int)Shaders.sfbDepthTextures.get(1));
                        GL30.glGenerateMipmap((int)3553);
                        GL30.glTexParameteri((int)3553, (int)10241, (int)(Shaders.shadowFilterNearest[1] ? 9984 : 9987));
                    }
                    dem.q((int)33984);
                }
                if (Shaders.usedShadowColorBuffers >= 1) {
                    if (Shaders.shadowColorMipmapEnabled[0]) {
                        dem.q((int)33997);
                        dem.s((int)Shaders.sfbColorTextures.get(0));
                        GL30.glGenerateMipmap((int)3553);
                        GL30.glTexParameteri((int)3553, (int)10241, (int)(Shaders.shadowColorFilterNearest[0] ? 9984 : 9987));
                    }
                    if (Shaders.usedShadowColorBuffers >= 2 && Shaders.shadowColorMipmapEnabled[1]) {
                        dem.q((int)33998);
                        dem.s((int)Shaders.sfbColorTextures.get(1));
                        GL30.glGenerateMipmap((int)3553);
                        GL30.glTexParameteri((int)3553, (int)10241, (int)(Shaders.shadowColorFilterNearest[1] ? 9984 : 9987));
                    }
                    dem.q((int)33984);
                }
            }
            Shaders.checkGLError("shadow postprocess");
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)Shaders.dfb);
            GL11.glViewport((int)0, (int)0, (int)Shaders.renderWidth, (int)Shaders.renderHeight);
            Shaders.activeDrawBuffers = null;
            mc.M().a(ekb.d);
            Shaders.useProgram(Shaders.ProgramTerrain);
            GL30.glMatrixMode((int)5888);
            GL11.glPopMatrix();
            GL30.glMatrixMode((int)5889);
            GL11.glPopMatrix();
            GL30.glMatrixMode((int)5888);
            Shaders.checkGLError("shadow end");
        }
    }

    public static void updateActiveRenderInfo(djk activeRenderInfo, djz mc, float partialTicks) {
        activeRenderInfo.a((brc)mc.r, (aqa)(mc.aa() == null ? mc.s : mc.aa()), !mc.k.g().a(), mc.k.g().b(), partialTicks);
    }

    public static void preRenderChunkLayer(eao blockLayerIn) {
        if (blockLayerIn == RenderTypes.SOLID) {
            ShadersRender.beginTerrainSolid();
        }
        if (blockLayerIn == RenderTypes.CUTOUT_MIPPED) {
            ShadersRender.beginTerrainCutoutMipped();
        }
        if (blockLayerIn == RenderTypes.CUTOUT) {
            ShadersRender.beginTerrainCutout();
        }
        if (blockLayerIn == RenderTypes.TRANSLUCENT) {
            ShadersRender.beginTranslucent();
        }
        if (Shaders.isRenderBackFace(blockLayerIn)) {
            dem.D();
        }
        if (GLX.useVbo()) {
            GL20.glEnableVertexAttribArray((int)Shaders.midTexCoordAttrib);
            GL20.glEnableVertexAttribArray((int)Shaders.tangentAttrib);
            GL20.glEnableVertexAttribArray((int)Shaders.entityAttrib);
        }
    }

    public static void postRenderChunkLayer(eao blockLayerIn) {
        if (GLX.useVbo()) {
            GL20.glDisableVertexAttribArray((int)Shaders.midTexCoordAttrib);
            GL20.glDisableVertexAttribArray((int)Shaders.tangentAttrib);
            GL20.glDisableVertexAttribArray((int)Shaders.entityAttrib);
        }
        if (Shaders.isRenderBackFace(blockLayerIn)) {
            dem.C();
        }
    }

    public static void preRender(eao renderType, dfh buffer) {
        if (!Shaders.isRenderingWorld) {
            return;
        }
        if (Shaders.isShadowPass) {
            return;
        }
        if (renderType.isGlint()) {
            ShadersRender.renderEnchantedGlintBegin();
        } else if (renderType.getName().equals("eyes")) {
            Shaders.beginSpiderEyes();
        } else if (renderType.getName().equals("crumbling")) {
            ShadersRender.beginBlockDamage();
        } else if (renderType == eao.V) {
            Shaders.beginLeash();
        }
    }

    public static void postRender(eao renderType, dfh buffer) {
        if (!Shaders.isRenderingWorld) {
            return;
        }
        if (Shaders.isShadowPass) {
            return;
        }
        if (renderType.isGlint()) {
            ShadersRender.renderEnchantedGlintEnd();
        } else if (renderType.getName().equals("eyes")) {
            Shaders.endSpiderEyes();
        } else if (renderType.getName().equals("crumbling")) {
            ShadersRender.endBlockDamage();
        } else if (renderType == eao.V) {
            Shaders.endLeash();
        }
    }

    public static void setupArrayPointersVbo() {
        int vertexSizeI = 16;
        GL20.glVertexAttribPointer((int)Shaders.midTexCoordAttrib, (int)2, (int)5126, (boolean)false, (int)64, (long)36L);
        GL20.glVertexAttribPointer((int)Shaders.tangentAttrib, (int)4, (int)5122, (boolean)false, (int)64, (long)44L);
        GL20.glVertexAttribPointer((int)Shaders.entityAttrib, (int)3, (int)5122, (boolean)false, (int)64, (long)52L);
    }

    public static void beaconBeamBegin() {
        Shaders.useProgram(Shaders.ProgramBeaconBeam);
    }

    public static void beaconBeamStartQuad1() {
    }

    public static void beaconBeamStartQuad2() {
    }

    public static void beaconBeamDraw1() {
    }

    public static void beaconBeamDraw2() {
        dem.n();
    }

    public static void renderEnchantedGlintBegin() {
        Shaders.useProgram(Shaders.ProgramArmorGlint);
    }

    public static void renderEnchantedGlintEnd() {
        if (Shaders.isRenderingWorld) {
            if (Shaders.isRenderingFirstPersonHand() && Shaders.isRenderBothHands()) {
                Shaders.useProgram(Shaders.ProgramHand);
            } else {
                Shaders.useProgram(Shaders.ProgramEntities);
            }
        } else {
            Shaders.useProgram(Shaders.ProgramNone);
        }
    }

    public static boolean renderEndPortal(cdl te, float partialTicks, float offset, dfm matrixStackIn, eag bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float zn;
        float yn;
        float xn;
        float zv;
        float yv;
        float xv;
        gr vec3i;
        float du;
        if (!Shaders.isShadowPass && Shaders.activeProgram.getId() == 0) {
            return false;
        }
        dem.g();
        dfm.a matrixEntry = matrixStackIn.c();
        b matrix = matrixEntry.a();
        a matrixNormal = matrixEntry.b();
        dfq bufferbuilder = bufferIn.getBuffer(eao.b((vk)END_PORTAL_TEXTURE));
        float col = 0.5f;
        float r2 = col * 0.15f;
        float g2 = col * 0.3f;
        float b2 = col * 0.4f;
        float u0 = 0.0f;
        float u1 = 0.2f;
        float v0 = u0;
        float v1 = u1;
        float dv = du = (float)(System.currentTimeMillis() % 100000L) / 100000.0f;
        float dy = offset;
        int lm = combinedLightIn;
        int ov = combinedOverlayIn;
        float x2 = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        if (te.a(gc.d)) {
            vec3i = gc.d.p();
            xv = vec3i.u();
            yv = vec3i.v();
            zv = vec3i.w();
            xn = matrixNormal.getTransformX(xv, yv, zv);
            yn = matrixNormal.getTransformY(xv, yv, zv);
            zn = matrixNormal.getTransformZ(xv, yv, zv);
            bufferbuilder.a(matrix, x2, y, z + 1.0f).a(r2, g2, b2, 1.0f).a(u0 + du, v0 + dv).b(ov).a(lm).b(xn, yn, zn).d();
            bufferbuilder.a(matrix, x2 + 1.0f, y, z + 1.0f).a(r2, g2, b2, 1.0f).a(u0 + du, v1 + dv).b(ov).a(lm).b(xn, yn, zn).d();
            bufferbuilder.a(matrix, x2 + 1.0f, y + 1.0f, z + 1.0f).a(r2, g2, b2, 1.0f).a(u1 + du, v1 + dv).b(ov).a(lm).b(xn, yn, zn).d();
            bufferbuilder.a(matrix, x2, y + 1.0f, z + 1.0f).a(r2, g2, b2, 1.0f).a(u1 + du, v0 + dv).b(ov).a(lm).b(xn, yn, zn).d();
        }
        if (te.a(gc.c)) {
            vec3i = gc.c.p();
            xv = vec3i.u();
            yv = vec3i.v();
            zv = vec3i.w();
            xn = matrixNormal.getTransformX(xv, yv, zv);
            yn = matrixNormal.getTransformY(xv, yv, zv);
            zn = matrixNormal.getTransformZ(xv, yv, zv);
            bufferbuilder.a(matrix, x2, y + 1.0f, z).a(r2, g2, b2, 1.0f).a(u1 + du, v1 + dv).b(ov).a(lm).b(xn, yn, zn).d();
            bufferbuilder.a(matrix, x2 + 1.0f, y + 1.0f, z).a(r2, g2, b2, 1.0f).a(u1 + du, v0 + dv).b(ov).a(lm).b(xn, yn, zn).d();
            bufferbuilder.a(matrix, x2 + 1.0f, y, z).a(r2, g2, b2, 1.0f).a(u0 + du, v0 + dv).b(ov).a(lm).b(xn, yn, zn).d();
            bufferbuilder.a(matrix, x2, y, z).a(r2, g2, b2, 1.0f).a(u0 + du, v1 + dv).b(ov).a(lm).b(xn, yn, zn).d();
        }
        if (te.a(gc.f)) {
            vec3i = gc.f.p();
            xv = vec3i.u();
            yv = vec3i.v();
            zv = vec3i.w();
            xn = matrixNormal.getTransformX(xv, yv, zv);
            yn = matrixNormal.getTransformY(xv, yv, zv);
            zn = matrixNormal.getTransformZ(xv, yv, zv);
            bufferbuilder.a(matrix, x2 + 1.0f, y + 1.0f, z).a(r2, g2, b2, 1.0f).a(u1 + du, v1 + dv).b(ov).a(lm).b(xn, yn, zn).d();
            bufferbuilder.a(matrix, x2 + 1.0f, y + 1.0f, z + 1.0f).a(r2, g2, b2, 1.0f).a(u1 + du, v0 + dv).b(ov).a(lm).b(xn, yn, zn).d();
            bufferbuilder.a(matrix, x2 + 1.0f, y, z + 1.0f).a(r2, g2, b2, 1.0f).a(u0 + du, v0 + dv).b(ov).a(lm).b(xn, yn, zn).d();
            bufferbuilder.a(matrix, x2 + 1.0f, y, z).a(r2, g2, b2, 1.0f).a(u0 + du, v1 + dv).b(ov).a(lm).b(xn, yn, zn).d();
        }
        if (te.a(gc.e)) {
            vec3i = gc.e.p();
            xv = vec3i.u();
            yv = vec3i.v();
            zv = vec3i.w();
            xn = matrixNormal.getTransformX(xv, yv, zv);
            yn = matrixNormal.getTransformY(xv, yv, zv);
            zn = matrixNormal.getTransformZ(xv, yv, zv);
            bufferbuilder.a(matrix, x2, y, z).a(r2, g2, b2, 1.0f).a(u0 + du, v0 + dv).b(ov).a(lm).b(xn, yn, zn).d();
            bufferbuilder.a(matrix, x2, y, z + 1.0f).a(r2, g2, b2, 1.0f).a(u0 + du, v1 + dv).b(ov).a(lm).b(xn, yn, zn).d();
            bufferbuilder.a(matrix, x2, y + 1.0f, z + 1.0f).a(r2, g2, b2, 1.0f).a(u1 + du, v1 + dv).b(ov).a(lm).b(xn, yn, zn).d();
            bufferbuilder.a(matrix, x2, y + 1.0f, z).a(r2, g2, b2, 1.0f).a(u1 + du, v0 + dv).b(ov).a(lm).b(xn, yn, zn).d();
        }
        if (te.a(gc.a)) {
            vec3i = gc.a.p();
            xv = vec3i.u();
            yv = vec3i.v();
            zv = vec3i.w();
            xn = matrixNormal.getTransformX(xv, yv, zv);
            yn = matrixNormal.getTransformY(xv, yv, zv);
            zn = matrixNormal.getTransformZ(xv, yv, zv);
            bufferbuilder.a(matrix, x2, y, z).a(r2, g2, b2, 1.0f).a(u0 + du, v0 + dv).b(ov).a(lm).b(xn, yn, zn).d();
            bufferbuilder.a(matrix, x2 + 1.0f, y, z).a(r2, g2, b2, 1.0f).a(u0 + du, v1 + dv).b(ov).a(lm).b(xn, yn, zn).d();
            bufferbuilder.a(matrix, x2 + 1.0f, y, z + 1.0f).a(r2, g2, b2, 1.0f).a(u1 + du, v1 + dv).b(ov).a(lm).b(xn, yn, zn).d();
            bufferbuilder.a(matrix, x2, y, z + 1.0f).a(r2, g2, b2, 1.0f).a(u1 + du, v0 + dv).b(ov).a(lm).b(xn, yn, zn).d();
        }
        if (te.a(gc.b)) {
            vec3i = gc.b.p();
            xv = vec3i.u();
            yv = vec3i.v();
            zv = vec3i.w();
            xn = matrixNormal.getTransformX(xv, yv, zv);
            yn = matrixNormal.getTransformY(xv, yv, zv);
            zn = matrixNormal.getTransformZ(xv, yv, zv);
            bufferbuilder.a(matrix, x2, y + dy, z + 1.0f).a(r2, g2, b2, 1.0f).a(u0 + du, v0 + dv).b(ov).a(lm).b(xn, yn, zn).d();
            bufferbuilder.a(matrix, x2 + 1.0f, y + dy, z + 1.0f).a(r2, g2, b2, 1.0f).a(u0 + du, v1 + dv).b(ov).a(lm).b(xn, yn, zn).d();
            bufferbuilder.a(matrix, x2 + 1.0f, y + dy, z).a(r2, g2, b2, 1.0f).a(u1 + du, v1 + dv).b(ov).a(lm).b(xn, yn, zn).d();
            bufferbuilder.a(matrix, x2, y + dy, z).a(r2, g2, b2, 1.0f).a(u1 + du, v0 + dv).b(ov).a(lm).b(xn, yn, zn).d();
        }
        dem.f();
        return true;
    }
}

