/*
 * Decompiled with CFR 0.152.
 */
package com.androsa.ornamental.blocks;

import com.androsa.ornamental.OrnamentalMod;
import com.androsa.ornamental.blocks.IOrnamentalBlock;
import com.androsa.ornamental.blocks.OrnamentSlab;
import com.androsa.ornamental.blocks.PoleType;
import com.androsa.ornamental.builder.OrnamentBuilder;
import com.androsa.ornamental.registry.ModBlocks;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShovelItem;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;

public class OrnamentBeam
extends Block
implements IWaterLoggable,
IOrnamentalBlock {
    protected static final VoxelShape BL_SHAPE_X = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
    protected static final VoxelShape BR_SHAPE_X = Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape TL_SHAPE_X = Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape TR_SHAPE_X = Block.func_208617_a((double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape BL_SHAPE_Z = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0);
    protected static final VoxelShape BR_SHAPE_Z = Block.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape TL_SHAPE_Z = Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape TR_SHAPE_Z = Block.func_208617_a((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape BL_SHAPE_X_PATH = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)8.0);
    protected static final VoxelShape BR_SHAPE_X_PATH = Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)7.0, (double)16.0);
    protected static final VoxelShape TL_SHAPE_X_PATH = Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)15.0, (double)8.0);
    protected static final VoxelShape TR_SHAPE_X_PATH = Block.func_208617_a((double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)15.0, (double)16.0);
    protected static final VoxelShape BL_SHAPE_Z_PATH = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)7.0, (double)16.0);
    protected static final VoxelShape BR_SHAPE_Z_PATH = Block.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    protected static final VoxelShape TL_SHAPE_Z_PATH = Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)15.0, (double)16.0);
    protected static final VoxelShape TR_SHAPE_Z_PATH = Block.func_208617_a((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    private static VoxelShape[] BEAM_SHAPES_X = new VoxelShape[]{TL_SHAPE_X, TR_SHAPE_X, BL_SHAPE_X, BR_SHAPE_X};
    private static VoxelShape[] BEAM_SHAPES_Z = new VoxelShape[]{TL_SHAPE_Z, TR_SHAPE_Z, BL_SHAPE_Z, BR_SHAPE_Z};
    private static VoxelShape[] BEAM_SHAPES_X_PATH = new VoxelShape[]{TL_SHAPE_X_PATH, TR_SHAPE_X_PATH, BL_SHAPE_X_PATH, BR_SHAPE_X_PATH};
    private static VoxelShape[] BEAM_SHAPES_Z_PATH = new VoxelShape[]{TL_SHAPE_Z_PATH, TR_SHAPE_Z_PATH, BL_SHAPE_Z_PATH, BR_SHAPE_Z_PATH};
    public static final EnumProperty<PoleType> TYPE = EnumProperty.func_177709_a((String)"type", PoleType.class);
    public static final EnumProperty<Direction.Axis> HORIZONTAL_AXIS = BlockStateProperties.field_208199_z;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private final OrnamentBuilder builder;

    public OrnamentBeam(AbstractBlock.Properties props, OrnamentBuilder builder) {
        super(props);
        this.builder = builder;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(TYPE, (Comparable)((Object)PoleType.BL_CORNER))).func_206870_a(HORIZONTAL_AXIS, (Comparable)Direction.Axis.X)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{TYPE, HORIZONTAL_AXIS, WATERLOGGED});
    }

    @Override
    public OrnamentBuilder getBuilder() {
        return this.builder;
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        Optional optional;
        int i;
        ArrayList shapes = Lists.newArrayList();
        PoleType type = (PoleType)((Object)state.func_177229_b(TYPE));
        Direction.Axis axis = (Direction.Axis)state.func_177229_b(HORIZONTAL_AXIS);
        boolean[] corners = type.getCorners();
        if (this.builder.isPath || this.builder.pathShape) {
            if (type == PoleType.L_HALF) {
                return axis == Direction.Axis.X ? VoxelShapes.func_197872_a((VoxelShape)BL_SHAPE_X, (VoxelShape)TL_SHAPE_X_PATH) : VoxelShapes.func_197872_a((VoxelShape)BL_SHAPE_Z, (VoxelShape)TL_SHAPE_Z_PATH);
            }
            if (type == PoleType.R_HALF) {
                return axis == Direction.Axis.X ? VoxelShapes.func_197872_a((VoxelShape)BR_SHAPE_X, (VoxelShape)TR_SHAPE_X_PATH) : VoxelShapes.func_197872_a((VoxelShape)BR_SHAPE_Z, (VoxelShape)TR_SHAPE_Z_PATH);
            }
            if (type == PoleType.TL_FILL) {
                return axis == Direction.Axis.X ? VoxelShapes.func_216384_a((VoxelShape)BL_SHAPE_X, (VoxelShape[])new VoxelShape[]{TL_SHAPE_X_PATH, TR_SHAPE_X_PATH}) : VoxelShapes.func_216384_a((VoxelShape)BL_SHAPE_Z, (VoxelShape[])new VoxelShape[]{TL_SHAPE_Z_PATH, TR_SHAPE_Z_PATH});
            }
            if (type == PoleType.TR_FILL) {
                return axis == Direction.Axis.X ? VoxelShapes.func_216384_a((VoxelShape)BR_SHAPE_X, (VoxelShape[])new VoxelShape[]{TL_SHAPE_X_PATH, TR_SHAPE_X_PATH}) : VoxelShapes.func_216384_a((VoxelShape)BR_SHAPE_Z, (VoxelShape[])new VoxelShape[]{TL_SHAPE_Z_PATH, TR_SHAPE_Z_PATH});
            }
            if (type == PoleType.BL_FILL) {
                return axis == Direction.Axis.X ? VoxelShapes.func_216384_a((VoxelShape)BL_SHAPE_X, (VoxelShape[])new VoxelShape[]{BR_SHAPE_X_PATH, TL_SHAPE_X_PATH}) : VoxelShapes.func_216384_a((VoxelShape)BL_SHAPE_Z, (VoxelShape[])new VoxelShape[]{BR_SHAPE_Z_PATH, TL_SHAPE_Z_PATH});
            }
            if (type == PoleType.BR_FILL) {
                return axis == Direction.Axis.X ? VoxelShapes.func_216384_a((VoxelShape)BR_SHAPE_X, (VoxelShape[])new VoxelShape[]{BL_SHAPE_X_PATH, TR_SHAPE_X_PATH}) : VoxelShapes.func_216384_a((VoxelShape)BR_SHAPE_Z, (VoxelShape[])new VoxelShape[]{BL_SHAPE_Z_PATH, TR_SHAPE_Z_PATH});
            }
            if (type == PoleType.FULL) {
                return OrnamentSlab.PATH_FULL_SHAPE;
            }
            for (i = 0; i < corners.length; ++i) {
                if (!corners[i]) continue;
                if (state.func_177229_b(HORIZONTAL_AXIS) == Direction.Axis.X) {
                    shapes.add(BEAM_SHAPES_X_PATH[i]);
                    continue;
                }
                shapes.add(BEAM_SHAPES_Z_PATH[i]);
            }
        } else {
            for (i = 0; i < corners.length; ++i) {
                if (!corners[i]) continue;
                if (state.func_177229_b(HORIZONTAL_AXIS) == Direction.Axis.X) {
                    shapes.add(BEAM_SHAPES_X[i]);
                    continue;
                }
                shapes.add(BEAM_SHAPES_Z[i]);
            }
        }
        if (!(optional = shapes.stream().reduce(VoxelShapes::func_197872_a)).isPresent()) {
            OrnamentalMod.LOGGER.error("Ornament Pole had no shapes! Resorting to full cube");
            return VoxelShapes.func_197868_b();
        }
        return (VoxelShape)optional.get();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        BlockState state = context.func_195991_k().func_180495_p(pos);
        boolean x = context.func_221532_j().field_72450_a - (double)context.func_195995_a().func_177958_n() < 0.5;
        boolean y = context.func_221532_j().field_72448_b - (double)context.func_195995_a().func_177956_o() < 0.5;
        boolean z = context.func_221532_j().field_72449_c - (double)context.func_195995_a().func_177952_p() < 0.5;
        FluidState fluidstate = context.func_195991_k().func_204610_c(pos);
        boolean filled = fluidstate.func_206886_c() == Fluids.field_204546_a;
        Direction direction = context.func_196000_l();
        Direction.Axis facing = context.func_195992_f().func_176740_k();
        Direction.Axis axis = direction.func_176740_k();
        if (state.func_203425_a((Block)this)) {
            Direction.Axis stateAxis = (Direction.Axis)state.func_177229_b(HORIZONTAL_AXIS);
            switch ((PoleType)((Object)state.func_177229_b(TYPE))) {
                case TL_FILL: 
                case TR_FILL: 
                case BL_FILL: 
                case BR_FILL: {
                    return (BlockState)((BlockState)state.func_206870_a(TYPE, (Comparable)((Object)PoleType.FULL))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
                }
                case TL_CORNER: {
                    if ((!z && stateAxis == Direction.Axis.X || !x && stateAxis == Direction.Axis.Z) && !y) {
                        return (BlockState)((BlockState)state.func_206870_a(TYPE, (Comparable)((Object)PoleType.T_HALF))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
                    }
                    if (z && stateAxis == Direction.Axis.X || x && stateAxis == Direction.Axis.Z) {
                        return (BlockState)((BlockState)state.func_206870_a(TYPE, (Comparable)((Object)PoleType.L_HALF))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
                    }
                    return (BlockState)((BlockState)state.func_206870_a(TYPE, (Comparable)((Object)PoleType.TL_BR))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
                }
                case TR_CORNER: {
                    if (((z || direction == Direction.NORTH) && stateAxis == Direction.Axis.X || (x || direction == Direction.WEST) && stateAxis == Direction.Axis.Z) && !y) {
                        return (BlockState)((BlockState)state.func_206870_a(TYPE, (Comparable)((Object)PoleType.T_HALF))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
                    }
                    if (!z && stateAxis == Direction.Axis.X || !x && stateAxis == Direction.Axis.Z) {
                        return (BlockState)((BlockState)state.func_206870_a(TYPE, (Comparable)((Object)PoleType.R_HALF))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
                    }
                    return (BlockState)((BlockState)state.func_206870_a(TYPE, (Comparable)((Object)PoleType.TR_BL))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
                }
                case BL_CORNER: {
                    if ((!z && stateAxis == Direction.Axis.X || !x && stateAxis == Direction.Axis.Z) && y) {
                        return (BlockState)((BlockState)state.func_206870_a(TYPE, (Comparable)((Object)PoleType.B_HALF))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
                    }
                    if (z && stateAxis == Direction.Axis.X || x && stateAxis == Direction.Axis.Z) {
                        return (BlockState)((BlockState)state.func_206870_a(TYPE, (Comparable)((Object)PoleType.L_HALF))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
                    }
                    return (BlockState)((BlockState)state.func_206870_a(TYPE, (Comparable)((Object)PoleType.TR_BL))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
                }
                case BR_CORNER: {
                    if (((z || direction == Direction.NORTH) && stateAxis == Direction.Axis.X || (x || direction == Direction.WEST) && stateAxis == Direction.Axis.Z) && y) {
                        return (BlockState)((BlockState)state.func_206870_a(TYPE, (Comparable)((Object)PoleType.B_HALF))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
                    }
                    if (!z && stateAxis == Direction.Axis.X || !x && stateAxis == Direction.Axis.Z) {
                        return (BlockState)((BlockState)state.func_206870_a(TYPE, (Comparable)((Object)PoleType.R_HALF))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
                    }
                    return (BlockState)((BlockState)state.func_206870_a(TYPE, (Comparable)((Object)PoleType.TL_BR))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
                }
                case T_HALF: {
                    if (z && stateAxis == Direction.Axis.X || x && stateAxis == Direction.Axis.Z) {
                        return (BlockState)((BlockState)state.func_206870_a(TYPE, (Comparable)((Object)PoleType.TL_FILL))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
                    }
                    return (BlockState)((BlockState)state.func_206870_a(TYPE, (Comparable)((Object)PoleType.TR_FILL))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
                }
                case L_HALF: {
                    if (!y) {
                        return (BlockState)((BlockState)state.func_206870_a(TYPE, (Comparable)((Object)PoleType.TL_FILL))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
                    }
                    return (BlockState)((BlockState)state.func_206870_a(TYPE, (Comparable)((Object)PoleType.BL_FILL))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
                }
                case R_HALF: {
                    if (!y) {
                        return (BlockState)((BlockState)state.func_206870_a(TYPE, (Comparable)((Object)PoleType.TR_FILL))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
                    }
                    return (BlockState)((BlockState)state.func_206870_a(TYPE, (Comparable)((Object)PoleType.BR_FILL))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
                }
                case B_HALF: {
                    if (z && stateAxis == Direction.Axis.X || x && stateAxis == Direction.Axis.Z) {
                        return (BlockState)((BlockState)state.func_206870_a(TYPE, (Comparable)((Object)PoleType.BL_FILL))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
                    }
                    return (BlockState)((BlockState)state.func_206870_a(TYPE, (Comparable)((Object)PoleType.BR_FILL))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
                }
                case TR_BL: {
                    if (stateAxis == Direction.Axis.X) {
                        if ((axis.func_200128_b() || axis == Direction.Axis.X || direction == Direction.SOUTH) && z && (!y || direction == Direction.UP) || direction == Direction.NORTH && !y) {
                            return (BlockState)((BlockState)state.func_206870_a(TYPE, (Comparable)((Object)PoleType.TL_FILL))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
                        }
                        return (BlockState)((BlockState)state.func_206870_a(TYPE, (Comparable)((Object)PoleType.BR_FILL))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
                    }
                    if ((axis.func_200128_b() || axis == Direction.Axis.Z || direction == Direction.EAST) && x && (!y || direction == Direction.UP) || direction == Direction.WEST && !y) {
                        return (BlockState)((BlockState)state.func_206870_a(TYPE, (Comparable)((Object)PoleType.TL_FILL))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
                    }
                    return (BlockState)((BlockState)state.func_206870_a(TYPE, (Comparable)((Object)PoleType.BR_FILL))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
                }
                case TL_BR: {
                    if (stateAxis == Direction.Axis.X) {
                        if ((axis.func_200128_b() || axis == Direction.Axis.X || direction == Direction.SOUTH) && !z && (!y || direction == Direction.UP) || direction == Direction.NORTH && !y) {
                            return (BlockState)((BlockState)state.func_206870_a(TYPE, (Comparable)((Object)PoleType.TR_FILL))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
                        }
                        return (BlockState)((BlockState)state.func_206870_a(TYPE, (Comparable)((Object)PoleType.BL_FILL))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
                    }
                    if ((axis.func_200128_b() || axis == Direction.Axis.Z || direction == Direction.EAST) && !x && (!y || direction == Direction.UP) || direction == Direction.WEST && !y) {
                        return (BlockState)((BlockState)state.func_206870_a(TYPE, (Comparable)((Object)PoleType.TR_FILL))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
                    }
                    return (BlockState)((BlockState)state.func_206870_a(TYPE, (Comparable)((Object)PoleType.BL_FILL))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
                }
            }
            OrnamentalMod.LOGGER.error("Ornamental Pole failed to place properly. State: " + state);
            return (BlockState)((BlockState)state.func_206870_a(TYPE, (Comparable)((Object)PoleType.FULL))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        if (facing == Direction.Axis.X) {
            if (x && y) {
                return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)((Object)PoleType.BL_CORNER))).func_206870_a(HORIZONTAL_AXIS, (Comparable)Direction.Axis.Z)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
            }
            if (!x && y) {
                return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)((Object)PoleType.BR_CORNER))).func_206870_a(HORIZONTAL_AXIS, (Comparable)Direction.Axis.Z)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
            }
            if (x && !y) {
                return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)((Object)PoleType.TL_CORNER))).func_206870_a(HORIZONTAL_AXIS, (Comparable)Direction.Axis.Z)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
            }
            return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)((Object)PoleType.TR_CORNER))).func_206870_a(HORIZONTAL_AXIS, (Comparable)Direction.Axis.Z)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
        }
        if (z && y) {
            return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)((Object)PoleType.BL_CORNER))).func_206870_a(HORIZONTAL_AXIS, (Comparable)Direction.Axis.X)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
        }
        if (!z && y) {
            return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)((Object)PoleType.BR_CORNER))).func_206870_a(HORIZONTAL_AXIS, (Comparable)Direction.Axis.X)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
        }
        if (z && !y) {
            return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)((Object)PoleType.TL_CORNER))).func_206870_a(HORIZONTAL_AXIS, (Comparable)Direction.Axis.X)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
        }
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)((Object)PoleType.TR_CORNER))).func_206870_a(HORIZONTAL_AXIS, (Comparable)Direction.Axis.X)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(filled));
    }

    @Deprecated
    public boolean func_196253_a(BlockState state, BlockItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        PoleType type = (PoleType)((Object)state.func_177229_b(TYPE));
        Direction.Axis axis = (Direction.Axis)state.func_177229_b(HORIZONTAL_AXIS);
        if (type != PoleType.FULL && stack.func_77973_b() == this.func_199767_j()) {
            if (context.func_196012_c()) {
                boolean x = context.func_221532_j().field_72450_a - (double)context.func_195995_a().func_177958_n() < 0.5;
                boolean y = context.func_221532_j().field_72448_b - (double)context.func_195995_a().func_177956_o() < 0.5;
                boolean z = context.func_221532_j().field_72449_c - (double)context.func_195995_a().func_177952_p() < 0.5;
                Direction direction = context.func_196000_l();
                switch (type) {
                    case TL_CORNER: {
                        if (axis == Direction.Axis.X) {
                            return !z || y || direction == Direction.DOWN;
                        }
                        return !x || y || direction == Direction.DOWN;
                    }
                    case TR_CORNER: {
                        if (axis == Direction.Axis.X) {
                            return z || y || direction == Direction.NORTH || direction == Direction.DOWN;
                        }
                        return x || y || direction == Direction.WEST || direction == Direction.DOWN;
                    }
                    case BL_CORNER: {
                        if (axis == Direction.Axis.X) {
                            return !z || !y || direction == Direction.UP;
                        }
                        return !x || !y || direction == Direction.UP;
                    }
                    case BR_CORNER: {
                        if (axis == Direction.Axis.X) {
                            return z || !y || direction == Direction.NORTH || direction == Direction.UP;
                        }
                        return x || !y || direction == Direction.WEST || direction == Direction.UP;
                    }
                    case TL_FILL: {
                        return axis == Direction.Axis.X ? (y || direction == Direction.DOWN) && !z : (y || direction == Direction.DOWN) && !x;
                    }
                    case TR_FILL: {
                        return axis == Direction.Axis.X ? (y || direction == Direction.DOWN) && (z || direction == Direction.NORTH) : !(!y && direction != Direction.DOWN || !x && direction != Direction.WEST);
                    }
                    case BL_FILL: {
                        return axis == Direction.Axis.X ? !(y && direction != Direction.UP || z) : (!y || direction == Direction.UP) && !x;
                    }
                    case BR_FILL: {
                        return axis == Direction.Axis.X ? !(y && direction != Direction.UP || !z && direction != Direction.NORTH) : !(y && direction != Direction.UP || !x && direction != Direction.WEST);
                    }
                    case T_HALF: {
                        return y;
                    }
                    case B_HALF: {
                        return !y || direction == Direction.UP;
                    }
                    case L_HALF: {
                        return axis == Direction.Axis.X ? !z : !x;
                    }
                    case R_HALF: {
                        return axis == Direction.Axis.X ? z || direction == Direction.NORTH : x || direction == Direction.WEST;
                    }
                    case TL_BR: {
                        if (axis == Direction.Axis.X) {
                            return y && z || (!y || direction == Direction.UP) && !z || direction == Direction.NORTH && !z || direction == Direction.DOWN && !y;
                        }
                        return y && x || (!y || direction == Direction.UP) && !x || direction == Direction.WEST && !x || direction == Direction.DOWN && !y;
                    }
                    case TR_BL: {
                        if (axis == Direction.Axis.X) {
                            return (!y || direction == Direction.UP) && z || y && !z || direction == Direction.NORTH && !z || direction == Direction.DOWN && !y;
                        }
                        return (!y || direction == Direction.UP) && x || y && !x || direction == Direction.WEST && !x || direction == Direction.DOWN && !y;
                    }
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float distance) {
        entity.func_225503_b_(distance, this.builder.fallMultiplier);
    }

    @Deprecated
    public boolean func_149744_f(BlockState state) {
        return this.builder.hasPower;
    }

    @Deprecated
    public int func_180656_a(BlockState state, IBlockReader world, BlockPos pos, Direction direction) {
        if (this.builder.hasPower) {
            switch (((PoleType)((Object)state.func_177229_b(TYPE))).getShape()) {
                case CORNER: {
                    return 4;
                }
                case HALF: {
                    return 8;
                }
                case FILL: {
                    return 12;
                }
                case BLOCK: {
                    return 15;
                }
            }
        }
        return super.func_180656_a(state, world, pos, direction);
    }

    @Deprecated
    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return state.func_177229_b(TYPE) != PoleType.FULL && super.func_204509_a(worldIn, pos, state, fluidStateIn);
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return state.func_177229_b(TYPE) != PoleType.FULL && super.func_204510_a(worldIn, pos, state, fluidIn);
    }

    @Deprecated
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (!itemstack.func_190926_b()) {
            if ((this.builder.isDirt || this.builder.mealGrass) && item == Items.field_196106_bc) {
                return this.changeBlock(itemstack, (Supplier<? extends OrnamentBeam>)ModBlocks.grass_beam, SoundEvents.field_187571_bR, worldIn, pos, player, hand);
            }
            if ((this.builder.isGrass || this.builder.hoeDirt) && item instanceof HoeItem) {
                return this.changeBlock(itemstack, (Supplier<? extends OrnamentBeam>)ModBlocks.dirt_beam, SoundEvents.field_187581_bW, worldIn, pos, player, hand);
            }
            if ((this.builder.isGrass || this.builder.shovelPath) && item instanceof ShovelItem) {
                return this.changeBlock(itemstack, (Supplier<? extends OrnamentBeam>)ModBlocks.path_beam, SoundEvents.field_187771_eN, worldIn, pos, player, hand);
            }
            if ((this.builder.isPath || this.builder.hoeGrass) && item instanceof HoeItem) {
                return this.changeBlock(itemstack, (Supplier<? extends OrnamentBeam>)ModBlocks.grass_beam, SoundEvents.field_187571_bR, worldIn, pos, player, hand);
            }
        }
        return super.func_225533_a_(state, worldIn, pos, player, hand, result);
    }

    private ActionResultType changeBlock(ItemStack itemstack, Supplier<? extends OrnamentBeam> newblock, SoundEvent sound, World worldIn, BlockPos pos, PlayerEntity player, Hand hand) {
        this.setBlock(worldIn, pos, newblock);
        worldIn.func_184133_a(null, pos, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!player.field_71075_bZ.field_75098_d && !itemstack.func_77984_f()) {
            itemstack.func_190918_g(1);
        } else {
            itemstack.func_222118_a(1, (LivingEntity)player, user -> user.func_213334_d(hand));
        }
        return ActionResultType.SUCCESS;
    }

    private void setBlock(World world, BlockPos pos, Supplier<? extends OrnamentBeam> block) {
        BlockState state = world.func_180495_p(pos);
        world.func_175656_a(pos, (BlockState)((BlockState)((BlockState)block.get().func_176223_P().func_206870_a(TYPE, state.func_177229_b(TYPE))).func_206870_a(HORIZONTAL_AXIS, state.func_177229_b(HORIZONTAL_AXIS))).func_206870_a((Property)WATERLOGGED, state.func_177229_b((Property)WATERLOGGED)));
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState otherState, Direction direction) {
        if ((this.builder.isIce || this.builder.breakableCull) && otherState.func_177230_c() instanceof OrnamentBeam && state.func_177230_c() instanceof OrnamentBeam) {
            OrnamentBeam pole = (OrnamentBeam)state.func_177230_c();
            OrnamentBeam otherPole = (OrnamentBeam)otherState.func_177230_c();
            if (otherPole.getBuilder() == pole.getBuilder() && otherState.func_177229_b(TYPE) == PoleType.FULL && state.func_177229_b(TYPE) == PoleType.FULL) {
                return true;
            }
        }
        return super.func_200122_a(state, otherState, direction);
    }

    @Deprecated
    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        if (type == PathType.WATER) {
            return worldIn.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
        }
        return false;
    }

    public boolean canHarvestBlock(BlockState state, IBlockReader world, BlockPos pos, PlayerEntity player) {
        if (this.builder.hasConfig) {
            ForgeConfigSpec.BooleanValue val = this.builder.booleanValue.get();
            if (val == null) {
                throw new NullPointerException(this.builder.name + " expected a config value but found null.");
            }
            return (Boolean)val.get() != false && super.canHarvestBlock(state, world, pos, player);
        }
        return super.canHarvestBlock(state, world, pos, player);
    }

    @Deprecated
    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        super.func_225542_b_(state, worldIn, pos, random);
        if ((this.builder.isIce || this.builder.canMelt) && worldIn.func_226658_a_(LightType.BLOCK, pos) > 11 - state.func_200016_a((IBlockReader)worldIn, pos)) {
            this.turnIntoWater((World)worldIn, pos);
        }
    }

    protected void turnIntoWater(World world, BlockPos pos) {
        if (world.func_230315_m_().func_236040_e_() && this.builder.canVaporise) {
            world.func_217377_a(pos, false);
        } else {
            world.func_175656_a(pos, this.builder.meltResult.func_176223_P());
            world.func_190524_a(pos, this.builder.meltResult, pos);
        }
    }

    @Deprecated
    public PushReaction func_149656_h(BlockState state) {
        return this.builder.isIce ? PushReaction.NORMAL : this.builder.pushReaction;
    }
}

