/*
 * Decompiled with CFR 0.152.
 */
package com.androsa.ornamental.blocks;

import com.androsa.ornamental.blocks.IOrnamentalBlock;
import com.androsa.ornamental.builder.OrnamentBuilder;
import com.androsa.ornamental.registry.ModBlocks;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.WallBlock;
import net.minecraft.block.WallHeight;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShovelItem;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;

public class OrnamentWall
extends WallBlock
implements IOrnamentalBlock {
    protected final Map<BlockState, VoxelShape> field_235618_h_ = this.makeShapes(4.0f, 3.0f, 23.0f, 0.0f, 23.0f, 25.0f);
    protected final Map<BlockState, VoxelShape> field_235617_g_ = this.makeShapes(4.0f, 3.0f, 15.0f, 0.0f, 13.0f, 15.0f);
    private final OrnamentBuilder builder;

    public OrnamentWall(AbstractBlock.Properties props, OrnamentBuilder builder) {
        super(props);
        this.builder = builder;
    }

    @Override
    public OrnamentBuilder getBuilder() {
        return this.builder;
    }

    private Map<BlockState, VoxelShape> makeShapes(float topshape, float offset, float yUpMax, float yMin, float yLowMax, float yTallMax) {
        float topmin = 8.0f - topshape;
        float topmax = 8.0f + topshape;
        float minoff = 8.0f - offset;
        float maxoff = 8.0f + offset;
        VoxelShape upshape = Block.func_208617_a((double)topmin, (double)0.0, (double)topmin, (double)topmax, (double)yUpMax, (double)topmax);
        VoxelShape northlow = Block.func_208617_a((double)minoff, (double)yMin, (double)0.0, (double)maxoff, (double)yLowMax, (double)maxoff);
        VoxelShape southlow = Block.func_208617_a((double)minoff, (double)yMin, (double)minoff, (double)maxoff, (double)yLowMax, (double)16.0);
        VoxelShape westlow = Block.func_208617_a((double)0.0, (double)yMin, (double)minoff, (double)maxoff, (double)yLowMax, (double)maxoff);
        VoxelShape eastlow = Block.func_208617_a((double)minoff, (double)yMin, (double)minoff, (double)16.0, (double)yLowMax, (double)maxoff);
        VoxelShape northtall = Block.func_208617_a((double)minoff, (double)yMin, (double)0.0, (double)maxoff, (double)yTallMax, (double)maxoff);
        VoxelShape southtall = Block.func_208617_a((double)minoff, (double)yMin, (double)minoff, (double)maxoff, (double)yTallMax, (double)16.0);
        VoxelShape westtall = Block.func_208617_a((double)0.0, (double)yMin, (double)minoff, (double)maxoff, (double)yTallMax, (double)maxoff);
        VoxelShape easttall = Block.func_208617_a((double)minoff, (double)yMin, (double)minoff, (double)16.0, (double)yTallMax, (double)maxoff);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Boolean upstate : field_176256_a.func_177700_c()) {
            for (WallHeight eastheight : field_235612_b_.func_177700_c()) {
                for (WallHeight northheight : field_235613_c_.func_177700_c()) {
                    for (WallHeight westheight : field_235615_e_.func_177700_c()) {
                        for (WallHeight southheight : field_235614_d_.func_177700_c()) {
                            VoxelShape totalshape = VoxelShapes.func_197880_a();
                            totalshape = OrnamentWall.applyWallShape(totalshape, eastheight, eastlow, easttall);
                            totalshape = OrnamentWall.applyWallShape(totalshape, westheight, westlow, westtall);
                            totalshape = OrnamentWall.applyWallShape(totalshape, northheight, northlow, northtall);
                            totalshape = OrnamentWall.applyWallShape(totalshape, southheight, southlow, southtall);
                            if (upstate.booleanValue()) {
                                totalshape = VoxelShapes.func_197872_a((VoxelShape)totalshape, (VoxelShape)upshape);
                            }
                            BlockState blockstate = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_176256_a, (Comparable)upstate)).func_206870_a((Property)field_235612_b_, (Comparable)eastheight)).func_206870_a((Property)field_235615_e_, (Comparable)westheight)).func_206870_a((Property)field_235613_c_, (Comparable)northheight)).func_206870_a((Property)field_235614_d_, (Comparable)southheight);
                            builder.put(blockstate.func_206870_a((Property)field_235616_f_, (Comparable)Boolean.valueOf(false)), (Object)totalshape);
                            builder.put(blockstate.func_206870_a((Property)field_235616_f_, (Comparable)Boolean.valueOf(true)), (Object)totalshape);
                        }
                    }
                }
            }
        }
        return builder.build();
    }

    private static VoxelShape applyWallShape(VoxelShape base, WallHeight wallheight, VoxelShape lowshape, VoxelShape tallshape) {
        switch (wallheight) {
            case TALL: {
                return VoxelShapes.func_197872_a((VoxelShape)base, (VoxelShape)tallshape);
            }
            case LOW: {
                return VoxelShapes.func_197872_a((VoxelShape)base, (VoxelShape)lowshape);
            }
        }
        return base;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.builder.isPath || this.builder.pathShape ? this.field_235617_g_.get(state) : super.func_220053_a(state, worldIn, pos, context);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.builder.isPath || this.builder.pathShape ? this.field_235618_h_.get(state) : super.func_220071_b(state, worldIn, pos, context);
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        entityIn.func_225503_b_(fallDistance, this.builder.fallMultiplier);
    }

    @Deprecated
    public boolean func_149744_f(BlockState state) {
        return this.builder.hasPower;
    }

    @Deprecated
    public int func_180656_a(BlockState blockState, IBlockReader blockReader, BlockPos pos, Direction side) {
        return this.builder.hasPower ? 11 : 0;
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (!itemstack.func_190926_b()) {
            if ((this.builder.isDirt || this.builder.mealGrass) && item == Items.field_196106_bc) {
                return this.changeBlock(itemstack, (Supplier<? extends OrnamentWall>)ModBlocks.grass_wall, SoundEvents.field_187571_bR, worldIn, pos, player, hand);
            }
            if ((this.builder.isGrass || this.builder.hoeDirt) && item instanceof HoeItem) {
                return this.changeBlock(itemstack, (Supplier<? extends OrnamentWall>)ModBlocks.dirt_wall, SoundEvents.field_187581_bW, worldIn, pos, player, hand);
            }
            if ((this.builder.isGrass || this.builder.shovelPath) && item instanceof ShovelItem) {
                return this.changeBlock(itemstack, (Supplier<? extends OrnamentWall>)ModBlocks.path_wall, SoundEvents.field_187771_eN, worldIn, pos, player, hand);
            }
            if ((this.builder.isPath || this.builder.hoeGrass) && item instanceof HoeItem) {
                return this.changeBlock(itemstack, (Supplier<? extends OrnamentWall>)ModBlocks.grass_wall, SoundEvents.field_187571_bR, worldIn, pos, player, hand);
            }
        }
        return super.func_225533_a_(state, worldIn, pos, player, hand, result);
    }

    private ActionResultType changeBlock(ItemStack itemstack, Supplier<? extends OrnamentWall> newblock, SoundEvent sound, World worldIn, BlockPos pos, PlayerEntity player, Hand hand) {
        this.setBlock(worldIn, pos, newblock);
        worldIn.func_184133_a(null, pos, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!player.field_71075_bZ.field_75098_d && !itemstack.func_77984_f()) {
            itemstack.func_190918_g(1);
        } else {
            itemstack.func_222118_a(1, (LivingEntity)player, user -> user.func_213334_d(hand));
        }
        return ActionResultType.SUCCESS;
    }

    private void setBlock(World world, BlockPos pos, Supplier<? extends OrnamentWall> block) {
        BlockState state = world.func_180495_p(pos);
        world.func_175656_a(pos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)block.get().func_176223_P().func_206870_a((Property)field_176256_a, state.func_177229_b((Property)field_176256_a))).func_206870_a((Property)field_235613_c_, state.func_177229_b((Property)field_235613_c_))).func_206870_a((Property)field_235614_d_, state.func_177229_b((Property)field_235614_d_))).func_206870_a((Property)field_235612_b_, state.func_177229_b((Property)field_235612_b_))).func_206870_a((Property)field_235615_e_, state.func_177229_b((Property)field_235615_e_))).func_206870_a((Property)field_235616_f_, state.func_177229_b((Property)field_235616_f_)));
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState otherState, Direction direction) {
        if ((this.builder.isIce || this.builder.breakableCull) && otherState.func_177230_c() instanceof OrnamentWall && state.func_177230_c() instanceof OrnamentWall) {
            boolean crossO;
            boolean crossS = (Boolean)state.func_177229_b((Property)field_176256_a) == false && state.func_177229_b((Property)field_235612_b_) == WallHeight.TALL && state.func_177229_b((Property)field_235615_e_) == WallHeight.TALL && state.func_177229_b((Property)field_235613_c_) == WallHeight.TALL && state.func_177229_b((Property)field_235614_d_) == WallHeight.TALL;
            boolean bl = crossO = (Boolean)otherState.func_177229_b((Property)field_176256_a) == false && otherState.func_177229_b((Property)field_235612_b_) != WallHeight.NONE && otherState.func_177229_b((Property)field_235615_e_) != WallHeight.NONE && otherState.func_177229_b((Property)field_235613_c_) != WallHeight.NONE && otherState.func_177229_b((Property)field_235614_d_) != WallHeight.NONE;
            if (direction == Direction.UP) {
                if (((Boolean)state.func_177229_b((Property)field_176256_a)).booleanValue() && ((Boolean)otherState.func_177229_b((Property)field_176256_a)).booleanValue()) {
                    return true;
                }
                if (crossS && crossO) {
                    return true;
                }
                if (state.func_177229_b((Property)field_235613_c_) == WallHeight.TALL && state.func_177229_b((Property)field_235614_d_) == WallHeight.TALL) {
                    return otherState.func_177229_b((Property)field_235613_c_) != WallHeight.NONE && otherState.func_177229_b((Property)field_235614_d_) != WallHeight.NONE;
                }
                if (state.func_177229_b((Property)field_235615_e_) == WallHeight.TALL && state.func_177229_b((Property)field_235612_b_) == WallHeight.TALL) {
                    return otherState.func_177229_b((Property)field_235615_e_) != WallHeight.NONE && otherState.func_177229_b((Property)field_235612_b_) != WallHeight.NONE;
                }
            } else if (direction == Direction.DOWN) {
                if (((Boolean)state.func_177229_b((Property)field_176256_a)).booleanValue() && ((Boolean)otherState.func_177229_b((Property)field_176256_a)).booleanValue()) {
                    return true;
                }
                if (state.func_177229_b((Property)field_235613_c_) != WallHeight.NONE && state.func_177229_b((Property)field_235614_d_) != WallHeight.NONE) {
                    return otherState.func_177229_b((Property)field_235613_c_) != WallHeight.NONE && state.func_177229_b((Property)field_235614_d_) != WallHeight.NONE;
                }
                if (state.func_177229_b((Property)field_235615_e_) != WallHeight.NONE && state.func_177229_b((Property)field_235612_b_) != WallHeight.NONE) {
                    return otherState.func_177229_b((Property)field_235615_e_) != WallHeight.NONE && state.func_177229_b((Property)field_235612_b_) != WallHeight.NONE;
                }
            } else {
                if (state.func_177229_b((Property)field_235612_b_) != WallHeight.NONE && state.func_177229_b((Property)field_235615_e_) != WallHeight.NONE) {
                    return true;
                }
                if (state.func_177229_b((Property)field_235613_c_) != WallHeight.NONE && state.func_177229_b((Property)field_235614_d_) != WallHeight.NONE) {
                    return true;
                }
            }
        }
        return super.func_200122_a(state, otherState, direction);
    }

    public boolean canHarvestBlock(BlockState state, IBlockReader world, BlockPos pos, PlayerEntity player) {
        if (this.builder.hasConfig) {
            ForgeConfigSpec.BooleanValue val = this.builder.booleanValue.get();
            if (val == null) {
                throw new NullPointerException(this.builder.name + " expected a config value but found null.");
            }
            return (Boolean)val.get() != false && super.canHarvestBlock(state, world, pos, player);
        }
        return super.canHarvestBlock(state, world, pos, player);
    }

    @Deprecated
    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        super.func_225542_b_(state, worldIn, pos, random);
        if ((this.builder.isIce || this.builder.canMelt) && worldIn.func_226658_a_(LightType.BLOCK, pos) > 11 - state.func_200016_a((IBlockReader)worldIn, pos)) {
            this.turnIntoWater((World)worldIn, pos);
        }
    }

    protected void turnIntoWater(World world, BlockPos pos) {
        if (world.func_230315_m_().func_236040_e_() && this.builder.canVaporise) {
            world.func_217377_a(pos, false);
        } else {
            world.func_175656_a(pos, this.builder.meltResult.func_176223_P());
            world.func_190524_a(pos, this.builder.meltResult, pos);
        }
    }

    @Deprecated
    public PushReaction func_149656_h(BlockState state) {
        return this.builder.isIce ? PushReaction.NORMAL : this.builder.pushReaction;
    }
}

