/*
 * Decompiled with CFR 0.152.
 */
package com.androsa.ornamental.data;

import com.androsa.ornamental.data.provider.GolemLootTableProvider;
import com.androsa.ornamental.data.provider.OrnamentLootTableProvider;
import com.androsa.ornamental.registry.ModBlocks;
import com.androsa.ornamental.registry.ModEntities;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Items;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class OrnamentalLootTables
extends LootTableProvider {
    public OrnamentalLootTables(DataGenerator generator) {
        super(generator);
    }

    public String func_200397_b() {
        return "Ornamental Loot Tables";
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(BlockTables::new, (Object)LootParameterSets.field_216267_h), (Object)Pair.of(EntityTables::new, (Object)LootParameterSets.field_216263_d));
    }

    protected void validate(Map<ResourceLocation, LootTable> tableMap, ValidationTracker tracker) {
    }

    public static class EntityTables
    extends GolemLootTableProvider {
        private static final Set<EntityType<?>> ALLOWED_ENTITIES = ImmutableSet.of((Object)ModEntities.GOLD_GOLEM.get(), (Object)ModEntities.DIAMOND_GOLEM.get(), (Object)ModEntities.EMERALD_GOLEM.get(), (Object)ModEntities.LAPIS_GOLEM.get(), (Object)ModEntities.OBSIDIAN_GOLEM.get(), (Object)ModEntities.COAL_GOLEM.get(), (Object[])new EntityType[]{(EntityType)ModEntities.REDSTONE_GOLEM.get(), (EntityType)ModEntities.CLAY_GOLEM.get(), (EntityType)ModEntities.DIRT_GOLEM.get(), (EntityType)ModEntities.GRASS_GOLEM.get(), (EntityType)ModEntities.HAY_GOLEM.get(), (EntityType)ModEntities.PATH_GOLEM.get(), (EntityType)ModEntities.BRICK_GOLEM.get(), (EntityType)ModEntities.QUARTZ_GOLEM.get(), (EntityType)ModEntities.BONE_GOLEM.get(), (EntityType)ModEntities.NETHER_BRICK_GOLEM.get(), (EntityType)ModEntities.RED_NETHER_BRICK_GOLEM.get(), (EntityType)ModEntities.ICE_GOLEM.get(), (EntityType)ModEntities.PACKED_ICE_GOLEM.get(), (EntityType)ModEntities.BLUE_ICE_GOLEM.get(), (EntityType)ModEntities.NETHERITE_GOLEM.get()});

        protected void addTables() {
            this.add((Supplier<? extends EntityType<?>>)ModEntities.GOLD_GOLEM, this.flowerGolemTable(Blocks.field_196605_bc, (IItemProvider)Items.field_151043_k));
            this.add((Supplier<? extends EntityType<?>>)ModEntities.DIAMOND_GOLEM, this.flowerGolemTable(Blocks.field_196607_be, (IItemProvider)Items.field_151045_i));
            this.add((Supplier<? extends EntityType<?>>)ModEntities.EMERALD_GOLEM, this.flowerGolemTable(Blocks.field_196609_bf, (IItemProvider)Items.field_221622_aX));
            this.add((Supplier<? extends EntityType<?>>)ModEntities.LAPIS_GOLEM, this.golemTable((IItemProvider)Items.field_196128_bn));
            this.add((Supplier<? extends EntityType<?>>)ModEntities.OBSIDIAN_GOLEM, this.golemTableBlock((IItemProvider)Blocks.field_150343_Z));
            this.add((Supplier<? extends EntityType<?>>)ModEntities.COAL_GOLEM, this.golemTable((IItemProvider)Items.field_151044_h));
            this.add((Supplier<? extends EntityType<?>>)ModEntities.REDSTONE_GOLEM, this.golemTable((IItemProvider)Items.field_151137_ax));
            this.add((Supplier<? extends EntityType<?>>)ModEntities.CLAY_GOLEM, this.golemTable((IItemProvider)Items.field_151119_aD));
            this.add((Supplier<? extends EntityType<?>>)ModEntities.DIRT_GOLEM, this.golemTableBlock((IItemProvider)Blocks.field_150346_d));
            this.add((Supplier<? extends EntityType<?>>)ModEntities.GRASS_GOLEM, this.golemTableBlock((IItemProvider)Blocks.field_196658_i));
            this.add((Supplier<? extends EntityType<?>>)ModEntities.HAY_GOLEM, this.golemTable((IItemProvider)Items.field_151015_O));
            this.add((Supplier<? extends EntityType<?>>)ModEntities.PATH_GOLEM, this.golemTableBlock((IItemProvider)Blocks.field_185774_da));
            this.add((Supplier<? extends EntityType<?>>)ModEntities.BRICK_GOLEM, this.golemTable((IItemProvider)Items.field_151118_aC));
            this.add((Supplier<? extends EntityType<?>>)ModEntities.QUARTZ_GOLEM, this.golemTable((IItemProvider)Items.field_151128_bU));
            this.add((Supplier<? extends EntityType<?>>)ModEntities.BONE_GOLEM, this.golemTable((IItemProvider)Items.field_151103_aS));
            this.add((Supplier<? extends EntityType<?>>)ModEntities.NETHER_BRICK_GOLEM, this.golemTable((IItemProvider)Items.field_196154_dH));
            this.add((Supplier<? extends EntityType<?>>)ModEntities.RED_NETHER_BRICK_GOLEM, this.golemTable((IItemProvider)Items.field_151075_bm));
            this.add((Supplier<? extends EntityType<?>>)ModEntities.ICE_GOLEM, this.golemTableBlock((IItemProvider)Blocks.field_150432_aD));
            this.add((Supplier<? extends EntityType<?>>)ModEntities.PACKED_ICE_GOLEM, this.golemTableBlock((IItemProvider)Blocks.field_150403_cj));
            this.add((Supplier<? extends EntityType<?>>)ModEntities.BLUE_ICE_GOLEM, this.golemTableBlock((IItemProvider)Blocks.field_205164_gk));
            this.add((Supplier<? extends EntityType<?>>)ModEntities.NETHERITE_GOLEM, this.golemTable((IItemProvider)Items.field_234759_km_));
        }

        protected Iterable<EntityType<?>> getKnownEntities() {
            return ModEntities.ENTITIES.getEntries().stream().map(Supplier::get).collect(Collectors.toList());
        }

        protected boolean isNonLiving(EntityType<?> type) {
            return !ALLOWED_ENTITIES.contains(type) && type.func_220339_d() == EntityClassification.MISC;
        }
    }

    public static class BlockTables
    extends OrnamentLootTableProvider {
        protected void addTables() {
            this.dropSelf((Supplier<? extends Block>)ModBlocks.iron_stairs);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.gold_stairs);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.diamond_stairs);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.emerald_stairs);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.lapis_stairs);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.obsidian_stairs);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.coal_stairs);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.redstone_stairs);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.missingno_stairs);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.clay_stairs);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.dirt_stairs);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.grass_stairs);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.hay_stairs);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.path_stairs);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.bone_stairs);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.snow_stairs);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.ice_stairs);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.packed_ice_stairs);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.blue_ice_stairs);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.netherite_stairs);
            this.dropSlab((Supplier<? extends Block>)ModBlocks.iron_slab);
            this.dropSlab((Supplier<? extends Block>)ModBlocks.gold_slab);
            this.dropSlab((Supplier<? extends Block>)ModBlocks.diamond_slab);
            this.dropSlab((Supplier<? extends Block>)ModBlocks.emerald_slab);
            this.dropSlab((Supplier<? extends Block>)ModBlocks.lapis_slab);
            this.dropSlab((Supplier<? extends Block>)ModBlocks.obsidian_slab);
            this.dropSlab((Supplier<? extends Block>)ModBlocks.coal_slab);
            this.dropSlab((Supplier<? extends Block>)ModBlocks.redstone_slab);
            this.dropSlab((Supplier<? extends Block>)ModBlocks.missingno_slab);
            this.dropSlab((Supplier<? extends Block>)ModBlocks.clay_slab);
            this.dropSlab((Supplier<? extends Block>)ModBlocks.dirt_slab);
            this.dropSlab((Supplier<? extends Block>)ModBlocks.grass_slab);
            this.dropSlab((Supplier<? extends Block>)ModBlocks.hay_slab);
            this.dropSlab((Supplier<? extends Block>)ModBlocks.path_slab);
            this.dropSlab((Supplier<? extends Block>)ModBlocks.bone_slab);
            this.dropSlab((Supplier<? extends Block>)ModBlocks.snow_slab);
            this.dropSlab((Supplier<? extends Block>)ModBlocks.ice_slab);
            this.dropSlab((Supplier<? extends Block>)ModBlocks.packed_ice_slab);
            this.dropSlab((Supplier<? extends Block>)ModBlocks.blue_ice_slab);
            this.dropSlab((Supplier<? extends Block>)ModBlocks.netherite_slab);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.iron_fence);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.gold_fence);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.diamond_fence);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.emerald_fence);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.lapis_fence);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.obsidian_fence);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.coal_fence);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.redstone_fence);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.missingno_fence);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.clay_fence);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.dirt_fence);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.grass_fence);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.hay_fence);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.path_fence);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.brick_fence);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.quartz_fence);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.bone_fence);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.red_nether_brick_fence);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.snow_fence);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.ice_fence);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.packed_ice_fence);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.blue_ice_fence);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.netherite_fence);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.gold_trapdoor);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.diamond_trapdoor);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.emerald_trapdoor);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.lapis_trapdoor);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.obsidian_trapdoor);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.coal_trapdoor);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.redstone_trapdoor);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.missingno_trapdoor);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.clay_trapdoor);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.dirt_trapdoor);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.grass_trapdoor);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.hay_trapdoor);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.path_trapdoor);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.brick_trapdoor);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.quartz_trapdoor);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.bone_trapdoor);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.nether_brick_trapdoor);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.red_nether_brick_trapdoor);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.snow_trapdoor);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.ice_trapdoor);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.packed_ice_trapdoor);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.blue_ice_trapdoor);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.netherite_trapdoor);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.iron_fence_gate);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.gold_fence_gate);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.diamond_fence_gate);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.emerald_fence_gate);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.lapis_fence_gate);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.obsidian_fence_gate);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.coal_fence_gate);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.redstone_fence_gate);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.missingno_fence_gate);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.clay_fence_gate);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.dirt_fence_gate);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.grass_fence_gate);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.hay_fence_gate);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.path_fence_gate);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.brick_fence_gate);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.quartz_fence_gate);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.bone_fence_gate);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.nether_brick_fence_gate);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.red_nether_brick_fence_gate);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.snow_fence_gate);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.ice_fence_gate);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.packed_ice_fence_gate);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.blue_ice_fence_gate);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.netherite_fence_gate);
            this.dropDoor((Supplier<? extends Block>)ModBlocks.gold_door);
            this.dropDoor((Supplier<? extends Block>)ModBlocks.diamond_door);
            this.dropDoor((Supplier<? extends Block>)ModBlocks.emerald_door);
            this.dropDoor((Supplier<? extends Block>)ModBlocks.lapis_door);
            this.dropDoor((Supplier<? extends Block>)ModBlocks.obsidian_door);
            this.dropDoor((Supplier<? extends Block>)ModBlocks.coal_door);
            this.dropDoor((Supplier<? extends Block>)ModBlocks.redstone_door);
            this.dropDoor((Supplier<? extends Block>)ModBlocks.missingno_door);
            this.dropDoor((Supplier<? extends Block>)ModBlocks.clay_door);
            this.dropDoor((Supplier<? extends Block>)ModBlocks.dirt_door);
            this.dropDoor((Supplier<? extends Block>)ModBlocks.grass_door);
            this.dropDoor((Supplier<? extends Block>)ModBlocks.hay_door);
            this.dropDoor((Supplier<? extends Block>)ModBlocks.path_door);
            this.dropDoor((Supplier<? extends Block>)ModBlocks.brick_door);
            this.dropDoor((Supplier<? extends Block>)ModBlocks.quartz_door);
            this.dropDoor((Supplier<? extends Block>)ModBlocks.bone_door);
            this.dropDoor((Supplier<? extends Block>)ModBlocks.nether_brick_door);
            this.dropDoor((Supplier<? extends Block>)ModBlocks.red_nether_brick_door);
            this.dropDoor((Supplier<? extends Block>)ModBlocks.snow_door);
            this.dropDoor((Supplier<? extends Block>)ModBlocks.ice_door);
            this.dropDoor((Supplier<? extends Block>)ModBlocks.packed_ice_door);
            this.dropDoor((Supplier<? extends Block>)ModBlocks.blue_ice_door);
            this.dropDoor((Supplier<? extends Block>)ModBlocks.netherite_door);
            this.dropPole((Supplier<? extends Block>)ModBlocks.iron_pole);
            this.dropPole((Supplier<? extends Block>)ModBlocks.gold_pole);
            this.dropPole((Supplier<? extends Block>)ModBlocks.diamond_pole);
            this.dropPole((Supplier<? extends Block>)ModBlocks.emerald_pole);
            this.dropPole((Supplier<? extends Block>)ModBlocks.lapis_pole);
            this.dropPole((Supplier<? extends Block>)ModBlocks.obsidian_pole);
            this.dropPole((Supplier<? extends Block>)ModBlocks.coal_pole);
            this.dropPole((Supplier<? extends Block>)ModBlocks.redstone_pole);
            this.dropPole((Supplier<? extends Block>)ModBlocks.missingno_pole);
            this.dropPole((Supplier<? extends Block>)ModBlocks.clay_pole);
            this.dropPole((Supplier<? extends Block>)ModBlocks.dirt_pole);
            this.dropPole((Supplier<? extends Block>)ModBlocks.grass_pole);
            this.dropPole((Supplier<? extends Block>)ModBlocks.hay_pole);
            this.dropPole((Supplier<? extends Block>)ModBlocks.path_pole);
            this.dropPole((Supplier<? extends Block>)ModBlocks.brick_pole);
            this.dropPole((Supplier<? extends Block>)ModBlocks.quartz_pole);
            this.dropPole((Supplier<? extends Block>)ModBlocks.bone_pole);
            this.dropPole((Supplier<? extends Block>)ModBlocks.nether_brick_pole);
            this.dropPole((Supplier<? extends Block>)ModBlocks.red_nether_brick_pole);
            this.dropPole((Supplier<? extends Block>)ModBlocks.snow_pole);
            this.dropPole((Supplier<? extends Block>)ModBlocks.ice_pole);
            this.dropPole((Supplier<? extends Block>)ModBlocks.packed_ice_pole);
            this.dropPole((Supplier<? extends Block>)ModBlocks.blue_ice_pole);
            this.dropPole((Supplier<? extends Block>)ModBlocks.netherite_pole);
            this.dropBeam((Supplier<? extends Block>)ModBlocks.iron_beam);
            this.dropBeam((Supplier<? extends Block>)ModBlocks.gold_beam);
            this.dropBeam((Supplier<? extends Block>)ModBlocks.diamond_beam);
            this.dropBeam((Supplier<? extends Block>)ModBlocks.emerald_beam);
            this.dropBeam((Supplier<? extends Block>)ModBlocks.lapis_beam);
            this.dropBeam((Supplier<? extends Block>)ModBlocks.obsidian_beam);
            this.dropBeam((Supplier<? extends Block>)ModBlocks.coal_beam);
            this.dropBeam((Supplier<? extends Block>)ModBlocks.redstone_beam);
            this.dropBeam((Supplier<? extends Block>)ModBlocks.missingno_beam);
            this.dropBeam((Supplier<? extends Block>)ModBlocks.clay_beam);
            this.dropBeam((Supplier<? extends Block>)ModBlocks.dirt_beam);
            this.dropBeam((Supplier<? extends Block>)ModBlocks.grass_beam);
            this.dropBeam((Supplier<? extends Block>)ModBlocks.hay_beam);
            this.dropBeam((Supplier<? extends Block>)ModBlocks.path_beam);
            this.dropBeam((Supplier<? extends Block>)ModBlocks.brick_beam);
            this.dropBeam((Supplier<? extends Block>)ModBlocks.quartz_beam);
            this.dropBeam((Supplier<? extends Block>)ModBlocks.bone_beam);
            this.dropBeam((Supplier<? extends Block>)ModBlocks.nether_brick_beam);
            this.dropBeam((Supplier<? extends Block>)ModBlocks.red_nether_brick_beam);
            this.dropBeam((Supplier<? extends Block>)ModBlocks.snow_beam);
            this.dropBeam((Supplier<? extends Block>)ModBlocks.ice_beam);
            this.dropBeam((Supplier<? extends Block>)ModBlocks.packed_ice_beam);
            this.dropBeam((Supplier<? extends Block>)ModBlocks.blue_ice_beam);
            this.dropBeam((Supplier<? extends Block>)ModBlocks.netherite_beam);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.iron_wall);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.gold_wall);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.diamond_wall);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.emerald_wall);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.lapis_wall);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.obsidian_wall);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.coal_wall);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.redstone_wall);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.missingno_wall);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.clay_wall);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.dirt_wall);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.grass_wall);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.hay_wall);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.path_wall);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.quartz_wall);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.bone_wall);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.snow_wall);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.ice_wall);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.packed_ice_wall);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.blue_ice_wall);
            this.dropSelf((Supplier<? extends Block>)ModBlocks.netherite_wall);
        }

        protected Iterable<Block> getKnownBlocks() {
            return ModBlocks.BLOCKS.getEntries().stream().map(Supplier::get).collect(Collectors.toList());
        }
    }
}

