/*
 * Decompiled with CFR 0.152.
 */
package com.androsa.ornamental.data.provider;

import com.androsa.ornamental.blocks.OrnamentBeam;
import com.androsa.ornamental.blocks.OrnamentPole;
import com.androsa.ornamental.blocks.PoleType;
import com.androsa.ornamental.data.provider.OrnamentalBlockModelProvider;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.RegistryObject;

public abstract class OrnamentalBlockStateProvider
extends BlockStateProvider {
    private final OrnamentalBlockModelProvider blockModels;
    private final String modID;

    public OrnamentalBlockStateProvider(DataGenerator generator, String modid, ExistingFileHelper helper) {
        super(generator, modid, helper);
        this.modID = modid;
        this.blockModels = new OrnamentalBlockModelProvider(generator, modid, helper){

            protected void registerModels() {
            }

            public String func_200397_b() {
                return OrnamentalBlockStateProvider.this.func_200397_b();
            }
        };
    }

    @Nonnull
    public String func_200397_b() {
        return "Ornamental Blockstates and Block Models";
    }

    public String getModID() {
        return this.modID;
    }

    public OrnamentalBlockModelProvider models() {
        return this.blockModels;
    }

    protected ResourceLocation locVanilla(String name) {
        return new ResourceLocation("block/" + name);
    }

    protected ResourceLocation locOrnament(String name) {
        return new ResourceLocation(this.getModID(), "block/" + name);
    }

    public void stairsBasic(Supplier<? extends StairsBlock> block, String name) {
        this.stairsBlock(block.get(), this.locVanilla(name));
    }

    public void stairsMissing(Supplier<? extends StairsBlock> block) {
        this.stairsBlock(block.get(), this.locOrnament("missingno"));
    }

    public void stairsColumn(Supplier<? extends StairsBlock> block, String side, String end) {
        this.stairsBlock(block.get(), this.locVanilla(side), this.locVanilla(end), this.locVanilla(end));
    }

    public void slabBasic(Supplier<? extends SlabBlock> block, String name) {
        this.slabBlock(block.get(), this.locVanilla(name), this.locVanilla(name));
    }

    public void slabMissing(Supplier<? extends SlabBlock> block) {
        this.slabBlock(block.get(), this.locOrnament("missingno"), this.locOrnament("missingno"));
    }

    public void slabModel(Supplier<? extends SlabBlock> block, String model, String name) {
        this.slabBlock(block.get(), this.locVanilla(model), this.locVanilla(name));
    }

    public void slabColumn(Supplier<? extends SlabBlock> block, String blockname, String side, String end) {
        this.slabBlock(block.get(), this.locVanilla(blockname), this.locVanilla(side), this.locVanilla(end), this.locVanilla(end));
    }

    public void fenceBasic(Supplier<? extends FenceBlock> block, String name) {
        this.fenceBlock(block.get(), this.locVanilla(name));
    }

    public void fenceMissing(Supplier<? extends FenceBlock> block) {
        this.fenceBlock(block.get(), this.locOrnament("missingno"));
    }

    public void fenceColumn(Supplier<? extends FenceBlock> block, String side, String top) {
        String baseName = block.get().getRegistryName().toString();
        this.fourWayBlock((FourWayBlock)block.get(), (ModelFile)this.models().fencePostColumn(baseName + "_post", this.locVanilla(side), this.locVanilla(top)), (ModelFile)this.models().fenceSide(baseName + "_side", this.locVanilla(side)));
    }

    public void trapdoorBasic(Supplier<? extends TrapDoorBlock> block, String name) {
        this.trapdoorBlock(block.get(), this.locOrnament(name + "_trapdoor"), true);
    }

    public void trapdoorMissing(Supplier<? extends TrapDoorBlock> block) {
        this.trapdoorBlock(block.get(), this.locOrnament("missingno"), false);
    }

    public void trapdoorVanilla(Supplier<? extends TrapDoorBlock> block, String name) {
        this.trapdoorBlock(block.get(), this.locVanilla(name), false);
    }

    public void fenceGateBasic(Supplier<? extends FenceGateBlock> block, String name) {
        this.fenceGateBlock(block.get(), this.locVanilla(name));
    }

    public void fenceGateMissing(Supplier<? extends FenceGateBlock> block) {
        this.fenceGateBlock(block.get(), this.locOrnament("missingno"));
    }

    public void fenceGateColumn(Supplier<? extends FenceGateBlock> block, String side, String top) {
        BlockModelBuilder gate = this.models().fenceGateColumn(block.get().getRegistryName().toString(), this.locVanilla(side), this.locVanilla(top));
        BlockModelBuilder gateOpen = this.models().fenceGateOpenColumn(block.get().getRegistryName().toString() + "_open", this.locVanilla(side), this.locVanilla(top));
        BlockModelBuilder gateWall = this.models().fenceGateWallColumn(block.get().getRegistryName().toString() + "_wall", this.locVanilla(side), this.locVanilla(top));
        BlockModelBuilder gateWallOpen = this.models().fenceGateWallOpenColumn(block.get().getRegistryName().toString() + "_wall_open", this.locVanilla(side), this.locVanilla(top));
        this.fenceGateBlock(block.get(), (ModelFile)gate, (ModelFile)gateOpen, (ModelFile)gateWall, (ModelFile)gateWallOpen);
    }

    public void doorBasic(Supplier<? extends DoorBlock> block, String name) {
        this.doorBlock(block.get(), this.locOrnament(name + "_door_bottom"), this.locOrnament(name + "_door_top"));
    }

    public void doorMissing(Supplier<? extends DoorBlock> block) {
        this.doorBlock(block.get(), this.locOrnament("missingno"), this.locOrnament("missingno"));
    }

    public void doorBasicVanilla(Supplier<? extends DoorBlock> block, String name) {
        this.doorBlock(block.get(), this.locVanilla(name), this.locVanilla(name));
    }

    public void poleBasic(RegistryObject<? extends OrnamentPole> block, String name) {
        this.poleBasic(block, name, name);
    }

    public void poleBasic(RegistryObject<? extends OrnamentPole> block, String name, String fullblock) {
        BlockModelBuilder corner = this.models().poleCorner(block.getId().toString() + "_corner", this.locVanilla(name));
        BlockModelBuilder half = this.models().slabVertical(block.getId().toString() + "_half", this.locVanilla(name));
        BlockModelBuilder cross = this.models().poleCross(block.getId().toString() + "_cross", this.locVanilla(name));
        BlockModelBuilder fill = this.models().stairsStraightSide(block.getId().toString() + "_fill", this.locVanilla(name));
        ModelFile.ExistingModelFile full = this.models().getExistingFile(this.locVanilla(fullblock));
        this.poleBlock((Supplier<? extends OrnamentPole>)block, (ModelFile)corner, (ModelFile)half, (ModelFile)cross, (ModelFile)fill, (ModelFile)full);
    }

    public void poleColumn(RegistryObject<? extends OrnamentPole> block, String name) {
        BlockModelBuilder corner = this.models().poleCornerColumn(block.getId().toString() + "_corner", this.locVanilla(name + "_side"), this.locVanilla(name + "_top"));
        BlockModelBuilder half = this.models().slabVerticalColumn(block.getId().toString() + "_half", this.locVanilla(name + "_side"), this.locVanilla(name + "_top"));
        BlockModelBuilder cross = this.models().poleCrossColumn(block.getId().toString() + "_cross", this.locVanilla(name + "_side"), this.locVanilla(name + "_top"));
        BlockModelBuilder fill = this.models().stairsStraightSideColumn(block.getId().toString() + "_fill", this.locVanilla(name + "_side"), this.locVanilla(name + "_top"));
        ModelFile.ExistingModelFile full = this.models().getExistingFile(this.locVanilla(name));
        this.poleBlock((Supplier<? extends OrnamentPole>)block, (ModelFile)corner, (ModelFile)half, (ModelFile)cross, (ModelFile)fill, (ModelFile)full);
    }

    public void poleMissing(RegistryObject<? extends OrnamentPole> block, String name) {
        BlockModelBuilder corner = this.models().poleCorner(block.getId().toString() + "_corner", this.locOrnament(name));
        BlockModelBuilder half = this.models().slabVertical(block.getId().toString() + "_half", this.locOrnament(name));
        BlockModelBuilder cross = this.models().poleCross(block.getId().toString() + "_cross", this.locOrnament(name));
        BlockModelBuilder fill = this.models().stairsStraightSide(block.getId().toString() + "_fill", this.locOrnament(name));
        ModelFile.ExistingModelFile full = this.models().getExistingFile(this.locOrnament(name));
        this.poleBlock((Supplier<? extends OrnamentPole>)block, (ModelFile)corner, (ModelFile)half, (ModelFile)cross, (ModelFile)fill, (ModelFile)full);
    }

    public void beamBasic(RegistryObject<? extends OrnamentBeam> block, String base, String name, boolean vstairs, boolean vslab) {
        this.beamBasic(block, base, name, name, vstairs, vslab);
    }

    public void beamBasic(RegistryObject<? extends OrnamentBeam> block, String base, String name, String fullblock, boolean vstairs, boolean vslab) {
        String namebottom = base + "_slab";
        String nametop = namebottom + "_top";
        String namehalf = base + "_pole_half";
        String stairs = base + "_stairs";
        BlockModelBuilder corner = this.models().beamCorner(block.getId().toString() + "_corner", this.locVanilla(name));
        ModelFile.ExistingModelFile top = this.models().getExistingFile(vslab ? this.locVanilla(nametop) : this.locOrnament(nametop));
        ModelFile.ExistingModelFile bottom = this.models().getExistingFile(vslab ? this.locVanilla(namebottom) : this.locOrnament(namebottom));
        ModelFile.ExistingModelFile side = this.models().getExistingFile(this.locOrnament(namehalf));
        BlockModelBuilder cross = this.models().beamCross(block.getId().toString() + "_cross", this.locVanilla(name));
        ModelFile.ExistingModelFile fill = this.models().getExistingFile(vstairs ? this.locVanilla(stairs) : this.locOrnament(stairs));
        ModelFile.ExistingModelFile full = this.models().getExistingFile(this.locVanilla(fullblock));
        this.beamBlock((Supplier<? extends OrnamentBeam>)block, (ModelFile)corner, (ModelFile)top, (ModelFile)bottom, (ModelFile)side, (ModelFile)cross, (ModelFile)fill, (ModelFile)full);
    }

    public void beamColumn(RegistryObject<? extends OrnamentBeam> block, String base, String name, boolean vstairs, boolean vslab) {
        String namebottom = base + "_slab";
        String nametop = namebottom + "_top";
        String namehalf = base + "_pole_half";
        String stairs = base + "_stairs";
        BlockModelBuilder corner = this.models().beamCornerColumn(block.getId().toString() + "_corner", this.locVanilla(name + "_side"), this.locVanilla(name + "_top"));
        ModelFile.ExistingModelFile top = this.models().getExistingFile(vslab ? this.locVanilla(nametop) : this.locOrnament(nametop));
        ModelFile.ExistingModelFile bottom = this.models().getExistingFile(vslab ? this.locVanilla(namebottom) : this.locOrnament(namebottom));
        ModelFile.ExistingModelFile side = this.models().getExistingFile(vslab ? this.locVanilla(namebottom) : this.locOrnament(namehalf));
        BlockModelBuilder cross = this.models().beamCrossColumn(block.getId().toString() + "_cross", this.locVanilla(name + "_side"), this.locVanilla(name + "_top"));
        ModelFile.ExistingModelFile fill = this.models().getExistingFile(vstairs ? this.locVanilla(stairs) : this.locOrnament(stairs));
        ModelFile.ExistingModelFile full = this.models().getExistingFile(this.locVanilla(name));
        this.beamBlock((Supplier<? extends OrnamentBeam>)block, (ModelFile)corner, (ModelFile)top, (ModelFile)bottom, (ModelFile)side, (ModelFile)cross, (ModelFile)fill, (ModelFile)full);
    }

    public void beamMissing(RegistryObject<? extends OrnamentBeam> block, String name) {
        String namebottom = name + "_slab";
        String nametop = namebottom + "_top";
        String namehalf = name + "_pole_half";
        String stairs = name + "_stairs";
        BlockModelBuilder corner = this.models().beamCorner(block.getId().toString() + "_corner", this.locOrnament(name));
        ModelFile.ExistingModelFile top = this.models().getExistingFile(this.locOrnament(nametop));
        ModelFile.ExistingModelFile bottom = this.models().getExistingFile(this.locOrnament(namebottom));
        ModelFile.ExistingModelFile side = this.models().getExistingFile(this.locOrnament(namehalf));
        BlockModelBuilder cross = this.models().beamCross(block.getId().toString() + "_cross", this.locOrnament(name));
        ModelFile.ExistingModelFile fill = this.models().getExistingFile(this.locOrnament(stairs));
        ModelFile.ExistingModelFile full = this.models().getExistingFile(this.locOrnament(name));
        this.beamBlock((Supplier<? extends OrnamentBeam>)block, (ModelFile)corner, (ModelFile)top, (ModelFile)bottom, (ModelFile)side, (ModelFile)cross, (ModelFile)fill, (ModelFile)full);
    }

    public void wallBasic(Supplier<? extends WallBlock> block, String name) {
        this.wallBlock(block.get(), this.locVanilla(name));
    }

    public void wallMissing(Supplier<? extends WallBlock> block, String name) {
        this.wallBlock(block.get(), this.locOrnament(name));
    }

    public void wallColumn(RegistryObject<? extends WallBlock> block, String side, String end) {
        String basename = block.getId().toString();
        BlockModelBuilder wallpost = this.models().wallPostColumn(basename + "_post", this.locVanilla(side), this.locVanilla(end));
        BlockModelBuilder wallside = this.models().wallSideColumn(basename + "_side", this.locVanilla(side), this.locVanilla(end));
        BlockModelBuilder walltall = this.models().wallSideTallColumn(basename + "_side_tall", this.locVanilla(side), this.locVanilla(end));
        this.wallBlock((WallBlock)block.get(), (ModelFile)wallpost, (ModelFile)wallside, (ModelFile)walltall);
    }

    public void poleBlock(Supplier<? extends OrnamentPole> block, ModelFile corner, ModelFile half, ModelFile cross, ModelFile fill, ModelFile full) {
        this.getVariantBuilder(block.get()).forAllStatesExcept(state -> {
            ModelFile model;
            PoleType type = (PoleType)((Object)((Object)state.func_177229_b(OrnamentPole.TYPE)));
            PoleType.Shape shape = type.getShape();
            switch (shape) {
                case HALF: {
                    model = half;
                    break;
                }
                case CROSS: {
                    model = cross;
                    break;
                }
                case FILL: {
                    model = fill;
                    break;
                }
                case BLOCK: {
                    model = full;
                    break;
                }
                default: {
                    model = corner;
                }
            }
            int yRot = type == PoleType.TR_CORNER || type == PoleType.R_HALF || type == PoleType.TR_BL || type == PoleType.TR_FILL ? 90 : (type == PoleType.BR_CORNER || type == PoleType.B_HALF || type == PoleType.BR_FILL ? 180 : (type == PoleType.BL_CORNER || type == PoleType.L_HALF || type == PoleType.BL_FILL ? 270 : 0));
            boolean uvlock = yRot != 0;
            return ConfiguredModel.builder().modelFile(model).rotationY(yRot).uvLock(uvlock).build();
        }, new Property[]{OrnamentPole.WATERLOGGED});
    }

    public void beamBlock(Supplier<? extends OrnamentBeam> block, ModelFile corner, ModelFile topslab, ModelFile bottomslab, ModelFile halfpole, ModelFile cross, ModelFile fill, ModelFile full) {
        this.getVariantBuilder(block.get()).forAllStatesExcept(state -> {
            ModelFile model;
            PoleType type = (PoleType)((Object)((Object)state.func_177229_b(OrnamentBeam.TYPE)));
            Direction.Axis axis = (Direction.Axis)state.func_177229_b(OrnamentBeam.HORIZONTAL_AXIS);
            PoleType.Shape shape = type.getShape();
            switch (shape) {
                case HALF: {
                    if (type == PoleType.T_HALF) {
                        model = topslab;
                        break;
                    }
                    if (type == PoleType.B_HALF) {
                        model = bottomslab;
                        break;
                    }
                    model = halfpole;
                    break;
                }
                case CROSS: {
                    model = cross;
                    break;
                }
                case FILL: {
                    model = fill;
                    break;
                }
                case BLOCK: {
                    model = full;
                    break;
                }
                default: {
                    model = corner;
                }
            }
            int xRot = type == PoleType.BL_CORNER || type == PoleType.BR_CORNER || type == PoleType.TL_FILL || type == PoleType.TR_FILL ? 180 : 0;
            int yRot = type == PoleType.TL_CORNER || type == PoleType.BR_CORNER || type == PoleType.L_HALF || type == PoleType.TL_BR ? 270 : (type == PoleType.TR_CORNER || type == PoleType.BL_CORNER || type == PoleType.R_HALF || type == PoleType.TR_BL ? 90 : (type == PoleType.TL_FILL || type == PoleType.BL_FILL ? 180 : 0));
            if (type != PoleType.T_HALF && type != PoleType.B_HALF && type != PoleType.FULL) {
                yRot = axis == Direction.Axis.X ? yRot + 90 : yRot;
            }
            yRot = yRot == 360 ? 0 : yRot;
            boolean uvlock = yRot != 0 || xRot != 0;
            return ConfiguredModel.builder().modelFile(model).rotationY(yRot).rotationX(xRot).uvLock(uvlock).build();
        }, new Property[]{OrnamentBeam.WATERLOGGED});
    }
}

