/*
 * Decompiled with CFR 0.152.
 */
package com.androsa.ornamental.data.provider;

import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;

public abstract class OrnamentalItemModelProvider
extends ItemModelProvider {
    public OrnamentalItemModelProvider(DataGenerator generator, String modid, ExistingFileHelper helper) {
        super(generator, modid, helper);
    }

    public ResourceLocation ornamentLoc(String path) {
        return new ResourceLocation("ornamental", path);
    }

    public String blockName(Supplier<? extends Block> block) {
        return block.get().func_199767_j().getRegistryName().func_110623_a();
    }

    public void blockItem(Supplier<? extends Block> block) {
        this.withExistingParent(this.blockName(block), this.modLoc("block/" + this.blockName(block)));
    }

    public void blockItemModel(Supplier<? extends Block> block) {
        ((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + this.blockName(block)));
    }

    public void blockItemModel(Supplier<? extends Block> block, String name) {
        ((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + name));
    }

    public void blockItemFence(Supplier<? extends Block> block, String name) {
        ((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("block/fence_inventory"))).texture("texture", this.mcLoc("block/" + name));
    }

    public void blockItemFenceColumn(Supplier<? extends Block> block, String side, String top) {
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.ornamentLoc("block/util/fence_inventory_column"))).texture("end", this.mcLoc("block/" + top))).texture("side", this.mcLoc("block/" + side));
    }

    public void blockItemFenceMissing(Supplier<? extends Block> block) {
        ((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("block/fence_inventory"))).texture("texture", this.modLoc("block/missingno"));
    }

    public void blockItemTrapdoor(Supplier<? extends Block> block) {
        this.withExistingParent(this.blockName(block), this.modLoc("block/" + this.blockName(block) + "_bottom"));
    }

    public void blockItemPole(Supplier<? extends Block> block, String name) {
        this.blockItemPole(block, name, name);
    }

    public void blockItemPole(Supplier<? extends Block> block, String end, String side) {
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.ornamentLoc("block/util/pole_inventory"))).texture("end", this.mcLoc("block/" + end))).texture("side", this.mcLoc("block/" + side));
    }

    public void blockItemPoleMissing(Supplier<? extends Block> block) {
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.ornamentLoc("block/util/pole_inventory"))).texture("end", this.modLoc("block/missingno"))).texture("side", this.modLoc("block/missingno"));
    }

    public void blockItemBeam(Supplier<? extends Block> block, String name) {
        this.blockItemBeam(block, name, name);
    }

    public void blockItemBeam(Supplier<? extends Block> block, String end, String side) {
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.ornamentLoc("block/util/beam_inventory"))).texture("end", this.mcLoc("block/" + end))).texture("side", this.mcLoc("block/" + side));
    }

    public void blockItemBeamMissing(Supplier<? extends Block> block) {
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.ornamentLoc("block/util/beam_inventory"))).texture("end", this.modLoc("block/missingno"))).texture("side", this.modLoc("block/missingno"));
    }

    public void blockItemWall(Supplier<? extends Block> block, String name) {
        ((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("block/wall_inventory"))).texture("wall", this.mcLoc("block/" + name));
    }

    public void blockItemWallColumn(Supplier<? extends Block> block, String side, String top) {
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.ornamentLoc("block/util/wall_inventory_column"))).texture("end", this.mcLoc("block/" + top))).texture("side", this.mcLoc("block/" + side));
    }

    public void blockItemWallMissing(Supplier<? extends Block> block) {
        ((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("block/wall_inventory"))).texture("wall", this.modLoc("block/missingno"));
    }
}

