/*
 * Decompiled with CFR 0.152.
 */
package com.androsa.ornamental.entity;

import com.androsa.ornamental.entity.AbstractGolemEntity;
import com.androsa.ornamental.entity.task.ExplodingFireballAttackGoal;
import com.androsa.ornamental.entity.task.NextMeleeAttackGoal;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class NetheriteGolemEntity
extends AbstractGolemEntity {
    private static final DataParameter<Boolean> TARGETING = EntityDataManager.func_187226_a(NetheriteGolemEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> FIREBALLS = EntityDataManager.func_187226_a(NetheriteGolemEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int rechargeTimer = 1200;

    public NetheriteGolemEntity(EntityType<? extends NetheriteGolemEntity> entity, World world) {
        super(entity, world);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new ExplodingFireballAttackGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new NextMeleeAttackGoal(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, (double)0.4f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, false, false));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 180.0).func_233815_a_(Attributes.field_233821_d_, 0.4).func_233815_a_(Attributes.field_233820_c_, 0.3).func_233815_a_(Attributes.field_233823_f_, 20.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TARGETING, (Object)false);
        this.field_70180_af.func_187214_a(FIREBALLS, (Object)6);
    }

    public boolean isTargeting() {
        return (Boolean)this.field_70180_af.func_187225_a(TARGETING);
    }

    public void setTargeting(boolean flag) {
        this.field_70180_af.func_187227_b(TARGETING, (Object)flag);
    }

    public int getFireballs() {
        return (Integer)this.field_70180_af.func_187225_a(FIREBALLS);
    }

    public void addFireball() {
        if (this.getFireballs() < 6) {
            this.field_70180_af.func_187227_b(FIREBALLS, (Object)(this.getFireballs() + 1));
        }
    }

    public void shootFireball() {
        if (this.getFireballs() > 0) {
            this.field_70180_af.func_187227_b(FIREBALLS, (Object)(this.getFireballs() - 1));
        }
    }

    public void setFireballs(int count) {
        if (count > 6) {
            count = 6;
        }
        this.field_70180_af.func_187227_b(FIREBALLS, (Object)count);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Fireballs", this.getFireballs());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setFireballs(compound.func_74762_e("Fireballs"));
    }

    protected int func_70682_h(int time) {
        return time;
    }

    protected void func_82167_n(Entity target) {
        if (target instanceof IMob && this.func_70681_au().nextInt(20) == 0) {
            this.func_70624_b((LivingEntity)target);
        }
        super.func_82167_n(target);
    }

    public void func_70624_b(@Nullable LivingEntity target) {
        this.setTargeting(target != null);
        super.func_70624_b(target);
    }

    public boolean func_213358_a(EntityType<?> target) {
        return target != EntityType.field_200729_aH || target.func_220339_d() != EntityClassification.MISC;
    }

    private float getAttackDamage() {
        return (float)this.func_233637_b_(Attributes.field_233823_f_);
    }

    public boolean func_70652_k(Entity target) {
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        float damage = this.getAttackDamage();
        float multiplier = damage > 0.0f ? damage / 2.0f + (float)this.field_70146_Z.nextInt((int)damage) : 0.0f;
        boolean flag = target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), multiplier);
        if (flag) {
            target.func_213317_d(target.func_213322_ci().func_72441_c(0.0, 0.5, 0.0));
            this.func_174815_a((LivingEntity)this, target);
        }
        this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        return flag;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187602_cF;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187599_cE;
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 0.6f;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.rechargeTimer < 0) {
            this.addFireball();
            this.rechargeTimer = 1200;
        } else if (this.getFireballs() < 6) {
            this.rechargeTimer = !this.isTargeting() ? (this.rechargeTimer -= 2) : --this.rechargeTimer;
        }
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (item != Items.field_234759_km_) {
            return ActionResultType.PASS;
        }
        float f = this.func_110143_aJ();
        this.func_70691_i(25.0f);
        if (this.func_110143_aJ() == f) {
            return ActionResultType.PASS;
        }
        float f1 = 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f;
        this.func_184185_a(SoundEvents.field_226143_fP_, 1.0f, f1);
        if (!player.field_71075_bZ.field_75098_d) {
            itemstack.func_190918_g(1);
        }
        return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
    }

    protected void func_180429_a(BlockPos pos, BlockState state) {
    }

    public float func_213307_e(Pose pose) {
        return 2.0f;
    }

    public boolean func_70097_a(DamageSource source, float multiplier) {
        return source != DamageSource.field_82727_n && !source.func_94541_c() && !source.func_76347_k() && super.func_70097_a(source, multiplier);
    }
}

