/*
 * Decompiled with CFR 0.152.
 */
package com.androsa.ornamental.entity.helper;

import com.androsa.ornamental.entity.helper.PatternType;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CarvedPumpkinBlock;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ornamental", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GolemBuilder {
    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        if (event.getPlacedBlock().func_177230_c() instanceof CarvedPumpkinBlock) {
            ServerWorld world = ((IServerWorld)event.getWorld()).func_201672_e();
            BlockPos pos = event.getPos();
            GolemBuilder.checkPatternLarge(PatternType.GOLD, (World)world, pos, 1, 2);
            GolemBuilder.checkPatternLarge(PatternType.DIAMOND, (World)world, pos, 1, 1);
            GolemBuilder.checkPatternLarge(PatternType.EMERALD, (World)world, pos, 1, 2);
            GolemBuilder.checkPatternLarge(PatternType.LAPIS, (World)world, pos, 1, 2);
            GolemBuilder.checkPatternLarge(PatternType.OBSIDIAN, (World)world, pos, 1, 3);
            GolemBuilder.checkPatternSmall(PatternType.COAL, (World)world, pos, 2);
            GolemBuilder.checkPatternLarge(PatternType.REDSTONE, (World)world, pos, 1, 2);
            GolemBuilder.checkPatternSmall(PatternType.CLAY, (World)world, pos, 2);
            GolemBuilder.checkPatternSmall(PatternType.DIRT, (World)world, pos, 1);
            GolemBuilder.checkPatternLarge(PatternType.HAY, (World)world, pos, 2, 3);
            GolemBuilder.checkPatternSmall(PatternType.BRICK, (World)world, pos, 2);
            GolemBuilder.checkPatternLarge(PatternType.QUARTZ, (World)world, pos, 1, 2);
            GolemBuilder.checkPatternLarge(PatternType.BONE, (World)world, pos, 1, 3);
            GolemBuilder.checkPatternSmall(PatternType.NETHER_BRICK, (World)world, pos, 2);
            GolemBuilder.checkPatternSmall(PatternType.RED_NETHER_BRICK, (World)world, pos, 2);
            GolemBuilder.checkPatternSmall(PatternType.ICE, (World)world, pos, 2);
            GolemBuilder.checkPatternSmall(PatternType.PACKED_ICE, (World)world, pos, 2);
            GolemBuilder.checkPatternSmall(PatternType.BLUE_ICE, (World)world, pos, 2);
            GolemBuilder.checkPatternLarge(PatternType.NETHERITE, (World)world, pos, 1, 2);
        }
    }

    private static void checkPatternSmall(PatternType type, World world, BlockPos pos, int y) {
        BlockPattern.PatternHelper pattern;
        if (type.canBuild() && (pattern = type.getMatch(world, pos)) != null) {
            GolemBuilder.setAirSmall(type, pattern, world);
            GolemBuilder.addGolem(type, world, pattern, 0, y);
            GolemBuilder.notifySmall(type, pattern, world);
        }
    }

    private static void checkPatternLarge(PatternType type, World world, BlockPos pos, int x, int y) {
        BlockPattern.PatternHelper pattern;
        if (type.canBuild() && (pattern = type.getMatch(world, pos)) != null) {
            GolemBuilder.setAirLarge(type, pattern, world);
            GolemBuilder.addGolem(type, world, pattern, x, y);
            GolemBuilder.notifyLarge(type, pattern, world);
        }
    }

    private static void setAirSmall(PatternType type, BlockPattern.PatternHelper pattern, World world) {
        for (int k = 0; k < type.getHeight(); ++k) {
            CachedBlockInfo info = pattern.func_177670_a(0, k, 0);
            world.func_180501_a(info.func_177508_d(), Blocks.field_150350_a.func_176223_P(), 2);
            world.func_217379_c(2001, info.func_177508_d(), Block.func_196246_j((BlockState)info.func_177509_a()));
        }
    }

    private static void setAirLarge(PatternType type, BlockPattern.PatternHelper pattern, World world) {
        for (int j = 0; j < type.getWidth(); ++j) {
            for (int k = 0; k < type.getHeight(); ++k) {
                CachedBlockInfo info = pattern.func_177670_a(j, k, 0);
                world.func_180501_a(info.func_177508_d(), Blocks.field_150350_a.func_176223_P(), 2);
                world.func_217379_c(2001, info.func_177508_d(), Block.func_196246_j((BlockState)info.func_177509_a()));
            }
        }
    }

    private static void addGolem(PatternType type, World world, BlockPattern.PatternHelper pattern, int x, int y) {
        GolemEntity entity = (GolemEntity)type.getSupplierEntity().get().func_200721_a(world);
        BlockPos pos = pattern.func_177670_a(x, y, 0).func_177508_d();
        entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.05, (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
        world.func_217376_c((Entity)entity);
        for (ServerPlayerEntity player : world.func_217357_a(ServerPlayerEntity.class, entity.func_174813_aQ().func_186662_g(5.0))) {
            CriteriaTriggers.field_192133_m.func_192229_a(player, (Entity)entity);
        }
    }

    private static void notifySmall(PatternType type, BlockPattern.PatternHelper pattern, World world) {
        for (int j1 = 0; j1 < type.getHeight(); ++j1) {
            CachedBlockInfo cachedblockinfo1 = pattern.func_177670_a(0, j1, 0);
            world.func_230547_a_(cachedblockinfo1.func_177508_d(), Blocks.field_150350_a);
        }
    }

    private static void notifyLarge(PatternType type, BlockPattern.PatternHelper pattern, World world) {
        for (int i1 = 0; i1 < type.getWidth(); ++i1) {
            for (int j1 = 0; j1 < type.getHeight(); ++j1) {
                CachedBlockInfo cachedblockinfo1 = pattern.func_177670_a(i1, j1, 0);
                world.func_230547_a_(cachedblockinfo1.func_177508_d(), Blocks.field_150350_a);
            }
        }
    }
}

