/*
 * Decompiled with CFR 0.152.
 */
package com.androsa.ornamental;

import com.androsa.ornamental.ColourHandler;
import com.androsa.ornamental.OrnamentalConfig;
import com.androsa.ornamental.data.OrnamentalBlockStates;
import com.androsa.ornamental.data.OrnamentalBlockTags;
import com.androsa.ornamental.data.OrnamentalItemModels;
import com.androsa.ornamental.data.OrnamentalItemTags;
import com.androsa.ornamental.data.OrnamentalLootTables;
import com.androsa.ornamental.data.OrnamentalRecipes;
import com.androsa.ornamental.data.conditions.ConfigCondition;
import com.androsa.ornamental.registry.ModBlocks;
import com.androsa.ornamental.registry.ModEntities;
import com.androsa.ornamental.registry.ModParticles;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="ornamental")
@Mod.EventBusSubscriber(modid="ornamental", bus=Mod.EventBusSubscriber.Bus.MOD)
public class OrnamentalMod {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "ornamental";
    public static OrnamentalConfig config;

    public OrnamentalMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::gatherData);
        ModBlocks.BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ModBlocks.ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ModEntities.ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        ModParticles.PARTICLE_TYPE.register(FMLJavaModLoadingContext.get().getModEventBus());
        Pair specPair = new ForgeConfigSpec.Builder().configure(OrnamentalConfig::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (ForgeConfigSpec)specPair.getRight());
        config = (OrnamentalConfig)specPair.getLeft();
    }

    private void setup(FMLCommonSetupEvent event) {
        ModEntities.addEntityAttributes();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> OrnamentalMod::registerRenders);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ColourHandler::registerBlockColors);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ColourHandler::registerItemColors);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ModEntities::registerRenders);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ModParticles::registerClientParticles);
    }

    @SubscribeEvent
    public static void registerSerializer(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        CraftingHelper.register((IConditionSerializer)new ConfigCondition.Serializer());
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        OrnamentalBlockTags blockTags = new OrnamentalBlockTags(generator, helper);
        if (event.includeClient()) {
            generator.func_200390_a((IDataProvider)new OrnamentalBlockStates(generator, helper));
            generator.func_200390_a((IDataProvider)new OrnamentalItemModels(generator, helper));
        }
        if (event.includeServer()) {
            generator.func_200390_a((IDataProvider)new OrnamentalLootTables(generator));
            generator.func_200390_a((IDataProvider)new OrnamentalRecipes(generator));
            generator.func_200390_a((IDataProvider)blockTags);
            generator.func_200390_a((IDataProvider)new OrnamentalItemTags(generator, blockTags, helper));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void registerRenders() {
        OrnamentalMod.renderBlock(ModBlocks.grass_stairs, RenderType.func_228641_d_());
        OrnamentalMod.renderBlock(ModBlocks.path_stairs, RenderType.func_228641_d_());
        OrnamentalMod.renderBlock(ModBlocks.ice_stairs, RenderType.func_228645_f_());
        OrnamentalMod.renderBlock(ModBlocks.grass_slab, RenderType.func_228641_d_());
        OrnamentalMod.renderBlock(ModBlocks.path_slab, RenderType.func_228641_d_());
        OrnamentalMod.renderBlock(ModBlocks.ice_slab, RenderType.func_228645_f_());
        OrnamentalMod.renderBlock(ModBlocks.grass_fence, RenderType.func_228641_d_());
        OrnamentalMod.renderBlock(ModBlocks.path_fence, RenderType.func_228641_d_());
        OrnamentalMod.renderBlock(ModBlocks.ice_fence, RenderType.func_228645_f_());
        OrnamentalMod.renderBlock(ModBlocks.gold_trapdoor, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.diamond_trapdoor, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.emerald_trapdoor, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.lapis_trapdoor, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.obsidian_trapdoor, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.coal_trapdoor, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.redstone_trapdoor, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.missingno_trapdoor, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.clay_trapdoor, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.dirt_trapdoor, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.grass_trapdoor, RenderType.func_228641_d_());
        OrnamentalMod.renderBlock(ModBlocks.hay_trapdoor, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.path_trapdoor, RenderType.func_228641_d_());
        OrnamentalMod.renderBlock(ModBlocks.brick_trapdoor, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.quartz_trapdoor, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.bone_trapdoor, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.nether_brick_trapdoor, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.red_nether_brick_trapdoor, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.snow_trapdoor, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.ice_trapdoor, RenderType.func_228645_f_());
        OrnamentalMod.renderBlock(ModBlocks.packed_ice_trapdoor, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.blue_ice_trapdoor, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.grass_fence_gate, RenderType.func_228641_d_());
        OrnamentalMod.renderBlock(ModBlocks.path_fence_gate, RenderType.func_228641_d_());
        OrnamentalMod.renderBlock(ModBlocks.ice_fence_gate, RenderType.func_228645_f_());
        OrnamentalMod.renderBlock(ModBlocks.gold_door, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.diamond_door, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.emerald_door, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.lapis_door, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.obsidian_door, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.coal_door, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.redstone_door, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.missingno_door, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.clay_door, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.dirt_door, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.grass_door, RenderType.func_228641_d_());
        OrnamentalMod.renderBlock(ModBlocks.hay_door, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.path_door, RenderType.func_228641_d_());
        OrnamentalMod.renderBlock(ModBlocks.brick_door, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.quartz_door, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.bone_door, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.nether_brick_door, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.red_nether_brick_door, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.snow_door, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.ice_door, RenderType.func_228645_f_());
        OrnamentalMod.renderBlock(ModBlocks.packed_ice_door, RenderType.func_228643_e_());
        OrnamentalMod.renderBlock(ModBlocks.blue_ice_door, RenderType.func_228643_e_());
    }

    private static void renderBlock(Supplier<? extends Block> block, RenderType render) {
        RenderTypeLookup.setRenderLayer((Block)block.get(), (RenderType)render);
    }
}

