/*
 * Decompiled with CFR 0.152.
 */
package com.androsa.ornamental.blocks;

import com.androsa.ornamental.blocks.IOrnamentalBlock;
import com.androsa.ornamental.builder.OrnamentBuilder;
import com.androsa.ornamental.registry.ModBlocks;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShovelItem;
import net.minecraft.state.Property;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;

public class OrnamentSlab
extends SlabBlock
implements IOrnamentalBlock {
    protected static final VoxelShape PATH_BOTTOM_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    protected static final VoxelShape PATH_TOP_SHAPE = Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    protected static final VoxelShape PATH_FULL_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    private final OrnamentBuilder builder;

    public OrnamentSlab(AbstractBlock.Properties props, OrnamentBuilder builder) {
        super(props);
        this.builder = builder;
    }

    @Override
    public OrnamentBuilder getBuilder() {
        return this.builder;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (this.builder.isPath || this.builder.pathShape) {
            SlabType slabtype = (SlabType)state.func_177229_b((Property)field_196505_a);
            switch (slabtype) {
                case DOUBLE: {
                    return PATH_FULL_SHAPE;
                }
                case TOP: {
                    return PATH_TOP_SHAPE;
                }
            }
            return PATH_BOTTOM_SHAPE;
        }
        return super.func_220053_a(state, worldIn, pos, context);
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        entityIn.func_225503_b_(fallDistance, this.builder.fallMultiplier);
    }

    @Deprecated
    public boolean func_149744_f(BlockState state) {
        return this.builder.hasPower;
    }

    @Deprecated
    public int func_180656_a(BlockState state, IBlockReader reader, BlockPos pos, Direction side) {
        if (this.builder.hasPower) {
            return state.func_177229_b((Property)field_196505_a) == SlabType.DOUBLE ? 15 : 7;
        }
        return super.func_180656_a(state, reader, pos, side);
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (!itemstack.func_190926_b()) {
            if ((this.builder.isDirt || this.builder.mealGrass) && item == Items.field_196106_bc) {
                return this.changeBlock(itemstack, (Supplier<? extends OrnamentSlab>)ModBlocks.grass_slab, SoundEvents.field_187571_bR, worldIn, pos, player, hand);
            }
            if ((this.builder.isGrass || this.builder.hoeDirt) && item instanceof HoeItem) {
                return this.changeBlock(itemstack, (Supplier<? extends OrnamentSlab>)ModBlocks.dirt_slab, SoundEvents.field_187581_bW, worldIn, pos, player, hand);
            }
            if ((this.builder.isGrass || this.builder.shovelPath) && item instanceof ShovelItem) {
                return this.changeBlock(itemstack, (Supplier<? extends OrnamentSlab>)ModBlocks.path_slab, SoundEvents.field_187771_eN, worldIn, pos, player, hand);
            }
            if ((this.builder.isPath || this.builder.hoeGrass) && item instanceof HoeItem) {
                return this.changeBlock(itemstack, (Supplier<? extends OrnamentSlab>)ModBlocks.grass_slab, SoundEvents.field_187571_bR, worldIn, pos, player, hand);
            }
        }
        return super.func_225533_a_(state, worldIn, pos, player, hand, result);
    }

    private ActionResultType changeBlock(ItemStack itemstack, Supplier<? extends OrnamentSlab> newblock, SoundEvent sound, World worldIn, BlockPos pos, PlayerEntity player, Hand hand) {
        this.setBlock(worldIn, pos, newblock);
        worldIn.func_184133_a(null, pos, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!player.field_71075_bZ.field_75098_d && !itemstack.func_77984_f()) {
            itemstack.func_190918_g(1);
        } else {
            itemstack.func_222118_a(1, (LivingEntity)player, user -> user.func_213334_d(hand));
        }
        return ActionResultType.SUCCESS;
    }

    private void setBlock(World world, BlockPos pos, Supplier<? extends OrnamentSlab> block) {
        BlockState state = world.func_180495_p(pos);
        world.func_175656_a(pos, (BlockState)((BlockState)block.get().func_176223_P().func_206870_a((Property)field_196505_a, state.func_177229_b((Property)field_196505_a))).func_206870_a((Property)field_204512_b, state.func_177229_b((Property)field_204512_b)));
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState otherState, Direction direction) {
        if ((this.builder.isIce || this.builder.breakableCull) && otherState.func_177230_c() instanceof OrnamentSlab && state.func_177230_c() instanceof OrnamentSlab) {
            OrnamentSlab slab = (OrnamentSlab)state.func_177230_c();
            OrnamentSlab otherSlab = (OrnamentSlab)otherState.func_177230_c();
            if (otherSlab.getBuilder() == slab.getBuilder() && otherState.func_177229_b((Property)field_196505_a) == SlabType.DOUBLE && state.func_177229_b((Property)field_196505_a) == SlabType.DOUBLE) {
                return true;
            }
        }
        return super.func_200122_a(state, otherState, direction);
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        if (this.builder.hasConfig) {
            ForgeConfigSpec.BooleanValue val = this.builder.booleanValue.get();
            if (val == null) {
                throw new NullPointerException(this.builder.name + " expected a config value but found null.");
            }
            if (((Boolean)val.get()).booleanValue()) {
                super.func_176208_a(world, pos, state, player);
            }
        }
    }

    @Deprecated
    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        super.func_225542_b_(state, worldIn, pos, random);
        if ((this.builder.isIce || this.builder.canMelt) && worldIn.func_226658_a_(LightType.BLOCK, pos) > 11 - state.func_200016_a((IBlockReader)worldIn, pos)) {
            this.turnIntoWater((World)worldIn, pos);
        }
    }

    protected void turnIntoWater(World world, BlockPos pos) {
        if (world.func_230315_m_().func_236040_e_() && this.builder.canVaporise) {
            world.func_217377_a(pos, false);
        } else {
            world.func_175656_a(pos, this.builder.meltResult.func_176223_P());
            world.func_190524_a(pos, this.builder.meltResult, pos);
        }
    }

    @Deprecated
    public PushReaction func_149656_h(BlockState state) {
        return this.builder.isIce ? PushReaction.NORMAL : this.builder.pushReaction;
    }
}

