/*
 * Decompiled with CFR 0.152.
 */
package com.androsa.ornamental.builder;

import com.androsa.ornamental.OrnamentalMod;
import com.androsa.ornamental.data.conditions.ConfigCondition;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.EntityType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ToolType;

public class OrnamentBuilder {
    public final String name;
    public Material material = Material.field_151576_e;
    public MaterialColor color = this.material.func_151565_r();
    public SoundType sound = SoundType.field_185851_d;
    public float hardness = 0.0f;
    public float resistance = 0.0f;
    public ToolType harvestTool = null;
    public int harvestLevel = 0;
    public float fallMultiplier = 1.0f;
    public float slipperiness = 0.6f;
    public int[] burnTime = new int[]{0, 0, 0, 0, 0, 0};
    public boolean canOpen = false;
    public boolean hasPower = false;
    public boolean doesTick = false;
    public boolean requiresTool = false;
    public boolean fireproof = false;
    public AbstractBlock.IExtendedPositionPredicate<EntityType<?>> entitySpawnPredicate = null;
    public boolean hasConfig = false;
    @Deprecated
    public boolean isDirt = false;
    public boolean mealGrass = false;
    @Deprecated
    public boolean isGrass = false;
    public boolean hoeDirt = false;
    public boolean shovelPath = false;
    @Deprecated
    public boolean isPath = false;
    public boolean pathShape = false;
    public boolean hoeGrass = false;
    @Deprecated
    public boolean isIce = false;
    public boolean canMelt = false;
    public Block meltResult = Blocks.field_150355_j;
    public boolean canVaporise = false;
    public boolean isSolid = true;
    public boolean breakableCull = false;
    public PushReaction pushReaction = this.material.func_186274_m();
    public Supplier<ForgeConfigSpec.BooleanValue> booleanValue = null;

    public OrnamentBuilder(String name) {
        this.name = name;
    }

    public OrnamentBuilder properties(Material material) {
        this.material = material;
        this.color = material.func_151565_r();
        return this;
    }

    public OrnamentBuilder properties(Material material, MaterialColor color) {
        this.material = material;
        this.color = color;
        return this;
    }

    public OrnamentBuilder sound(SoundType sound) {
        this.sound = sound;
        return this;
    }

    public OrnamentBuilder hardness(float amount) {
        this.hardness = amount;
        return this;
    }

    public OrnamentBuilder hardnessAndResistance(float amount) {
        this.hardness = amount;
        this.resistance = amount;
        return this;
    }

    public OrnamentBuilder hardnessAndResistance(float hard, float resist) {
        this.hardness = hard;
        this.resistance = resist;
        return this;
    }

    public OrnamentBuilder tool(ToolType tool, boolean required) {
        this.harvestTool = tool;
        this.requiresTool = required;
        return this;
    }

    public OrnamentBuilder tool(ToolType tool, int level, boolean required) {
        this.harvestTool = tool;
        this.harvestLevel = level;
        this.requiresTool = required;
        return this;
    }

    public OrnamentBuilder fall(float amount) {
        this.fallMultiplier = amount;
        return this;
    }

    public OrnamentBuilder slip(float amount) {
        this.slipperiness = amount;
        return this;
    }

    public OrnamentBuilder burnTime(int door, int fence, int gate, int slab, int stairs, int trap) {
        this.burnTime = new int[]{door, fence, gate, slab, stairs, trap};
        return this;
    }

    public OrnamentBuilder canOpen() {
        this.canOpen = true;
        return this;
    }

    public OrnamentBuilder hasPower() {
        this.hasPower = true;
        return this;
    }

    public OrnamentBuilder ticks() {
        this.doesTick = true;
        return this;
    }

    public OrnamentBuilder isFireproof() {
        this.fireproof = true;
        return this;
    }

    public OrnamentBuilder setCanEntitySpawn(AbstractBlock.IExtendedPositionPredicate<EntityType<?>> predicate) {
        this.entitySpawnPredicate = predicate;
        return this;
    }

    @Deprecated
    public OrnamentBuilder isDirtMaterial() {
        this.isDirt = true;
        return this;
    }

    public OrnamentBuilder boneMealToGrass() {
        this.mealGrass = true;
        return this;
    }

    @Deprecated
    public OrnamentBuilder isGrassMaterial() {
        this.isGrass = true;
        return this;
    }

    public OrnamentBuilder hoeToDirt() {
        this.hoeDirt = true;
        return this;
    }

    public OrnamentBuilder shovelToPath() {
        this.shovelPath = true;
        return this;
    }

    @Deprecated
    public OrnamentBuilder isPathMaterial() {
        this.isPath = true;
        return this;
    }

    public OrnamentBuilder usePathShapes() {
        this.pathShape = true;
        return this;
    }

    public OrnamentBuilder hoeToGrass() {
        this.hoeGrass = true;
        return this;
    }

    @Deprecated
    public OrnamentBuilder isIceMaterial() {
        this.isIce = true;
        return this;
    }

    public OrnamentBuilder canMelt(Block melt, boolean vaporise) {
        this.canMelt = true;
        this.meltResult = melt;
        if (!this.meltResult.func_176223_P().func_185904_a().func_76224_d()) {
            OrnamentalMod.LOGGER.warn("Supplied melt result for {} was not a liquid, was {}! Defaulting to Water.", (Object)this.name, (Object)melt.func_176223_P().func_185904_a());
            this.meltResult = Blocks.field_150355_j;
        }
        this.canVaporise = vaporise;
        return this;
    }

    public OrnamentBuilder notSolid() {
        this.isSolid = false;
        return this;
    }

    public OrnamentBuilder doBreakableBlockCull() {
        this.breakableCull = true;
        return this;
    }

    public OrnamentBuilder pushReactOverride(PushReaction reaction) {
        this.pushReaction = reaction;
        return this;
    }

    public OrnamentBuilder config(Supplier<ForgeConfigSpec.BooleanValue> entry) {
        this.booleanValue = entry;
        this.hasConfig = true;
        ConfigCondition.putValue(this, entry);
        return this;
    }
}

