/*
 * Decompiled with CFR 0.152.
 */
package com.androsa.ornamental.data.conditions;

import com.androsa.ornamental.builder.OrnamentBuilder;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class ConfigCondition
implements ICondition {
    private final String config;
    private static Map<OrnamentBuilder, Supplier<ForgeConfigSpec.BooleanValue>> configMap = Maps.newHashMap();

    public ConfigCondition(String config) {
        this.config = config;
    }

    public ResourceLocation getID() {
        return new ResourceLocation("ornamental", "config");
    }

    public boolean test() {
        for (Supplier<ForgeConfigSpec.BooleanValue> type : configMap.values()) {
            if (!this.getConfigName(type).equals(this.config)) continue;
            return (Boolean)type.get().get();
        }
        return false;
    }

    private String getConfigName(Supplier<ForgeConfigSpec.BooleanValue> type) {
        return (String)type.get().getPath().get(0);
    }

    public String toString() {
        return "config";
    }

    public static void putValue(OrnamentBuilder builder, Supplier<ForgeConfigSpec.BooleanValue> value) {
        configMap.put(builder, value);
    }

    public static class Serializer
    implements IConditionSerializer<ConfigCondition> {
        public void write(JsonObject json, ConfigCondition value) {
            json.addProperty("config", value.config);
        }

        public ConfigCondition read(JsonObject json) {
            return new ConfigCondition(JSONUtils.func_151200_h((JsonObject)json, (String)"config"));
        }

        public ResourceLocation getID() {
            return new ResourceLocation("ornamental", "config");
        }
    }
}

