/*
 * Decompiled with CFR 0.152.
 */
package com.androsa.ornamental.data.provider;

import com.androsa.ornamental.data.provider.OrnamentalBlockModelProvider;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public abstract class OrnamentalBlockStateProvider
extends BlockStateProvider {
    private final OrnamentalBlockModelProvider blockModels;

    public OrnamentalBlockStateProvider(DataGenerator generator, String modid, ExistingFileHelper helper) {
        super(generator, modid, helper);
        this.blockModels = new OrnamentalBlockModelProvider(generator, helper){

            protected void registerModels() {
            }

            public String func_200397_b() {
                return OrnamentalBlockStateProvider.this.func_200397_b();
            }
        };
    }

    @Nonnull
    public String func_200397_b() {
        return "Ornamental Blockstates and Block Models";
    }

    public OrnamentalBlockModelProvider models() {
        return this.blockModels;
    }

    protected ResourceLocation locVanilla(String name) {
        return new ResourceLocation("block/" + name);
    }

    protected ResourceLocation locOrnament(String name) {
        return new ResourceLocation("ornamental", "block/" + name);
    }

    public void stairsBasic(Supplier<? extends StairsBlock> block, String name) {
        this.stairsBlock(block.get(), this.locVanilla(name));
    }

    public void stairsMissing(Supplier<? extends StairsBlock> block) {
        this.stairsBlock(block.get(), this.locOrnament("missingno"));
    }

    public void stairsColumn(Supplier<? extends StairsBlock> block, String side, String end) {
        this.stairsBlock(block.get(), this.locVanilla(side), this.locVanilla(end), this.locVanilla(end));
    }

    public void slabBasic(Supplier<? extends SlabBlock> block, String name) {
        this.slabBlock(block.get(), this.locVanilla(name), this.locVanilla(name));
    }

    public void slabMissing(Supplier<? extends SlabBlock> block) {
        this.slabBlock(block.get(), this.locOrnament("missingno"), this.locOrnament("missingno"));
    }

    public void slabModel(Supplier<? extends SlabBlock> block, String model, String name) {
        this.slabBlock(block.get(), this.locVanilla(model), this.locVanilla(name));
    }

    public void slabColumn(Supplier<? extends SlabBlock> block, String blockname, String side, String end) {
        this.slabBlock(block.get(), this.locVanilla(blockname), this.locVanilla(side), this.locVanilla(end), this.locVanilla(end));
    }

    public void fenceBasic(Supplier<? extends FenceBlock> block, String name) {
        this.fenceBlock(block.get(), this.locVanilla(name));
    }

    public void fenceMissing(Supplier<? extends FenceBlock> block) {
        this.fenceBlock(block.get(), this.locOrnament("missingno"));
    }

    public void fenceColumn(Supplier<? extends FenceBlock> block, String side, String top) {
        String baseName = block.get().getRegistryName().toString();
        this.fourWayBlock((FourWayBlock)block.get(), (ModelFile)this.models().fencePostColumn(baseName + "_post", this.locVanilla(side), this.locVanilla(top)), (ModelFile)this.models().fenceSide(baseName + "_side", this.locVanilla(side)));
    }

    public void trapdoorBasic(Supplier<? extends TrapDoorBlock> block, String name) {
        this.trapdoorBlock(block.get(), this.locOrnament(name + "_trapdoor"), true);
    }

    public void trapdoorMissing(Supplier<? extends TrapDoorBlock> block) {
        this.trapdoorBlock(block.get(), this.locOrnament("missingno"), false);
    }

    public void trapdoorVanilla(Supplier<? extends TrapDoorBlock> block, String name) {
        this.trapdoorBlock(block.get(), this.locVanilla(name), false);
    }

    public void fenceGateBasic(Supplier<? extends FenceGateBlock> block, String name) {
        this.fenceGateBlock(block.get(), this.locVanilla(name));
    }

    public void fenceGateMissing(Supplier<? extends FenceGateBlock> block) {
        this.fenceGateBlock(block.get(), this.locOrnament("missingno"));
    }

    public void fenceGateColumn(Supplier<? extends FenceGateBlock> block, String side, String top) {
        BlockModelBuilder gate = this.models().fenceGateColumn(block.get().getRegistryName().toString(), this.locVanilla(side), this.locVanilla(top));
        BlockModelBuilder gateOpen = this.models().fenceGateOpenColumn(block.get().getRegistryName().toString() + "_open", this.locVanilla(side), this.locVanilla(top));
        BlockModelBuilder gateWall = this.models().fenceGateWallColumn(block.get().getRegistryName().toString() + "_wall", this.locVanilla(side), this.locVanilla(top));
        BlockModelBuilder gateWallOpen = this.models().fenceGateWallOpenColumn(block.get().getRegistryName().toString() + "_wall_open", this.locVanilla(side), this.locVanilla(top));
        this.fenceGateBlock(block.get(), (ModelFile)gate, (ModelFile)gateOpen, (ModelFile)gateWall, (ModelFile)gateWallOpen);
    }

    public void doorBasic(Supplier<? extends DoorBlock> block, String name) {
        this.doorBlock(block.get(), this.locOrnament(name + "_door_bottom"), this.locOrnament(name + "_door_top"));
    }

    public void doorMissing(Supplier<? extends DoorBlock> block) {
        this.doorBlock(block.get(), this.locOrnament("missingno"), this.locOrnament("missingno"));
    }

    public void doorBasicVanilla(Supplier<? extends DoorBlock> block, String name) {
        this.doorBlock(block.get(), this.locVanilla(name), this.locVanilla(name));
    }
}

