/*
 * Decompiled with CFR 0.152.
 */
package com.androsa.ornamental.blocks;

import com.androsa.ornamental.blocks.IOrnamentalBlock;
import com.androsa.ornamental.builder.OrnamentBuilder;
import com.androsa.ornamental.registry.ModBlocks;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShovelItem;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;

public class OrnamentFenceGate
extends FenceGateBlock
implements IOrnamentalBlock {
    protected static final VoxelShape PATH_HITBOX_ZAXIS = Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)15.0, (double)10.0);
    protected static final VoxelShape PATH_HITBOX_XAXIS = Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)15.0, (double)16.0);
    protected static final VoxelShape PATH_HITBOX_ZAXIS_INWALL = Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)12.0, (double)10.0);
    protected static final VoxelShape PATH_HITBOX_XAXIS_INWALL = Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)12.0, (double)16.0);
    protected static final VoxelShape PATH_COLLISION_BOX_ZAXIS = Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)23.0, (double)10.0);
    protected static final VoxelShape PATH_COLLISION_BOX_XAXIS = Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)23.0, (double)16.0);
    protected static final VoxelShape PATH_RENDER_BOX_Z = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)4.0, (double)7.0, (double)2.0, (double)15.0, (double)9.0), (VoxelShape)Block.func_208617_a((double)14.0, (double)4.0, (double)7.0, (double)16.0, (double)15.0, (double)9.0));
    protected static final VoxelShape PATH_RENDER_BOX_X = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)7.0, (double)4.0, (double)0.0, (double)9.0, (double)15.0, (double)2.0), (VoxelShape)Block.func_208617_a((double)7.0, (double)4.0, (double)14.0, (double)9.0, (double)15.0, (double)16.0));
    protected static final VoxelShape PATH_RENDER_BOX_INWALL_Z = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)1.0, (double)7.0, (double)2.0, (double)12.0, (double)9.0), (VoxelShape)Block.func_208617_a((double)14.0, (double)1.0, (double)7.0, (double)16.0, (double)12.0, (double)9.0));
    protected static final VoxelShape PATH_RENDER_BOX_INWALL_X = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)7.0, (double)1.0, (double)0.0, (double)9.0, (double)12.0, (double)2.0), (VoxelShape)Block.func_208617_a((double)7.0, (double)1.0, (double)14.0, (double)9.0, (double)12.0, (double)16.0));
    private final OrnamentBuilder builder;

    public OrnamentFenceGate(AbstractBlock.Properties props, OrnamentBuilder builder) {
        super(props);
        this.builder = builder;
    }

    @Override
    public OrnamentBuilder getBuilder() {
        return this.builder;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (this.builder.isPath || this.builder.pathShape) {
            if (((Boolean)state.func_177229_b((Property)field_176467_M)).booleanValue()) {
                return ((Direction)state.func_177229_b((Property)field_185512_D)).func_176740_k() == Direction.Axis.X ? PATH_HITBOX_XAXIS_INWALL : PATH_HITBOX_ZAXIS_INWALL;
            }
            return ((Direction)state.func_177229_b((Property)field_185512_D)).func_176740_k() == Direction.Axis.X ? PATH_HITBOX_XAXIS : PATH_HITBOX_ZAXIS;
        }
        return super.func_220053_a(state, worldIn, pos, context);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (this.builder.isPath || this.builder.pathShape) {
            if (((Boolean)state.func_177229_b((Property)field_176466_a)).booleanValue()) {
                return VoxelShapes.func_197880_a();
            }
            return ((Direction)state.func_177229_b((Property)field_185512_D)).func_176740_k() == Direction.Axis.Z ? PATH_COLLISION_BOX_ZAXIS : PATH_COLLISION_BOX_XAXIS;
        }
        return super.func_220071_b(state, worldIn, pos, context);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        if (this.builder.isPath || this.builder.pathShape) {
            if (((Boolean)state.func_177229_b((Property)field_176467_M)).booleanValue()) {
                return ((Direction)state.func_177229_b((Property)field_185512_D)).func_176740_k() == Direction.Axis.X ? PATH_RENDER_BOX_INWALL_X : PATH_RENDER_BOX_INWALL_Z;
            }
            return ((Direction)state.func_177229_b((Property)field_185512_D)).func_176740_k() == Direction.Axis.X ? PATH_RENDER_BOX_X : PATH_RENDER_BOX_Z;
        }
        return super.func_196247_c(state, worldIn, pos);
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        entityIn.func_225503_b_(fallDistance, this.builder.fallMultiplier);
    }

    @Deprecated
    public boolean func_149744_f(BlockState state) {
        return this.builder.hasPower;
    }

    @Deprecated
    public int func_180656_a(BlockState blockState, IBlockReader blockReader, BlockPos pos, Direction side) {
        return this.builder.hasPower ? 3 : 0;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (!itemstack.func_190926_b()) {
            if ((this.builder.isDirt || this.builder.mealGrass) && item == Items.field_196106_bc) {
                return this.changeBlock(itemstack, (Supplier<? extends OrnamentFenceGate>)ModBlocks.grass_fence_gate, SoundEvents.field_187571_bR, worldIn, pos, player, hand);
            }
            if ((this.builder.isGrass || this.builder.hoeDirt) && item instanceof HoeItem) {
                return this.changeBlock(itemstack, (Supplier<? extends OrnamentFenceGate>)ModBlocks.dirt_fence_gate, SoundEvents.field_187581_bW, worldIn, pos, player, hand);
            }
            if ((this.builder.isGrass || this.builder.shovelPath) && item instanceof ShovelItem) {
                return this.changeBlock(itemstack, (Supplier<? extends OrnamentFenceGate>)ModBlocks.path_fence_gate, SoundEvents.field_187771_eN, worldIn, pos, player, hand);
            }
            if ((this.builder.isPath || this.builder.hoeGrass) && item instanceof HoeItem) {
                return this.changeBlock(itemstack, (Supplier<? extends OrnamentFenceGate>)ModBlocks.grass_fence_gate, SoundEvents.field_187571_bR, worldIn, pos, player, hand);
            }
        }
        return this.performNormally(state, worldIn, pos, player);
    }

    private ActionResultType performNormally(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        if (!this.builder.hasPower) {
            return ActionResultType.PASS;
        }
        if (((Boolean)state.func_177229_b((Property)field_176466_a)).booleanValue()) {
            state = (BlockState)state.func_206870_a((Property)field_176466_a, (Comparable)Boolean.FALSE);
            worldIn.func_180501_a(pos, state, 10);
        } else {
            Direction enumfacing = player.func_174811_aO();
            if (state.func_177229_b((Property)field_185512_D) == enumfacing.func_176734_d()) {
                state = (BlockState)state.func_206870_a((Property)field_185512_D, (Comparable)enumfacing);
            }
            state = (BlockState)state.func_206870_a((Property)field_176466_a, (Comparable)Boolean.TRUE);
            worldIn.func_180501_a(pos, state, 10);
        }
        worldIn.func_217378_a(player, (Boolean)state.func_177229_b((Property)field_176466_a) != false ? 1008 : 1014, pos, 0);
        return ActionResultType.SUCCESS;
    }

    private ActionResultType changeBlock(ItemStack itemstack, Supplier<? extends OrnamentFenceGate> newblock, SoundEvent sound, World worldIn, BlockPos pos, PlayerEntity player, Hand hand) {
        this.setBlock(worldIn, pos, newblock);
        worldIn.func_184133_a(null, pos, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!player.field_71075_bZ.field_75098_d && !itemstack.func_77984_f()) {
            itemstack.func_190918_g(1);
        } else {
            itemstack.func_222118_a(1, (LivingEntity)player, user -> user.func_213334_d(hand));
        }
        return ActionResultType.SUCCESS;
    }

    private void setBlock(World world, BlockPos pos, Supplier<? extends OrnamentFenceGate> block) {
        BlockState state = world.func_180495_p(pos);
        world.func_175656_a(pos, (BlockState)((BlockState)((BlockState)((BlockState)block.get().func_176223_P().func_206870_a((Property)field_185512_D, state.func_177229_b((Property)field_185512_D))).func_206870_a((Property)field_176466_a, state.func_177229_b((Property)field_176466_a))).func_206870_a((Property)field_176465_b, state.func_177229_b((Property)field_176465_b))).func_206870_a((Property)field_176467_M, state.func_177229_b((Property)field_176467_M)));
    }

    public boolean canHarvestBlock(BlockState state, IBlockReader world, BlockPos pos, PlayerEntity player) {
        if (this.builder.hasConfig) {
            ForgeConfigSpec.BooleanValue val = this.builder.booleanValue.get();
            if (val == null) {
                throw new NullPointerException(this.builder.name + " expected a config value but found null.");
            }
            return (Boolean)val.get() != false && super.canHarvestBlock(state, world, pos, player);
        }
        return super.canHarvestBlock(state, world, pos, player);
    }

    @Deprecated
    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        super.func_225542_b_(state, worldIn, pos, random);
        if ((this.builder.isIce || this.builder.canMelt) && worldIn.func_226658_a_(LightType.BLOCK, pos) > 11 - state.func_200016_a((IBlockReader)worldIn, pos)) {
            this.turnIntoWater((World)worldIn, pos);
        }
    }

    protected void turnIntoWater(World world, BlockPos pos) {
        if (world.func_230315_m_().func_236040_e_() && this.builder.canVaporise) {
            world.func_217377_a(pos, false);
        } else {
            world.func_175656_a(pos, this.builder.meltResult.func_176223_P());
            world.func_190524_a(pos, this.builder.meltResult, pos);
        }
    }

    @Deprecated
    public PushReaction func_149656_h(BlockState state) {
        return this.builder.isIce ? PushReaction.NORMAL : this.builder.pushReaction;
    }
}

