/*
 * Decompiled with CFR 0.152.
 */
package com.androsa.ornamental.blocks;

import com.androsa.ornamental.blocks.IOrnamentalBlock;
import com.androsa.ornamental.builder.OrnamentBuilder;
import com.androsa.ornamental.registry.ModBlocks;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShovelItem;
import net.minecraft.state.Property;
import net.minecraft.state.properties.Half;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;

public class OrnamentTrapDoor
extends TrapDoorBlock
implements IOrnamentalBlock {
    protected static final VoxelShape PATH_EAST_OPEN_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    protected static final VoxelShape PATH_WEST_OPEN_AABB = Block.func_208617_a((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape PATH_SOUTH_OPEN_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    protected static final VoxelShape PATH_NORTH_OPEN_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape PATH_BOTTOM_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    protected static final VoxelShape PATH_TOP_AABB = Block.func_208617_a((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    private final OrnamentBuilder builder;

    public OrnamentTrapDoor(AbstractBlock.Properties props, OrnamentBuilder builder) {
        super(props);
        this.builder = builder;
    }

    @Override
    public OrnamentBuilder getBuilder() {
        return this.builder;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (this.builder.isPath || this.builder.pathShape) {
            if (!((Boolean)state.func_177229_b((Property)field_176283_b)).booleanValue()) {
                return state.func_177229_b((Property)field_176285_M) == Half.TOP ? PATH_TOP_AABB : PATH_BOTTOM_AABB;
            }
            switch ((Direction)state.func_177229_b((Property)field_185512_D)) {
                default: {
                    return PATH_NORTH_OPEN_AABB;
                }
                case SOUTH: {
                    return PATH_SOUTH_OPEN_AABB;
                }
                case WEST: {
                    return PATH_WEST_OPEN_AABB;
                }
                case EAST: 
            }
            return PATH_EAST_OPEN_AABB;
        }
        return super.func_220053_a(state, worldIn, pos, context);
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        entityIn.func_225503_b_(fallDistance, this.builder.fallMultiplier);
    }

    @Deprecated
    public boolean func_149744_f(BlockState state) {
        return this.builder.hasPower;
    }

    @Deprecated
    public int func_180656_a(BlockState blockState, IBlockReader blockReader, BlockPos pos, Direction side) {
        return this.builder.hasPower ? 5 : 0;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (!itemstack.func_190926_b()) {
            if ((this.builder.isDirt || this.builder.mealGrass) && item == Items.field_196106_bc) {
                return this.changeBlock(itemstack, (Supplier<? extends OrnamentTrapDoor>)ModBlocks.grass_trapdoor, SoundEvents.field_187571_bR, worldIn, pos, player, hand);
            }
            if ((this.builder.isGrass || this.builder.hoeDirt) && item instanceof HoeItem) {
                return this.changeBlock(itemstack, (Supplier<? extends OrnamentTrapDoor>)ModBlocks.dirt_trapdoor, SoundEvents.field_187581_bW, worldIn, pos, player, hand);
            }
            if ((this.builder.isGrass || this.builder.shovelPath) && item instanceof ShovelItem) {
                return this.changeBlock(itemstack, (Supplier<? extends OrnamentTrapDoor>)ModBlocks.path_trapdoor, SoundEvents.field_187771_eN, worldIn, pos, player, hand);
            }
            if ((this.builder.isPath || this.builder.hoeGrass) && item instanceof HoeItem) {
                return this.changeBlock(itemstack, (Supplier<? extends OrnamentTrapDoor>)ModBlocks.grass_trapdoor, SoundEvents.field_187571_bR, worldIn, pos, player, hand);
            }
        }
        return this.performNormally(state, worldIn, pos, player);
    }

    private ActionResultType performNormally(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        if (!this.builder.canOpen) {
            return ActionResultType.PASS;
        }
        state = (BlockState)state.func_235896_a_((Property)field_176283_b);
        world.func_180501_a(pos, state, 2);
        if (((Boolean)state.func_177229_b((Property)field_204614_t)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        this.func_185731_a(player, world, pos, (Boolean)state.func_177229_b((Property)field_176283_b));
        return ActionResultType.SUCCESS;
    }

    private ActionResultType changeBlock(ItemStack itemstack, Supplier<? extends OrnamentTrapDoor> newblock, SoundEvent sound, World worldIn, BlockPos pos, PlayerEntity player, Hand hand) {
        this.setBlock(worldIn, pos, newblock);
        worldIn.func_184133_a(null, pos, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!player.field_71075_bZ.field_75098_d && !itemstack.func_77984_f()) {
            itemstack.func_190918_g(1);
        } else {
            itemstack.func_222118_a(1, (LivingEntity)player, user -> user.func_213334_d(hand));
        }
        return ActionResultType.SUCCESS;
    }

    private void setBlock(World world, BlockPos pos, Supplier<? extends OrnamentTrapDoor> block) {
        BlockState state = world.func_180495_p(pos);
        world.func_175656_a(pos, (BlockState)((BlockState)((BlockState)((BlockState)block.get().func_176223_P().func_206870_a((Property)field_196381_c, state.func_177229_b((Property)field_196381_c))).func_206870_a((Property)field_176283_b, state.func_177229_b((Property)field_176283_b))).func_206870_a((Property)field_176285_M, state.func_177229_b((Property)field_176285_M))).func_206870_a((Property)field_204614_t, state.func_177229_b((Property)field_204614_t)));
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        BlockState state = worldIn.func_180495_p(pos);
        if (!(((Boolean)state.func_177229_b((Property)field_176283_b)).booleanValue() || this.field_149764_J != Material.field_151571_B && this.field_149764_J != Material.field_151584_j && this.field_149764_J != Material.field_151580_n && this.field_149764_J != Material.field_151578_c && this.field_149764_J != Material.field_151577_b)) {
            state = (BlockState)state.func_235896_a_((Property)field_176283_b);
            worldIn.func_180501_a(pos, state, 2);
            this.func_185731_a(null, worldIn, pos, (Boolean)state.func_177229_b((Property)field_176283_b));
        }
    }

    protected void func_185731_a(@Nullable PlayerEntity player, World worldIn, BlockPos pos, boolean state) {
        if (state) {
            int i = this.field_149764_J == Material.field_151573_f ? 1037 : 1007;
            worldIn.func_217378_a(player, i, pos, 0);
        } else {
            int j = this.field_149764_J == Material.field_151573_f ? 1036 : 1013;
            worldIn.func_217378_a(player, j, pos, 0);
        }
    }

    public boolean canHarvestBlock(BlockState state, IBlockReader world, BlockPos pos, PlayerEntity player) {
        if (this.builder.hasConfig) {
            ForgeConfigSpec.BooleanValue val = this.builder.booleanValue.get();
            if (val == null) {
                throw new NullPointerException(this.builder.name + " expected a config value but found null.");
            }
            return (Boolean)val.get() != false && super.canHarvestBlock(state, world, pos, player);
        }
        return super.canHarvestBlock(state, world, pos, player);
    }

    @Deprecated
    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        super.func_225542_b_(state, worldIn, pos, random);
        if ((this.builder.isIce || this.builder.canMelt) && worldIn.func_226658_a_(LightType.BLOCK, pos) > 11 - state.func_200016_a((IBlockReader)worldIn, pos)) {
            this.turnIntoWater((World)worldIn, pos);
        }
    }

    protected void turnIntoWater(World world, BlockPos pos) {
        if (world.func_230315_m_().func_236040_e_() && this.builder.canVaporise) {
            world.func_217377_a(pos, false);
        } else {
            world.func_175656_a(pos, this.builder.meltResult.func_176223_P());
            world.func_190524_a(pos, this.builder.meltResult, pos);
        }
    }

    @Deprecated
    public PushReaction func_149656_h(BlockState state) {
        return this.builder.isIce ? PushReaction.NORMAL : this.builder.pushReaction;
    }
}

