/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.template.variable;

import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableSerializer;
import vazkii.patchouli.api.VariableHelper;
import vazkii.patchouli.client.book.template.variable.IngredientVariableSerializer;
import vazkii.patchouli.client.book.template.variable.ItemStackVariableSerializer;
import vazkii.patchouli.client.book.template.variable.TextComponentVariableSerializer;
import vazkii.patchouli.client.book.template.variable.Variable;

public class VariableHelperImpl
implements VariableHelper {
    public Map<Class<?>, IVariableSerializer<?>> serializers = new HashMap();

    public VariableHelperImpl() {
        this.registerSerializer(new ItemStackVariableSerializer(), class_1799.class);
        this.registerSerializer(new IngredientVariableSerializer(), class_1856.class);
        this.registerSerializer(new TextComponentVariableSerializer(), class_2561.class);
    }

    @Override
    public <T> IVariableSerializer<T> serializerForClass(Class<?> clazz) {
        return this.serializers.get(clazz);
    }

    @Override
    public <T> IVariable createFromObject(T object) {
        Class<?> clazz = object.getClass();
        for (Map.Entry<Class<?>, IVariableSerializer<?>> e : this.serializers.entrySet()) {
            if (!e.getKey().isAssignableFrom(clazz)) continue;
            return this.create(e.getValue().toJson(object), clazz);
        }
        throw new IllegalArgumentException(String.format("Can't serialize object %s of type %s to IVariable", object, clazz));
    }

    @Override
    public IVariable createFromJson(JsonElement elem) {
        return this.create(elem, null);
    }

    private IVariable create(JsonElement elem, Class<?> originator) {
        return new Variable(elem, originator);
    }

    @Override
    public <T> VariableHelper registerSerializer(IVariableSerializer<T> serializer, Class<T> clazz) {
        this.serializers.put(clazz, serializer);
        return this;
    }
}

