/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.text;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1077;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.text.Span;
import vazkii.patchouli.client.book.text.Word;

public class TextLayouter {
    private final List<Word> words = new ArrayList<Word>();
    private final GuiBook gui;
    private final int pageX;
    private final int lineHeight;
    private final int pageWidth;
    private int y;
    private List<Word> linkCluster = null;
    private List<Span> spanCluster = null;
    private final List<SpanTail> pending = new ArrayList<SpanTail>();
    private int lineStart = 0;
    private int widthSoFar = 0;
    private class_327 font;

    public TextLayouter(GuiBook gui, int pageX, int pageY, int lineHeight, int pageWidth) {
        this.gui = gui;
        this.pageX = pageX;
        this.lineHeight = lineHeight;
        this.pageWidth = pageWidth;
        this.y = pageY;
    }

    public void layout(class_327 font, List<Span> spans) {
        this.font = font;
        ArrayList<Span> paragraph = new ArrayList<Span>();
        for (Span span : spans) {
            if (span.lineBreaks > 0) {
                this.layoutParagraph(paragraph);
                this.widthSoFar = 0;
                this.y += span.lineBreaks * this.lineHeight;
                paragraph.clear();
            }
            paragraph.add(span);
        }
        if (!paragraph.isEmpty()) {
            this.layoutParagraph(paragraph);
        }
    }

    private void layoutParagraph(List<Span> paragraph) {
        String text = this.toString(paragraph);
        class_1077 language = class_310.method_1551().method_1526().method_4669();
        String[] splitLangCode = language.getName().split("_", 2);
        Locale locale = splitLangCode.length == 1 ? new Locale(language.getCode()) : new Locale(splitLangCode[0], splitLangCode[1]);
        BreakIterator iterator = BreakIterator.getLineInstance(locale);
        iterator.setText(text);
        this.lineStart = 0;
        for (Span span : paragraph) {
            this.layoutSpan(iterator, span);
        }
        this.flush();
    }

    private void layoutSpan(BreakIterator iterator, Span span) {
        if (this.spanCluster != span.linkCluster) {
            this.linkCluster = span.linkCluster == null ? null : new ArrayList();
            this.spanCluster = span.linkCluster;
        }
        SpanTail last = new SpanTail(span, 0, this.linkCluster);
        this.widthSoFar += last.width;
        this.pending.add(last);
        while (this.widthSoFar > this.pageWidth) {
            this.breakLine(iterator);
            this.widthSoFar = 0;
            for (SpanTail pending : this.pending) {
                this.widthSoFar += pending.width;
            }
        }
    }

    private void breakLine(BreakIterator iterator) {
        int width = 0;
        int offset = 0;
        for (SpanTail pending : this.pending) {
            width += pending.width;
            offset += pending.length;
        }
        SpanTail last = this.pending.get(this.pending.size() - 1);
        width -= last.width;
        offset -= last.length;
        char[] characters = ((SpanTail)last).span.text.toCharArray();
        for (int i = last.start; i < characters.length; ++i) {
            class_5250 tmp = new class_2585(String.valueOf(characters[i])).method_10862(((SpanTail)last).span.style);
            width += this.font.method_27525((class_5348)tmp);
            if (((SpanTail)last).span.bold) {
                ++width;
            }
            if (width <= this.pageWidth) continue;
            int overflowOffset = this.lineStart + offset + i - last.start;
            int breakOffset = overflowOffset + 1;
            if (!Character.isWhitespace(characters[i])) {
                breakOffset = iterator.preceding(breakOffset);
            }
            if (breakOffset <= this.lineStart) {
                breakOffset = overflowOffset - 1;
            }
            this.breakLine(breakOffset);
            return;
        }
        this.flush();
        this.y += this.lineHeight;
    }

    private String toString(List<Span> paragraph) {
        StringBuilder result = new StringBuilder();
        for (Span span : paragraph) {
            result.append(span.text);
        }
        return result.toString();
    }

    public void flush() {
        if (this.pending.isEmpty()) {
            return;
        }
        int x = this.pageX;
        for (SpanTail pending : this.pending) {
            this.words.add(pending.position(this.gui, x, this.y, pending.length));
            x += pending.width;
        }
        this.pending.clear();
    }

    private void breakLine(int textOffset) {
        int offset = this.lineStart;
        int x = this.pageX;
        for (int index = 0; index < this.pending.size(); ++index) {
            SpanTail span = this.pending.get(index);
            if (offset + span.length < textOffset) {
                this.words.add(span.position(this.gui, x, this.y, span.length));
                offset += span.length;
                x += span.width;
                continue;
            }
            this.words.add(span.position(this.gui, x, this.y, textOffset - offset));
            this.pending.set(index, span.tail(textOffset - offset));
            break;
        }
        for (int i = index - 1; i >= 0; --i) {
            this.pending.remove(i);
        }
        this.lineStart = textOffset;
        this.y += this.lineHeight;
    }

    public List<Word> getWords() {
        return this.words;
    }

    private class SpanTail {
        private final Span span;
        private final int start;
        private final int width;
        private final List<Word> cluster;
        private final int length;

        public SpanTail(Span span, int start, List<Word> cluster) {
            this.span = span;
            this.start = start;
            this.width = TextLayouter.this.font.method_27525((class_5348)span.styledSubstring(start)) + span.spacingLeft + span.spacingRight;
            this.cluster = cluster;
            this.length = span.text.length() - start;
        }

        public Word position(GuiBook gui, int x, int y, int length) {
            Word result = new Word(gui, this.span, this.span.styledSubstring(this.start, this.start + length), x += this.span.spacingLeft, y, this.width, this.cluster);
            if (this.cluster != null) {
                this.cluster.add(result);
            }
            return result;
        }

        public SpanTail tail(int offset) {
            return new SpanTail(this.span, this.start + offset, this.cluster);
        }
    }
}

