/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Base;

import com.google.gson.annotations.Expose;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Structures.Base.BuildProperty;
import com.wuest.prefab.Structures.Base.PositionOffset;
import com.wuest.prefab.Structures.Base.Structure;
import com.wuest.prefab.Structures.Config.StructureConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.block.LeverBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BuildBlock {
    public BlockPos blockPos;
    @Expose
    private String blockDomain;
    @Expose
    private String blockName;
    @Expose
    private PositionOffset startingPosition;
    @Expose
    private ArrayList<BuildProperty> properties;
    @Expose
    private BuildBlock subBlock;
    @Expose
    private boolean hasFacing;
    @Expose
    private BlockState state;
    @Expose
    private String blockStateData;

    public BuildBlock() {
        this.Initialize();
    }

    public static BuildBlock SetBlockState(StructureConfiguration configuration, World world, BlockPos originalPos, Direction assumedNorth, BuildBlock block, Block foundBlock, BlockState blockState, Structure structure) {
        try {
            if (!block.blockStateData.equals("")) {
                return BuildBlock.SetBlockStateFromTagData(configuration, world, originalPos, assumedNorth, block, foundBlock, blockState, structure);
            }
            Direction vineFacing = BuildBlock.getVineFacing(configuration, foundBlock, block, structure.getClearSpace().getShape().getDirection());
            Direction.Axis logFacing = BuildBlock.getBoneFacing(configuration, foundBlock, block, structure.getClearSpace().getShape().getDirection());
            Direction.Axis boneFacing = BuildBlock.getBoneFacing(configuration, foundBlock, block, structure.getClearSpace().getShape().getDirection());
            Direction leverOrientation = BuildBlock.getLeverOrientation(configuration, foundBlock, block, structure.getClearSpace().getShape().getDirection());
            Map<Direction, Boolean> fourWayFacings = BuildBlock.getFourWayBlockFacings(configuration, foundBlock, block, structure.getClearSpace().getShape().getDirection());
            if (block.getProperties().size() > 0) {
                Collection properties = blockState.func_235904_r_();
                for (Property property : properties) {
                    BuildProperty buildProperty = block.getProperty(property.func_177701_a());
                    if (buildProperty == null) continue;
                    try {
                        Optional propertyValue = property.func_185929_b(buildProperty.getValue());
                        if (!propertyValue.isPresent() || propertyValue.getClass().getName().equals("com.google.common.base.Absent")) {
                            Prefab.LOGGER.warn("Property value for property name [" + property.func_177701_a() + "] for block [" + block.getBlockName() + "] is considered Absent, figure out why.");
                            continue;
                        }
                        Comparable comparable = (Comparable)property.func_177699_b().cast(propertyValue.get());
                        if ((comparable = BuildBlock.setComparable(comparable, foundBlock, property, configuration, block, propertyValue, vineFacing, logFacing, boneFacing, leverOrientation, structure, fourWayFacings)) == null) continue;
                        try {
                            if (blockState.func_177229_b(property) == comparable) continue;
                            blockState = BuildBlock.setProperty(blockState, property, comparable);
                        }
                        catch (Exception ex) {
                            System.out.println("Error setting properly value for property name [" + property.func_177701_a() + "] property value [" + buildProperty.getValue() + "] for block [" + block.getBlockName() + "] The default value will be used.");
                        }
                    }
                    catch (Exception ex) {
                        System.out.println("Error getting properly value for property name [" + property.func_177701_a() + "] property value [" + buildProperty.getValue() + "] for block [" + block.getBlockName() + "]");
                        throw ex;
                    }
                }
            }
            block.setBlockState(blockState);
            return block;
        }
        catch (Exception ex) {
            System.out.println("Error setting block state for block [" + block.getBlockName() + "] for structure configuration class [" + configuration.getClass().getName() + "]");
            throw ex;
        }
    }

    public static Direction getHorizontalFacing(Direction currentFacing, Direction configurationFacing, Direction structureDirection) {
        if (currentFacing != null && currentFacing != Direction.UP && currentFacing != Direction.DOWN) {
            if (configurationFacing.func_176734_d() == structureDirection.func_176746_e()) {
                currentFacing = currentFacing.func_176746_e();
            } else if (configurationFacing.func_176734_d() == structureDirection.func_176734_d()) {
                currentFacing = currentFacing.func_176734_d();
            } else if (configurationFacing.func_176734_d() == structureDirection.func_176735_f()) {
                currentFacing = currentFacing.func_176735_f();
            }
        }
        return currentFacing;
    }

    private static Comparable setComparable(Comparable<?> comparable, Block foundBlock, Property<?> property, StructureConfiguration configuration, BuildBlock block, Optional<?> propertyValue, Direction vineFacing, Direction.Axis logFacing, Direction.Axis boneFacing, Direction leverOrientation, Structure structure, Map<Direction, Boolean> fourWayFacings) {
        if (property.func_177701_a().equals("facing") && !(foundBlock instanceof HorizontalFaceBlock)) {
            Direction facing = Direction.func_176739_a((String)propertyValue.get().toString());
            comparable = facing = BuildBlock.getHorizontalFacing(facing, configuration.houseFacing, structure.getClearSpace().getShape().getDirection());
            block.setHasFacing(true);
        } else if (property.func_177701_a().equals("facing") && foundBlock instanceof HorizontalFaceBlock) {
            comparable = leverOrientation;
            block.setHasFacing(true);
        } else if (property.func_177701_a().equals("rotation")) {
            Direction facing;
            int rotation = (Integer)propertyValue.get();
            Direction direction = rotation == 0 ? Direction.SOUTH : (rotation == 4 ? Direction.WEST : (facing = rotation == 8 ? Direction.NORTH : Direction.EAST));
            if (configuration.houseFacing.func_176734_d() == structure.getClearSpace().getShape().getDirection().func_176746_e()) {
                facing = facing.func_176746_e();
            } else if (configuration.houseFacing.func_176734_d() == structure.getClearSpace().getShape().getDirection().func_176734_d()) {
                facing = facing.func_176734_d();
            } else if (configuration.houseFacing.func_176734_d() == structure.getClearSpace().getShape().getDirection().func_176735_f()) {
                facing = facing.func_176735_f();
            }
            rotation = facing == Direction.SOUTH ? 0 : (facing == Direction.WEST ? 4 : (facing == Direction.NORTH ? 8 : 12));
            comparable = rotation;
            block.setHasFacing(true);
        } else if (foundBlock instanceof VineBlock) {
            if (property.func_177701_a().equals(vineFacing.func_176742_j())) {
                comparable = true;
                block.setHasFacing(true);
            } else {
                comparable = false;
            }
        } else if (foundBlock instanceof FourWayBlock && !property.func_177701_a().equals("waterlogged")) {
            for (Map.Entry<Direction, Boolean> entry : fourWayFacings.entrySet()) {
                if (!property.func_177701_a().equals(entry.getKey().func_176742_j())) continue;
                comparable = entry.getValue();
            }
        } else if (foundBlock instanceof WallBlock) {
            if (!property.func_177701_a().equals("variant") && (property.func_177701_a().equals(vineFacing.func_176742_j()) || property.func_177701_a().equals(vineFacing.func_176734_d().func_176742_j()))) {
                comparable = true;
                block.setHasFacing(true);
            }
        } else if (foundBlock instanceof RotatedPillarBlock && property.func_177701_a().equals("axis")) {
            comparable = boneFacing;
        }
        return comparable;
    }

    private static Direction getVineFacing(StructureConfiguration configuration, Block foundBlock, BuildBlock block, Direction assumedNorth) {
        Direction vineFacing = Direction.UP;
        if (foundBlock instanceof VineBlock || foundBlock instanceof WallBlock) {
            if (block.getProperty("east").getValue().equals("true")) {
                vineFacing = Direction.EAST;
            } else if (block.getProperty("west").getValue().equals("true")) {
                vineFacing = Direction.WEST;
            } else if (block.getProperty("south").getValue().equals("true")) {
                vineFacing = Direction.SOUTH;
            } else if (block.getProperty("north").getValue().equals("true")) {
                vineFacing = Direction.NORTH;
            }
            if (vineFacing != Direction.UP) {
                if (configuration.houseFacing.func_176746_e() == assumedNorth) {
                    vineFacing = vineFacing.func_176746_e();
                } else if (configuration.houseFacing.func_176734_d() != assumedNorth) {
                    vineFacing = configuration.houseFacing.func_176735_f() == assumedNorth ? vineFacing.func_176735_f() : vineFacing.func_176734_d();
                }
            }
        }
        return vineFacing;
    }

    private static Map<Direction, Boolean> getFourWayBlockFacings(StructureConfiguration configuration, Block foundBlock, BuildBlock block, Direction assumedNorth) {
        HashMap<Direction, Boolean> facings = new HashMap<Direction, Boolean>();
        if (foundBlock instanceof FourWayBlock) {
            boolean northValue = Boolean.parseBoolean(block.getProperty("north").getValue());
            boolean eastValue = Boolean.parseBoolean(block.getProperty("east").getValue());
            boolean westValue = Boolean.parseBoolean(block.getProperty("west").getValue());
            boolean southValue = Boolean.parseBoolean(block.getProperty("south").getValue());
            boolean originalNorth = northValue;
            boolean originalEast = eastValue;
            boolean originalWest = westValue;
            boolean originalSouth = southValue;
            if (configuration.houseFacing.func_176746_e() == assumedNorth) {
                northValue = originalWest;
                eastValue = originalNorth;
                southValue = originalEast;
                westValue = originalSouth;
            } else if (configuration.houseFacing == assumedNorth) {
                northValue = originalSouth;
                eastValue = originalWest;
                southValue = originalNorth;
                westValue = originalEast;
            } else if (configuration.houseFacing.func_176735_f() == assumedNorth) {
                northValue = originalEast;
                eastValue = originalSouth;
                southValue = originalWest;
                westValue = originalNorth;
            }
            facings.put(Direction.NORTH, northValue);
            facings.put(Direction.EAST, eastValue);
            facings.put(Direction.WEST, westValue);
            facings.put(Direction.SOUTH, southValue);
        }
        return facings;
    }

    private static Direction.Axis getBoneFacing(StructureConfiguration configuration, Block foundBlock, BuildBlock block, Direction assumedNorth) {
        BuildProperty property;
        Direction.Axis boneFacing = Direction.Axis.X;
        if (foundBlock instanceof RotatedPillarBlock && (property = block.getProperty("axis")) != null) {
            if (!property.getValue().equals("x")) {
                boneFacing = property.getValue().equals("y") ? Direction.Axis.Y : Direction.Axis.Z;
            }
            if (boneFacing != Direction.Axis.Y) {
                boneFacing = configuration.houseFacing == assumedNorth || configuration.houseFacing == assumedNorth.func_176734_d() ? boneFacing : (boneFacing == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X);
            }
        }
        return boneFacing;
    }

    private static Direction getLeverOrientation(StructureConfiguration configuration, Block foundBlock, BuildBlock block, Direction assumedNorth) {
        Direction leverOrientation = Direction.NORTH;
        AttachFace attachedTo = AttachFace.FLOOR;
        if (foundBlock instanceof HorizontalFaceBlock) {
            leverOrientation = (Direction)LeverBlock.field_185512_D.func_185929_b(block.getProperty("facing").getValue()).get();
            attachedTo = (AttachFace)LeverBlock.field_196366_M.func_185929_b(block.getProperty("face").getValue()).get();
            if (attachedTo == AttachFace.FLOOR || attachedTo == AttachFace.CEILING) {
                leverOrientation = attachedTo == AttachFace.FLOOR ? (configuration.houseFacing == assumedNorth || configuration.houseFacing == assumedNorth.func_176734_d() ? leverOrientation : (leverOrientation == Direction.NORTH ? Direction.EAST : Direction.NORTH)) : (configuration.houseFacing == assumedNorth || configuration.houseFacing == assumedNorth.func_176734_d() ? leverOrientation : (leverOrientation == Direction.NORTH ? Direction.EAST : Direction.NORTH));
            } else {
                Direction facing = leverOrientation;
                if (configuration.houseFacing.func_176746_e() == assumedNorth) {
                    facing = facing.func_176746_e();
                } else if (configuration.houseFacing.func_176734_d() != assumedNorth) {
                    facing = configuration.houseFacing.func_176735_f() == assumedNorth ? facing.func_176735_f() : facing.func_176734_d();
                }
                for (Direction tempOrientation : Direction.values()) {
                    if (tempOrientation != facing) continue;
                    leverOrientation = tempOrientation;
                    break;
                }
            }
        }
        return leverOrientation;
    }

    private static BlockState setProperty(BlockState state, Property property, Comparable comparable) {
        return (BlockState)state.func_206870_a(property, comparable);
    }

    private static BuildBlock SetBlockStateFromTagData(StructureConfiguration configuration, World world, BlockPos originalPos, Direction assumedNorth, BuildBlock block, Block foundBlock, BlockState blockState, Structure structure) {
        BlockState tagState = block.getBlockStateFromDataTag();
        if (tagState == null) {
            block.setBlockStateData("");
            return BuildBlock.SetBlockState(configuration, world, originalPos, assumedNorth, block, foundBlock, blockState, structure);
        }
        block.setBlockState(block.getBlockStateFromDataTag());
        return block;
    }

    public String getBlockDomain() {
        return this.blockDomain;
    }

    public void setBlockDomain(String value) {
        this.blockDomain = value;
    }

    public String getBlockName() {
        return this.blockName;
    }

    public void setBlockName(String value) {
        this.blockName = value;
    }

    public ResourceLocation getResourceLocation() {
        return new ResourceLocation(this.blockDomain, this.blockName);
    }

    public PositionOffset getStartingPosition() {
        return this.startingPosition;
    }

    public void setStartingPosition(PositionOffset value) {
        this.startingPosition = value;
    }

    public ArrayList<BuildProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(ArrayList<BuildProperty> value) {
        this.properties = value;
    }

    public BuildProperty getProperty(String name) {
        for (BuildProperty property : this.getProperties()) {
            if (!name.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    public BuildBlock getSubBlock() {
        return this.subBlock;
    }

    public void setSubBlock(BuildBlock value) {
        this.subBlock = value;
    }

    public boolean getHasFacing() {
        return this.hasFacing;
    }

    public void setHasFacing(boolean value) {
        this.hasFacing = value;
    }

    public BlockState getBlockState() {
        return this.state;
    }

    public void setBlockState(BlockState value) {
        this.state = value;
    }

    public String getBlockStateData() {
        return this.blockStateData;
    }

    public void setBlockStateData(String value) {
        this.blockStateData = value;
    }

    public void setBlockStateData(CompoundNBT tagCompound) {
        this.blockStateData = tagCompound.toString();
    }

    public CompoundNBT getBlockStateDataTag() {
        CompoundNBT tag = null;
        if (!this.blockStateData.equals("")) {
            try {
                tag = JsonToNBT.func_180713_a((String)this.blockStateData);
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
        }
        return tag;
    }

    public BlockState getBlockStateFromDataTag() {
        CompoundNBT tag;
        BlockState state = null;
        if (!this.blockStateData.equals("") && (tag = this.getBlockStateDataTag()) != null) {
            state = NBTUtil.func_190008_d((CompoundNBT)tag.func_74775_l("tag"));
        }
        return state;
    }

    public void Initialize() {
        this.blockDomain = "";
        this.blockName = "";
        this.properties = new ArrayList();
        this.hasFacing = false;
        this.state = null;
        this.subBlock = null;
        this.startingPosition = new PositionOffset();
        this.blockStateData = "";
    }
}

