/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.wuest.prefab.Events.ClientEventHandler;
import com.wuest.prefab.Gui.Controls.GuiCheckBox;
import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.Structures.Base.EnumStructureMaterial;
import com.wuest.prefab.Structures.Config.InstantBridgeConfiguration;
import com.wuest.prefab.Structures.Gui.GuiStructure;
import com.wuest.prefab.Structures.Messages.StructureTagMessage;
import com.wuest.prefab.Structures.Predefined.StructureInstantBridge;
import com.wuest.prefab.Structures.Render.StructureRenderHandler;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;
import net.minecraftforge.fml.client.gui.widget.Slider;

public class GuiInstantBridge
extends GuiStructure {
    private static final ResourceLocation structureTopDown = new ResourceLocation("prefab", "textures/gui/instant_bridge_top_down.png");
    protected InstantBridgeConfiguration configuration;
    private ExtendedButton btnMaterialType;
    private Slider sldrBridgeLength;
    private GuiCheckBox chckIncludeRoof;
    private Slider sldrInteriorHeight;

    public GuiInstantBridge() {
        super("Instant Bridge");
        this.structureConfiguration = StructureTagMessage.EnumStructureConfiguration.InstantBridge;
        this.modifiedInitialXAxis = 210;
        this.modifiedInitialYAxis = 83;
    }

    @Override
    protected void Initialize() {
        this.configuration = ClientEventHandler.playerConfig.getClientConfig("InstantBridge", InstantBridgeConfiguration.class);
        this.configuration.pos = this.pos;
        int grayBoxX = this.getCenteredXAxis() - 213;
        int grayBoxY = this.getCenteredYAxis() - 83;
        this.btnMaterialType = this.createAndAddButton(grayBoxX + 10, grayBoxY + 20, 90, 20, this.configuration.bridgeMaterial.getTranslatedName());
        this.sldrBridgeLength = this.createAndAddSlider(grayBoxX + 147, grayBoxY + 20, 90, 20, "", "", 25.0, 75.0, this.configuration.bridgeLength, false, true, this::buttonClicked);
        this.chckIncludeRoof = this.createAndAddCheckBox(grayBoxX + 147, grayBoxY + 55, GuiLangKeys.translateString("prefab.gui.bridge_include_roof"), this.configuration.includeRoof, this::buttonClicked);
        this.sldrInteriorHeight = this.createAndAddSlider(grayBoxX + 147, grayBoxY + 90, 90, 20, "", "", 3.0, 8.0, this.configuration.interiorHeight, false, true, this::buttonClicked);
        this.sldrInteriorHeight.field_230694_p_ = this.chckIncludeRoof.func_212942_a();
        this.btnVisualize = this.createAndAddButton(grayBoxX + 10, grayBoxY + 90, 90, 20, GuiLangKeys.translateString("prefab.gui.button.preview"));
        this.btnBuild = this.createAndAddButton(grayBoxX + 10, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.build"));
        this.btnCancel = this.createAndAddButton(grayBoxX + 147, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.cancel"));
    }

    @Override
    protected void preButtonRender(MatrixStack matrixStack, int x, int y) {
        super.preButtonRender(matrixStack, x, y);
        this.bindTexture(structureTopDown);
        GuiStructure.drawModalRectWithCustomSizedTexture(x + 250, y, 1, 165, 58, 165.0f, 58.0f);
    }

    @Override
    protected void postButtonRender(MatrixStack matrixStack, int x, int y) {
        this.drawString(matrixStack, GuiLangKeys.translateString("prefab.gui.bridge_material"), x + 10, y + 10, this.textColor);
        if (this.chckIncludeRoof.func_212942_a()) {
            this.drawString(matrixStack, GuiLangKeys.translateString("prefab.gui.bridge_interior_height"), x + 147, y + 80, this.textColor);
        }
        this.drawString(matrixStack, GuiLangKeys.translateString("prefab.gui.bridge_length"), x + 147, y + 10, this.textColor);
    }

    @Override
    public void buttonClicked(AbstractButton button) {
        int sliderValue = this.sldrBridgeLength.getValueInt();
        if (sliderValue > 75) {
            sliderValue = 75;
        } else if (sliderValue < 25) {
            sliderValue = 25;
        }
        this.configuration.bridgeLength = sliderValue;
        sliderValue = this.sldrInteriorHeight.getValueInt();
        if (sliderValue > 8) {
            sliderValue = 8;
        } else if (sliderValue < 3) {
            sliderValue = 3;
        }
        this.configuration.interiorHeight = sliderValue;
        this.configuration.includeRoof = this.chckIncludeRoof.func_212942_a();
        this.configuration.houseFacing = this.player.func_174811_aO().func_176734_d();
        this.configuration.pos = this.pos;
        this.performCancelOrBuildOrHouseFacing(this.configuration, button);
        if (button == this.chckIncludeRoof) {
            this.sldrInteriorHeight.field_230694_p_ = this.configuration.includeRoof = this.chckIncludeRoof.func_212942_a();
        }
        if (button == this.btnMaterialType) {
            this.configuration.bridgeMaterial = EnumStructureMaterial.getMaterialByNumber(this.configuration.bridgeMaterial.getNumber() + 1);
            this.btnMaterialType.func_238482_a_((ITextComponent)new StringTextComponent(this.configuration.bridgeMaterial.getTranslatedName()));
        } else if (button == this.btnVisualize) {
            StructureInstantBridge structure = new StructureInstantBridge();
            structure.getClearSpace().getShape().setDirection(Direction.SOUTH);
            structure.setupStructure(this.configuration, this.pos);
            StructureRenderHandler.setStructure(structure, Direction.SOUTH, this.configuration);
            this.func_231175_as__();
        }
    }
}

