/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.wuest.prefab.Config.ServerModConfiguration;
import com.wuest.prefab.Events.ClientEventHandler;
import com.wuest.prefab.Gui.Controls.GuiCheckBox;
import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.Gui.GuiTabScreen;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Structures.Config.ModerateHouseConfiguration;
import com.wuest.prefab.Structures.Gui.GuiStructure;
import com.wuest.prefab.Structures.Messages.StructureTagMessage;
import com.wuest.prefab.Structures.Predefined.StructureModerateHouse;
import com.wuest.prefab.Structures.Render.StructureRenderHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.item.DyeColor;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;

public class GuiModerateHouse
extends GuiStructure {
    protected ModerateHouseConfiguration configuration;
    protected ServerModConfiguration serverConfiguration;
    private ExtendedButton btnHouseStyle;
    private GuiCheckBox btnAddChest;
    private GuiCheckBox btnAddChestContents;
    private GuiCheckBox btnAddMineShaft;
    private ExtendedButton btnBedColor;
    private boolean allowItemsInChestAndFurnace = true;

    public GuiModerateHouse() {
        super("Moderate House");
        this.structureConfiguration = StructureTagMessage.EnumStructureConfiguration.ModerateHouse;
        this.modifiedInitialXAxis = 212;
        this.modifiedInitialYAxis = 83;
    }

    @Override
    protected void Initialize() {
        if (!Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
            this.allowItemsInChestAndFurnace = !ClientEventHandler.playerConfig.builtStarterHouse;
        }
        this.serverConfiguration = Prefab.proxy.getServerConfiguration();
        this.configuration = ClientEventHandler.playerConfig.getClientConfig("Moderate Houses", ModerateHouseConfiguration.class);
        this.configuration.pos = this.pos;
        int grayBoxX = this.getCenteredXAxis() - 212;
        int grayBoxY = this.getCenteredYAxis() - 83;
        this.btnHouseStyle = this.createAndAddButton(grayBoxX + 10, grayBoxY + 20, 90, 20, this.configuration.houseStyle.getDisplayName());
        this.btnVisualize = this.createAndAddButton(grayBoxX + 10, grayBoxY + 50, 90, 20, GuiLangKeys.translateString("prefab.gui.button.preview"));
        this.btnBuild = this.createAndAddButton(grayBoxX + 10, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.build"));
        this.btnCancel = this.createAndAddButton(grayBoxX + 147, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.cancel"));
        int x = grayBoxX + 130;
        int y = grayBoxY + 20;
        this.btnBedColor = this.createAndAddButton(x, y, 90, 20, GuiLangKeys.translateDye(this.configuration.bedColor));
        this.btnAddChest = this.createAndAddCheckBox(x, y += 30, GuiLangKeys.translateString("prefab.gui.starter.addchest"), this.configuration.addChests, null);
        this.btnAddMineShaft = this.createAndAddCheckBox(x, y += 15, GuiLangKeys.translateString("prefab.gui.starter.buildmineshaft"), this.configuration.addChestContents, null);
        this.btnAddChestContents = this.createAndAddCheckBox(x, y += 15, GuiLangKeys.translateString("prefab.gui.starter.addchestcontents"), this.configuration.addMineshaft, null);
    }

    @Override
    protected void preButtonRender(MatrixStack matrixStack, int x, int y) {
        super.preButtonRender(matrixStack, x, y);
        this.bindTexture(this.configuration.houseStyle.getHousePicture());
        GuiTabScreen.drawModalRectWithCustomSizedTexture(x + 249, y, 1, this.configuration.houseStyle.getImageWidth(), this.configuration.houseStyle.getImageHeight(), this.configuration.houseStyle.getImageWidth(), this.configuration.houseStyle.getImageHeight());
    }

    @Override
    protected void postButtonRender(MatrixStack matrixStack, int x, int y) {
        this.btnAddChest.field_230694_p_ = this.serverConfiguration.addChests;
        this.btnAddChestContents.field_230694_p_ = this.allowItemsInChestAndFurnace && this.serverConfiguration.addChestContents;
        this.btnAddMineShaft.field_230694_p_ = this.serverConfiguration.addMineshaft;
        this.drawString(matrixStack, GuiLangKeys.translateString("prefab.gui.starter.style.label"), x + 10, y + 10, this.textColor);
        this.drawString(matrixStack, GuiLangKeys.translateString("prefab.gui.structure.bed_color"), x + 130, y + 10, this.textColor);
    }

    @Override
    public void buttonClicked(AbstractButton button) {
        this.configuration.addChests = this.btnAddChest.field_230694_p_ && this.btnAddChest.func_212942_a();
        this.configuration.addChestContents = this.allowItemsInChestAndFurnace && this.btnAddChestContents.field_230694_p_ && this.btnAddChestContents.func_212942_a();
        this.configuration.addMineshaft = this.btnAddMineShaft.field_230694_p_ && this.btnAddMineShaft.func_212942_a();
        this.performCancelOrBuildOrHouseFacing(this.configuration, button);
        if (button == this.btnHouseStyle) {
            int id = this.configuration.houseStyle.getValue() + 1;
            this.configuration.houseStyle = ModerateHouseConfiguration.HouseStyle.ValueOf(id);
            this.btnHouseStyle.func_238482_a_((ITextComponent)new StringTextComponent(this.configuration.houseStyle.getDisplayName()));
        } else if (button == this.btnVisualize) {
            StructureModerateHouse structure = (StructureModerateHouse)StructureModerateHouse.CreateInstance(this.configuration.houseStyle.getStructureLocation(), StructureModerateHouse.class);
            StructureRenderHandler.setStructure(structure, Direction.NORTH, this.configuration);
            this.func_231175_as__();
        } else if (button == this.btnBedColor) {
            this.configuration.bedColor = DyeColor.func_196056_a((int)(this.configuration.bedColor.func_196059_a() + 1));
            this.btnBedColor.func_238482_a_((ITextComponent)new StringTextComponent(GuiLangKeys.translateDye(this.configuration.bedColor)));
        }
    }
}

