/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.wuest.prefab.Events.ClientEventHandler;
import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.Structures.Config.MonsterMasherConfiguration;
import com.wuest.prefab.Structures.Gui.GuiStructure;
import com.wuest.prefab.Structures.Messages.StructureTagMessage;
import com.wuest.prefab.Structures.Predefined.StructureMonsterMasher;
import com.wuest.prefab.Structures.Render.StructureRenderHandler;
import com.wuest.prefab.Tuple;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.item.DyeColor;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;

public class GuiMonsterMasher
extends GuiStructure {
    private static final ResourceLocation houseTopDown = new ResourceLocation("prefab", "textures/gui/monster_masher_top_down.png");
    protected MonsterMasherConfiguration configuration;
    private ExtendedButton btnGlassColor;

    public GuiMonsterMasher() {
        super("Monster Masher");
        this.structureConfiguration = StructureTagMessage.EnumStructureConfiguration.MonsterMasher;
        this.modifiedInitialXAxis = 210;
        this.modifiedInitialYAxis = 83;
    }

    @Override
    public void Initialize() {
        this.configuration = ClientEventHandler.playerConfig.getClientConfig("Monster Masher", MonsterMasherConfiguration.class);
        this.configuration.pos = this.pos;
        Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
        int grayBoxX = adjustedXYValue.getFirst();
        int grayBoxY = adjustedXYValue.getSecond();
        this.btnGlassColor = this.createAndAddButton(grayBoxX + 10, grayBoxY + 20, 90, 20, GuiLangKeys.translateDye(this.configuration.dyeColor));
        this.btnVisualize = this.createAndAddButton(grayBoxX + 10, grayBoxY + 90, 90, 20, GuiLangKeys.translateString("prefab.gui.button.preview"));
        this.btnBuild = this.createAndAddButton(grayBoxX + 10, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.build"));
        this.btnCancel = this.createAndAddButton(grayBoxX + 147, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.cancel"));
    }

    @Override
    protected void preButtonRender(MatrixStack matrixStack, int x, int y) {
        super.preButtonRender(matrixStack, x, y);
        this.bindTexture(houseTopDown);
        GuiStructure.drawModalRectWithCustomSizedTexture(x + 250, y, 1, 108, 156, 108.0f, 156.0f);
    }

    @Override
    protected void postButtonRender(MatrixStack matrixStack, int x, int y) {
        this.drawString(matrixStack, GuiLangKeys.translateString("prefab.gui.structure.glass"), x + 10, y + 10, this.textColor);
        this.drawSplitString(GuiLangKeys.translateString("prefab.gui.structure.block.clicked"), x + 147, y + 10, 100, this.textColor);
    }

    @Override
    public void buttonClicked(AbstractButton button) {
        this.performCancelOrBuildOrHouseFacing(this.configuration, button);
        if (button == this.btnGlassColor) {
            this.configuration.dyeColor = DyeColor.func_196056_a((int)(this.configuration.dyeColor.func_196059_a() + 1));
            this.btnGlassColor.func_238482_a_((ITextComponent)new StringTextComponent(GuiLangKeys.translateDye(this.configuration.dyeColor)));
        } else if (button == this.btnVisualize) {
            StructureMonsterMasher structure = (StructureMonsterMasher)StructureMonsterMasher.CreateInstance("assets/prefab/structures/monster_masher.zip", StructureMonsterMasher.class);
            StructureRenderHandler.setStructure(structure, Direction.NORTH, this.configuration);
            this.func_231175_as__();
        }
    }
}

