/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Predefined;

import com.wuest.prefab.Structures.Base.BuildBlock;
import com.wuest.prefab.Structures.Base.BuildClear;
import com.wuest.prefab.Structures.Base.BuildShape;
import com.wuest.prefab.Structures.Base.BuildingMethods;
import com.wuest.prefab.Structures.Base.PositionOffset;
import com.wuest.prefab.Structures.Base.Structure;
import com.wuest.prefab.Structures.Config.BasicStructureConfiguration;
import com.wuest.prefab.Structures.Config.StructureConfiguration;
import com.wuest.prefab.Tuple;
import java.util.ArrayList;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HopperBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class StructureBasic
extends Structure {
    private BlockPos customBlockPos = null;
    private ArrayList<Tuple<BlockPos, BlockPos>> bedPositions = new ArrayList();

    public static void ScanStructure(World world, BlockPos originalPos, Direction playerFacing, BasicStructureConfiguration configuration, boolean includeAir, boolean excludeWater) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.setShape(configuration.chosenOption.getClearShape());
        clearedSpace.setStartingPosition(configuration.chosenOption.getClearPositionOffset());
        clearedSpace.getShape().setDirection(playerFacing);
        if (!configuration.IsCustomStructure()) {
            BuildShape buildShape = configuration.chosenOption.getClearShape().Clone();
            buildShape.setWidth(buildShape.getWidth() - 1);
            buildShape.setLength(buildShape.getLength() - 1);
            PositionOffset offset = configuration.chosenOption.getClearPositionOffset();
            clearedSpace.getShape().setWidth(clearedSpace.getShape().getWidth());
            clearedSpace.getShape().setLength(clearedSpace.getShape().getLength());
            int downOffset = offset.getHeightOffset() < 0 ? Math.abs(offset.getHeightOffset()) : 0;
            BlockPos cornerPos = originalPos.func_177967_a(playerFacing.func_176735_f(), offset.getOffSetValueForFacing(playerFacing.func_176735_f())).func_177967_a(playerFacing, offset.getOffSetValueForFacing(playerFacing)).func_177979_c(downOffset);
            BlockPos otherCorner = cornerPos.func_177967_a(playerFacing, buildShape.getLength()).func_177967_a(playerFacing.func_176746_e(), buildShape.getWidth()).func_177981_b(buildShape.getHeight());
            Structure.ScanStructure(world, originalPos, cornerPos, otherCorner, "..\\src\\main\\resources\\" + configuration.chosenOption.getAssetLocation(), clearedSpace, playerFacing, includeAir, excludeWater);
        }
    }

    @Override
    protected Boolean CustomBlockProcessingHandled(StructureConfiguration configuration, BuildBlock block, World world, BlockPos originalPos, Direction assumedNorth, Block foundBlock, BlockState blockState, PlayerEntity player) {
        BasicStructureConfiguration config = (BasicStructureConfiguration)configuration;
        if (foundBlock instanceof HopperBlock && config.basicStructureName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.AdvancedCoop.getName())) {
            this.customBlockPos = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        } else if (foundBlock instanceof TrapDoorBlock && config.basicStructureName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.MineshaftEntrance.getName())) {
            this.customBlockPos = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        } else if (foundBlock instanceof BedBlock) {
            BlockPos bedHeadPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
            BlockPos bedFootPosition = block.getSubBlock().getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
            this.bedPositions.add(new Tuple<BlockPos, BlockPos>(bedHeadPosition, bedFootPosition));
            return true;
        }
        return false;
    }

    @Override
    protected Boolean BlockShouldBeClearedDuringConstruction(StructureConfiguration configuration, World world, BlockPos originalPos, Direction assumedNorth, BlockPos blockPos) {
        BasicStructureConfiguration config = (BasicStructureConfiguration)configuration;
        if (config.basicStructureName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.AquaBase.getName())) {
            BlockState blockState = world.func_180495_p(blockPos);
            return blockState.func_185904_a() != Material.field_151586_h;
        }
        return true;
    }

    @Override
    public void AfterBuilding(StructureConfiguration configuration, ServerWorld world, BlockPos originalPos, Direction assumedNorth, PlayerEntity player) {
        BasicStructureConfiguration config = (BasicStructureConfiguration)configuration;
        if (this.customBlockPos != null) {
            if (config.basicStructureName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.AdvancedCoop.getName())) {
                for (int i = 0; i < 4; ++i) {
                    ChickenEntity entity = new ChickenEntity(EntityType.field_200795_i, (World)world);
                    entity.func_70107_b((double)this.customBlockPos.func_177958_n(), (double)this.customBlockPos.func_177984_a().func_177956_o(), (double)this.customBlockPos.func_177952_p());
                    world.func_217376_c((Entity)entity);
                }
            } else if (config.basicStructureName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.MineshaftEntrance.getName())) {
                BuildingMethods.PlaceMineShaft(world, this.customBlockPos.func_177977_b(), configuration.houseFacing, true);
            }
            this.customBlockPos = null;
        }
        if (this.bedPositions.size() > 0) {
            for (Tuple<BlockPos, BlockPos> bedPosition : this.bedPositions) {
                BuildingMethods.PlaceColoredBed((World)world, bedPosition.getFirst(), bedPosition.getSecond(), config.bedColor);
            }
        }
        if (config.basicStructureName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.AquaBase.getName())) {
            BlockPos airPos = originalPos.func_177981_b(4).func_177967_a(configuration.houseFacing.func_176734_d(), 1);
            world.func_217377_a(airPos.func_177972_a(configuration.houseFacing.func_176746_e()), false);
            world.func_217377_a(airPos, false);
            world.func_217377_a(airPos.func_177972_a(configuration.houseFacing.func_176735_f()), false);
            airPos = airPos.func_177977_b();
            world.func_217377_a(airPos.func_177972_a(configuration.houseFacing.func_176746_e()), false);
            world.func_217377_a(airPos, false);
            world.func_217377_a(airPos.func_177972_a(configuration.houseFacing.func_176735_f()), false);
            airPos = airPos.func_177977_b();
            world.func_217377_a(airPos.func_177972_a(configuration.houseFacing.func_176746_e()), false);
            world.func_217377_a(airPos, false);
            world.func_217377_a(airPos.func_177972_a(configuration.houseFacing.func_176735_f()), false);
            airPos = airPos.func_177977_b();
            world.func_217377_a(airPos.func_177972_a(configuration.houseFacing.func_176746_e()), false);
            world.func_217377_a(airPos, false);
            world.func_217377_a(airPos.func_177972_a(configuration.houseFacing.func_176735_f()), false);
            airPos = airPos.func_177972_a(configuration.houseFacing.func_176734_d()).func_177984_a();
            world.func_217377_a(airPos.func_177972_a(configuration.houseFacing.func_176746_e()), false);
            world.func_217377_a(airPos, false);
            world.func_217377_a(airPos.func_177972_a(configuration.houseFacing.func_176735_f()), false);
            airPos = airPos.func_177984_a();
            world.func_217377_a(airPos.func_177972_a(configuration.houseFacing.func_176746_e()), false);
            world.func_217377_a(airPos, false);
            world.func_217377_a(airPos.func_177972_a(configuration.houseFacing.func_176735_f()), false);
            airPos = airPos.func_177984_a();
            world.func_217377_a(airPos, false);
        }
    }
}

