/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Predefined;

import com.wuest.prefab.Config.EntityPlayerConfiguration;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Proxy.Messages.PlayerEntityTagMessage;
import com.wuest.prefab.Structures.Base.BuildBlock;
import com.wuest.prefab.Structures.Base.BuildClear;
import com.wuest.prefab.Structures.Base.BuildingMethods;
import com.wuest.prefab.Structures.Base.Structure;
import com.wuest.prefab.Structures.Config.ModerateHouseConfiguration;
import com.wuest.prefab.Structures.Config.StructureConfiguration;
import com.wuest.prefab.Tuple;
import java.util.ArrayList;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.FurnaceBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;

public class StructureModerateHouse
extends Structure {
    private BlockPos chestPosition = null;
    private ArrayList<BlockPos> furnacePosition = null;
    private BlockPos trapDoorPosition = null;
    private ArrayList<Tuple<BlockPos, BlockPos>> bedPositions = new ArrayList();

    public static void ScanStructure(World world, BlockPos originalPos, Direction playerFacing, ModerateHouseConfiguration.HouseStyle houseStyle) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(playerFacing);
        clearedSpace.getShape().setHeight(houseStyle.getHeight());
        clearedSpace.getShape().setLength(houseStyle.getLength() + 1);
        clearedSpace.getShape().setWidth(houseStyle.getWidth());
        clearedSpace.getStartingPosition().setHorizontalOffset(playerFacing, 1);
        clearedSpace.getStartingPosition().setHorizontalOffset(playerFacing.func_176735_f(), houseStyle.getEastOffSet());
        clearedSpace.getStartingPosition().setHeightOffset(houseStyle.getDownOffSet() * -1);
        BlockPos cornerPos = originalPos.func_177967_a(playerFacing.func_176735_f(), houseStyle.getEastOffSet()).func_177972_a(playerFacing).func_177979_c(houseStyle.getDownOffSet());
        Structure.ScanStructure(world, originalPos, cornerPos, cornerPos.func_177967_a(playerFacing, houseStyle.getLength()).func_177967_a(playerFacing.func_176746_e(), houseStyle.getWidth()).func_177981_b(houseStyle.getHeight()), "../src/main/resources/" + houseStyle.getStructureLocation(), clearedSpace, playerFacing, false, false);
    }

    @Override
    protected Boolean CustomBlockProcessingHandled(StructureConfiguration configuration, BuildBlock block, World world, BlockPos originalPos, Direction assumedNorth, Block foundBlock, BlockState blockState, PlayerEntity player) {
        ModerateHouseConfiguration houseConfiguration = (ModerateHouseConfiguration)configuration;
        if (foundBlock instanceof FurnaceBlock) {
            if (this.furnacePosition == null) {
                this.furnacePosition = new ArrayList();
            }
            this.furnacePosition.add(block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing));
        } else {
            if (foundBlock instanceof ChestBlock && !houseConfiguration.addChests) {
                return true;
            }
            if (foundBlock instanceof ChestBlock && this.chestPosition == null) {
                this.chestPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
            } else if (foundBlock instanceof TrapDoorBlock && this.trapDoorPosition == null) {
                this.trapDoorPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
            } else if (foundBlock == Blocks.field_150360_v) {
                this.trapDoorPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing).func_177984_a();
            } else if (foundBlock instanceof BedBlock) {
                BlockPos bedHeadPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
                BlockPos bedFootPosition = block.getSubBlock().getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
                this.bedPositions.add(new Tuple<BlockPos, BlockPos>(bedHeadPosition, bedFootPosition));
                return true;
            }
        }
        return false;
    }

    @Override
    public void AfterBuilding(StructureConfiguration configuration, ServerWorld world, BlockPos originalPos, Direction assumedNorth, PlayerEntity player) {
        ModerateHouseConfiguration houseConfig = (ModerateHouseConfiguration)configuration;
        EntityPlayerConfiguration playerConfig = EntityPlayerConfiguration.loadFromEntityData(player);
        BuildingMethods.FillFurnaces((World)world, this.furnacePosition);
        if (this.chestPosition != null && !playerConfig.builtStarterHouse && houseConfig.addChestContents) {
            BuildingMethods.FillChest((World)world, this.chestPosition);
        }
        if (this.trapDoorPosition != null && this.trapDoorPosition.func_177956_o() > 15 && houseConfig.addMineshaft) {
            BuildingMethods.PlaceMineShaft(world, this.trapDoorPosition.func_177977_b(), houseConfig.houseFacing, false);
        }
        if (this.bedPositions.size() > 0) {
            for (Tuple<BlockPos, BlockPos> bedPosition : this.bedPositions) {
                BuildingMethods.PlaceColoredBed((World)world, bedPosition.getFirst(), bedPosition.getSecond(), houseConfig.bedColor);
            }
        }
        playerConfig.builtStarterHouse = true;
        playerConfig.saveToPlayer(player);
        Prefab.network.sendTo((Object)new PlayerEntityTagMessage(playerConfig.getModIsPlayerNewTag(player)), ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
    }
}

