/*
 * Decompiled with CFR 0.152.
 */
package dev.nero.quicksearchmod;

import dev.nero.quicksearchmod.utils.RenderUtils;
import dev.nero.quicksearchmod.utils.SlotPos;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ChestScreen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.CraftingScreen;
import net.minecraft.client.gui.screen.inventory.HorseInventoryScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.screen.inventory.ShulkerBoxScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.SharedConstants;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="quicksearchmod")
public class QuickSearchMod {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean isSearching = false;
    private String searchText = "";
    private ArrayList<SlotPos> highlightedSlots = new ArrayList();
    private boolean cancelFirstLetter = false;
    public KeyBinding focusKeybinding = new KeyBinding("key.quicksearchmod.focus", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.CONTROL, InputMappings.Type.KEYSYM, 70, "keys.category.quicksearchmod");

    public QuickSearchMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.addListener(this::onKeyTypedEventPost);
        MinecraftForge.EVENT_BUS.addListener(this::onKeyPressedEventPre);
        MinecraftForge.EVENT_BUS.addListener(this::onDrawForegroundEvent);
        MinecraftForge.EVENT_BUS.addListener(this::onClientTickEvent);
    }

    private void setup(FMLClientSetupEvent event) {
        LOGGER.info("Registering focus key");
        ClientRegistry.registerKeyBinding((KeyBinding)this.focusKeybinding);
    }

    private void onKeyTypedEventPost(GuiScreenEvent.KeyboardCharTypedEvent.Post event) {
        if (this.isSearching && this.searchText.length() < 25) {
            if (SharedConstants.func_71566_a((char)event.getCodePoint()) && !this.cancelFirstLetter) {
                this.searchText = this.searchText + Character.toString(event.getCodePoint());
                this.updateHighlightedSlots();
            } else if (this.cancelFirstLetter) {
                this.cancelFirstLetter = false;
            }
        }
    }

    private void onKeyPressedEventPre(GuiScreenEvent.KeyboardKeyPressedEvent.Pre event) {
        if (this.isSearching && this.searchText.length() > 0) {
            boolean cancelEvent = true;
            if (event.getKeyCode() == 259) {
                this.searchText = this.searchText.substring(0, this.searchText.length() - 1);
                this.updateHighlightedSlots();
                cancelEvent = false;
            } else if (event.getKeyCode() == 256) {
                this.isSearching = false;
            }
            event.setCanceled(cancelEvent);
        } else if (!this.isSearching && this.keyBindingPressed(this.focusKeybinding, (GuiScreenEvent.KeyboardKeyPressedEvent)event)) {
            if (this.focusKeybinding.getKeyModifier() == KeyModifier.NONE) {
                this.cancelFirstLetter = true;
            }
            this.isSearching = true;
        }
    }

    private void onDrawForegroundEvent(GuiContainerEvent.DrawForeground event) {
        if (this.isSearchableContainer(event.getGuiContainer())) {
            String string = this.isSearching ? "Search: " + this.searchText + "_" : "Search disabled (" + this.keybindToString(this.focusKeybinding) + ")";
            Minecraft.func_71410_x().field_71466_p.getClass();
            RenderUtils.renderText(string, 0, -9 - 5, this.isSearching ? 0xFFFFFF : 0x888888);
            for (SlotPos slotPos : this.highlightedSlots) {
                RenderUtils.highlightSlot(slotPos, 1999613952);
            }
        }
    }

    private void onClientTickEvent(TickEvent.ClientTickEvent event) {
        if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71462_r == null && this.isSearching) {
            this.isSearching = false;
            this.highlightedSlots = new ArrayList();
        }
    }

    private String keybindToString(KeyBinding keyBinding) {
        return keyBinding.func_238171_j_().getString();
    }

    private boolean keyBindingPressed(KeyBinding keyBinding, GuiScreenEvent.KeyboardKeyPressedEvent event) {
        int modifierEvent = event.getModifiers();
        int modifierKeybind = keyBinding.getKeyModifier().ordinal();
        boolean sameModifiers = modifierEvent == 1 && modifierKeybind == 1 || modifierEvent == 2 && modifierKeybind == 0 || modifierEvent == 4 && modifierKeybind == 2 || modifierEvent == 0 && modifierKeybind == 3;
        return sameModifiers && keyBinding.getKey().func_197937_c() == event.getKeyCode();
    }

    private void updateHighlightedSlots() {
        this.highlightedSlots.clear();
        if (this.searchText.length() > 0) {
            for (Slot slot : Minecraft.func_71410_x().field_71439_g.field_71070_bA.field_75151_b) {
                String name = slot.func_75211_c().func_77973_b().func_200296_o().getString().toLowerCase();
                if (!name.startsWith(this.searchText.toLowerCase()) && !name.contains(this.searchText.toLowerCase())) continue;
                this.highlightedSlots.add(new SlotPos(slot));
            }
        }
    }

    private boolean isSearchableContainer(ContainerScreen container) {
        return container instanceof InventoryScreen || container instanceof ChestScreen || container instanceof ShulkerBoxScreen || container instanceof HorseInventoryScreen || container instanceof CraftingScreen;
    }
}

