/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.client.event.ClientEvents;
import com.github.alexthe666.rats.client.gui.GuiCheeseStaff;
import com.github.alexthe666.rats.client.gui.GuiRadiusStaff;
import com.github.alexthe666.rats.client.gui.GuiRat;
import com.github.alexthe666.rats.client.gui.RatsGuiRegistry;
import com.github.alexthe666.rats.client.model.ModelArcheologistHat;
import com.github.alexthe666.rats.client.model.ModelChefToque;
import com.github.alexthe666.rats.client.model.ModelFarmerHat;
import com.github.alexthe666.rats.client.model.ModelGhostPiratHat;
import com.github.alexthe666.rats.client.model.ModelHaloHat;
import com.github.alexthe666.rats.client.model.ModelPartyHat;
import com.github.alexthe666.rats.client.model.ModelPiperHat;
import com.github.alexthe666.rats.client.model.ModelPiratHat;
import com.github.alexthe666.rats.client.model.ModelPlagueDoctorMask;
import com.github.alexthe666.rats.client.model.ModelRatFez;
import com.github.alexthe666.rats.client.model.ModelSantaHat;
import com.github.alexthe666.rats.client.model.ModelTopHat;
import com.github.alexthe666.rats.client.particle.ParticleBlackDeath;
import com.github.alexthe666.rats.client.particle.ParticleFlea;
import com.github.alexthe666.rats.client.particle.ParticleLightning;
import com.github.alexthe666.rats.client.particle.ParticlePiratGhost;
import com.github.alexthe666.rats.client.particle.ParticleRatGhost;
import com.github.alexthe666.rats.client.particle.ParticleSaliva;
import com.github.alexthe666.rats.client.particle.ParticleUpgradeCombiner;
import com.github.alexthe666.rats.client.render.NuggetColorRegister;
import com.github.alexthe666.rats.client.render.RenderNothing;
import com.github.alexthe666.rats.client.render.entity.LayerPlague;
import com.github.alexthe666.rats.client.render.entity.RenderBlackDeath;
import com.github.alexthe666.rats.client.render.entity.RenderDutchrat;
import com.github.alexthe666.rats.client.render.entity.RenderDutchratSword;
import com.github.alexthe666.rats.client.render.entity.RenderFeralRatlantean;
import com.github.alexthe666.rats.client.render.entity.RenderGhostPirat;
import com.github.alexthe666.rats.client.render.entity.RenderGolemBeam;
import com.github.alexthe666.rats.client.render.entity.RenderIllagerPiper;
import com.github.alexthe666.rats.client.render.entity.RenderLaserBeam;
import com.github.alexthe666.rats.client.render.entity.RenderLaserPortal;
import com.github.alexthe666.rats.client.render.entity.RenderMarbledCheeseGolem;
import com.github.alexthe666.rats.client.render.entity.RenderNeoRatlantean;
import com.github.alexthe666.rats.client.render.entity.RenderPirat;
import com.github.alexthe666.rats.client.render.entity.RenderPiratBoat;
import com.github.alexthe666.rats.client.render.entity.RenderPlagueBeast;
import com.github.alexthe666.rats.client.render.entity.RenderPlagueDoctor;
import com.github.alexthe666.rats.client.render.entity.RenderPlagueShot;
import com.github.alexthe666.rats.client.render.entity.RenderRat;
import com.github.alexthe666.rats.client.render.entity.RenderRatArrow;
import com.github.alexthe666.rats.client.render.entity.RenderRatAutomatonMount;
import com.github.alexthe666.rats.client.render.entity.RenderRatBeastMount;
import com.github.alexthe666.rats.client.render.entity.RenderRatChickenMount;
import com.github.alexthe666.rats.client.render.entity.RenderRatGolemMount;
import com.github.alexthe666.rats.client.render.entity.RenderRatfish;
import com.github.alexthe666.rats.client.render.entity.RenderRatlanteanFlame;
import com.github.alexthe666.rats.client.render.entity.RenderRatlanteanRatbot;
import com.github.alexthe666.rats.client.render.entity.RenderRatlateanSpirit;
import com.github.alexthe666.rats.client.render.entity.RenderRattlingGun;
import com.github.alexthe666.rats.client.render.entity.RenderRattlingGunBullet;
import com.github.alexthe666.rats.client.render.entity.RenderThrownBlock;
import com.github.alexthe666.rats.client.render.tile.RatsTEISR;
import com.github.alexthe666.rats.client.render.tile.RenderAutoCurdler;
import com.github.alexthe666.rats.client.render.tile.RenderDutchratBell;
import com.github.alexthe666.rats.client.render.tile.RenderRatCageDecorated;
import com.github.alexthe666.rats.client.render.tile.RenderRatHole;
import com.github.alexthe666.rats.client.render.tile.RenderRatTrap;
import com.github.alexthe666.rats.client.render.tile.RenderRatlanteanAutomatonHead;
import com.github.alexthe666.rats.client.render.tile.RenderRatlantisPortal;
import com.github.alexthe666.rats.client.render.tile.RenderUpgradeCombiner;
import com.github.alexthe666.rats.client.render.tile.RenderUpgradeSeparator;
import com.github.alexthe666.rats.server.CommonProxy;
import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.github.alexthe666.rats.server.entity.EntityBlackDeath;
import com.github.alexthe666.rats.server.entity.EntityCheeseCannonball;
import com.github.alexthe666.rats.server.entity.EntityDutchrat;
import com.github.alexthe666.rats.server.entity.EntityDutchratSword;
import com.github.alexthe666.rats.server.entity.EntityFeralRatlantean;
import com.github.alexthe666.rats.server.entity.EntityGhostPirat;
import com.github.alexthe666.rats.server.entity.EntityGolemBeam;
import com.github.alexthe666.rats.server.entity.EntityIllagerPiper;
import com.github.alexthe666.rats.server.entity.EntityLaserBeam;
import com.github.alexthe666.rats.server.entity.EntityLaserPortal;
import com.github.alexthe666.rats.server.entity.EntityMarbleCheeseGolem;
import com.github.alexthe666.rats.server.entity.EntityNeoRatlantean;
import com.github.alexthe666.rats.server.entity.EntityPirat;
import com.github.alexthe666.rats.server.entity.EntityPiratBoat;
import com.github.alexthe666.rats.server.entity.EntityPlagueBeast;
import com.github.alexthe666.rats.server.entity.EntityPlagueCloud;
import com.github.alexthe666.rats.server.entity.EntityPlagueDoctor;
import com.github.alexthe666.rats.server.entity.EntityPlagueShot;
import com.github.alexthe666.rats.server.entity.EntityPurifyingLiquid;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.EntityRatArrow;
import com.github.alexthe666.rats.server.entity.EntityRatAutomatonMount;
import com.github.alexthe666.rats.server.entity.EntityRatBeastMount;
import com.github.alexthe666.rats.server.entity.EntityRatCaptureNet;
import com.github.alexthe666.rats.server.entity.EntityRatChickenMount;
import com.github.alexthe666.rats.server.entity.EntityRatDragonFire;
import com.github.alexthe666.rats.server.entity.EntityRatGolemMount;
import com.github.alexthe666.rats.server.entity.EntityRatfish;
import com.github.alexthe666.rats.server.entity.EntityRatlanteanFlame;
import com.github.alexthe666.rats.server.entity.EntityRatlanteanRatbot;
import com.github.alexthe666.rats.server.entity.EntityRatlanteanSpirit;
import com.github.alexthe666.rats.server.entity.EntityRattlingGun;
import com.github.alexthe666.rats.server.entity.EntityRattlingGunBullet;
import com.github.alexthe666.rats.server.entity.EntityThrownBlock;
import com.github.alexthe666.rats.server.entity.EntityVialOfSentience;
import com.github.alexthe666.rats.server.entity.tile.TileEntityAutoCurdler;
import com.github.alexthe666.rats.server.entity.tile.TileEntityDutchratBell;
import com.github.alexthe666.rats.server.entity.tile.TileEntityRatCageBreedingLantern;
import com.github.alexthe666.rats.server.entity.tile.TileEntityRatCageDecorated;
import com.github.alexthe666.rats.server.entity.tile.TileEntityRatHole;
import com.github.alexthe666.rats.server.entity.tile.TileEntityRatTrap;
import com.github.alexthe666.rats.server.entity.tile.TileEntityRatTube;
import com.github.alexthe666.rats.server.entity.tile.TileEntityRatlanteanAutomatonHead;
import com.github.alexthe666.rats.server.entity.tile.TileEntityRatlantisPortal;
import com.github.alexthe666.rats.server.entity.tile.TileEntityUpgradeCombiner;
import com.github.alexthe666.rats.server.entity.tile.TileEntityUpgradeSeparator;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.Callable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.SpriteRenderer;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GrassColors;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="rats", value={Dist.CLIENT})
public class ClientProxy
extends CommonProxy {
    @OnlyIn(value=Dist.CLIENT)
    private static final RatsTEISR TEISR = new RatsTEISR();
    @OnlyIn(value=Dist.CLIENT)
    private static final ModelChefToque MODEL_CHEF_TOQUE = new ModelChefToque(1.0f);
    public static BlockPos refrencedPos;
    public static Direction refrencedFacing;
    public static EntityRat refrencedRat;
    public static TileEntity refrencedTileEntity;
    public static ItemStack refrencedItem;

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void registerModels(ModelRegistryEvent event) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void preInit() {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void init() {
        RatsGuiRegistry.register();
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientProxy::onBlockColors);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientProxy::onItemColors);
        RenderingRegistry.registerEntityRenderingHandler(EntityRat.class, manager -> new RenderRat());
        RenderingRegistry.registerEntityRenderingHandler(EntityIllagerPiper.class, manager -> new RenderIllagerPiper());
        RenderingRegistry.registerEntityRenderingHandler(EntityRatlanteanSpirit.class, manager -> new RenderRatlateanSpirit());
        RenderingRegistry.registerEntityRenderingHandler(EntityRatlanteanFlame.class, manager -> new RenderRatlanteanFlame());
        RenderingRegistry.registerEntityRenderingHandler(EntityMarbleCheeseGolem.class, manager -> new RenderMarbledCheeseGolem());
        RenderingRegistry.registerEntityRenderingHandler(EntityGolemBeam.class, manager -> new RenderGolemBeam());
        RenderingRegistry.registerEntityRenderingHandler(EntityFeralRatlantean.class, manager -> new RenderFeralRatlantean());
        RenderingRegistry.registerEntityRenderingHandler(EntityNeoRatlantean.class, manager -> new RenderNeoRatlantean());
        RenderingRegistry.registerEntityRenderingHandler(EntityLaserBeam.class, manager -> new RenderLaserBeam());
        RenderingRegistry.registerEntityRenderingHandler(EntityLaserPortal.class, manager -> new RenderLaserPortal());
        RenderingRegistry.registerEntityRenderingHandler(EntityThrownBlock.class, manager -> new RenderThrownBlock());
        RenderingRegistry.registerEntityRenderingHandler(EntityVialOfSentience.class, manager -> new SpriteRenderer(Minecraft.func_71410_x().func_175598_ae(), Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityPiratBoat.class, manager -> new RenderPiratBoat());
        RenderingRegistry.registerEntityRenderingHandler(EntityCheeseCannonball.class, manager -> new SpriteRenderer(Minecraft.func_71410_x().func_175598_ae(), Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityPirat.class, manager -> new RenderPirat());
        RenderingRegistry.registerEntityRenderingHandler(EntityPlagueDoctor.class, manager -> new RenderPlagueDoctor());
        RenderingRegistry.registerEntityRenderingHandler(EntityPurifyingLiquid.class, manager -> new SpriteRenderer(Minecraft.func_71410_x().func_175598_ae(), Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityBlackDeath.class, manager -> new RenderBlackDeath());
        RenderingRegistry.registerEntityRenderingHandler(EntityPlagueCloud.class, manager -> new RenderRatlateanSpirit());
        RenderingRegistry.registerEntityRenderingHandler(EntityPlagueBeast.class, manager -> new RenderPlagueBeast());
        RenderingRegistry.registerEntityRenderingHandler(EntityPlagueShot.class, manager -> new RenderPlagueShot());
        RenderingRegistry.registerEntityRenderingHandler(EntityRatCaptureNet.class, manager -> new SpriteRenderer(Minecraft.func_71410_x().func_175598_ae(), Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityRatDragonFire.class, manager -> new RenderNothing());
        RenderingRegistry.registerEntityRenderingHandler(EntityRatArrow.class, manager -> new RenderRatArrow());
        RenderingRegistry.registerEntityRenderingHandler(EntityGhostPirat.class, manager -> new RenderGhostPirat());
        RenderingRegistry.registerEntityRenderingHandler(EntityDutchrat.class, manager -> new RenderDutchrat());
        RenderingRegistry.registerEntityRenderingHandler(EntityDutchratSword.class, manager -> new RenderDutchratSword());
        RenderingRegistry.registerEntityRenderingHandler(EntityRatfish.class, manager -> new RenderRatfish());
        RenderingRegistry.registerEntityRenderingHandler(EntityRattlingGun.class, manager -> new RenderRattlingGun());
        RenderingRegistry.registerEntityRenderingHandler(EntityRattlingGunBullet.class, manager -> new RenderRattlingGunBullet());
        RenderingRegistry.registerEntityRenderingHandler(EntityRatlanteanRatbot.class, manager -> new RenderRatlanteanRatbot());
        RenderingRegistry.registerEntityRenderingHandler(EntityRatGolemMount.class, manager -> new RenderRatGolemMount());
        RenderingRegistry.registerEntityRenderingHandler(EntityRatChickenMount.class, manager -> new RenderRatChickenMount());
        RenderingRegistry.registerEntityRenderingHandler(EntityRatBeastMount.class, manager -> new RenderRatBeastMount());
        RenderingRegistry.registerEntityRenderingHandler(EntityRatAutomatonMount.class, manager -> new RenderRatAutomatonMount());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityRatHole.class, (TileEntityRenderer)new RenderRatHole());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityRatTrap.class, (TileEntityRenderer)new RenderRatTrap());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityAutoCurdler.class, (TileEntityRenderer)new RenderAutoCurdler());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityRatlantisPortal.class, (TileEntityRenderer)new RenderRatlantisPortal());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityRatCageDecorated.class, (TileEntityRenderer)new RenderRatCageDecorated());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityRatCageBreedingLantern.class, (TileEntityRenderer)new RenderRatCageDecorated());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityUpgradeCombiner.class, (TileEntityRenderer)new RenderUpgradeCombiner());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityUpgradeSeparator.class, (TileEntityRenderer)new RenderUpgradeSeparator());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDutchratBell.class, (TileEntityRenderer)new RenderDutchratBell());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityRatlanteanAutomatonHead.class, (TileEntityRenderer)new RenderRatlanteanAutomatonHead());
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onBlockColors(ColorHandlerEvent.Block event) {
        RatsMod.LOGGER.info("loaded in block colorizer");
        event.getBlockColors().func_186722_a((state, worldIn, pos, colorIn) -> {
            int meta = 0;
            if (worldIn.func_175625_s(pos) instanceof TileEntityRatTube) {
                TileEntityRatTube tube = (TileEntityRatTube)worldIn.func_175625_s(pos);
                meta = tube.getColor();
            }
            DyeColor color = DyeColor.func_196056_a((int)meta);
            return color.func_196060_f();
        }, new Block[]{RatsBlockRegistry.RAT_TUBE_COLOR});
        event.getBlockColors().func_186722_a((state, worldIn, pos, colorIn) -> worldIn != null && pos != null ? BiomeColors.func_217615_b((IEnviromentBlockReader)worldIn, (BlockPos)pos) : GrassColors.func_77480_a((double)0.5, (double)1.0), new Block[]{RatsBlockRegistry.MARBLED_CHEESE_GRASS});
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onItemColors(ColorHandlerEvent.Item event) {
        RatsMod.LOGGER.info("loaded in item colorizer");
        event.getItemColors().func_199877_a((p_getColor_1_, p_getColor_2_) -> GrassColors.func_77480_a((double)0.5, (double)1.0), new IItemProvider[]{Item.func_150898_a((Block)RatsBlockRegistry.MARBLED_CHEESE_GRASS)});
        event.getItemColors().func_199877_a((p_getColor_1_, p_getColor_2_) -> {
            int meta = 0;
            for (int i = 0; i < RatsItemRegistry.RAT_TUBES.length; ++i) {
                if (p_getColor_1_.func_77973_b() != RatsItemRegistry.RAT_TUBES[i]) continue;
                meta = i;
                break;
            }
            DyeColor color = DyeColor.func_196056_a((int)meta);
            return color.func_196060_f();
        }, (IItemProvider[])RatsItemRegistry.RAT_TUBES);
        event.getItemColors().func_199877_a((p_getColor_1_, p_getColor_2_) -> {
            int meta = 0;
            for (int i = 0; i < RatsItemRegistry.RAT_IGLOOS.length; ++i) {
                if (p_getColor_1_.func_77973_b() != RatsItemRegistry.RAT_IGLOOS[i]) continue;
                meta = i;
            }
            DyeColor color = DyeColor.func_196056_a((int)meta);
            return color.func_196060_f();
        }, (IItemProvider[])RatsItemRegistry.RAT_IGLOOS);
        event.getItemColors().func_199877_a((p_getColor_1_, p_getColor_2_) -> {
            if (p_getColor_2_ == 0) {
                int meta = 0;
                for (int i = 0; i < RatsItemRegistry.RAT_HAMMOCKS.length; ++i) {
                    if (p_getColor_1_.func_77973_b() != RatsItemRegistry.RAT_HAMMOCKS[i]) continue;
                    meta = i;
                }
                DyeColor color = DyeColor.func_196056_a((int)meta);
                return color.func_196060_f();
            }
            return -1;
        }, (IItemProvider[])RatsItemRegistry.RAT_HAMMOCKS);
        event.getItemColors().func_199877_a((p_getColor_1_, p_getColor_2_) -> {
            if (p_getColor_2_ == 1) {
                return NuggetColorRegister.getNuggetColor(p_getColor_1_);
            }
            return -1;
        }, new IItemProvider[]{RatsItemRegistry.RAT_NUGGET_ORE});
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void postInit() {
        EntityRenderer render;
        for (Map.Entry entry : Minecraft.func_71410_x().func_175598_ae().field_78729_o.entrySet()) {
            render = (EntityRenderer)entry.getValue();
            if (!(render instanceof LivingRenderer) || !LivingEntity.class.isAssignableFrom((Class)entry.getKey())) continue;
            ((LivingRenderer)render).func_177094_a(new LayerPlague((LivingRenderer)render));
        }
        for (Map.Entry entry : Minecraft.func_71410_x().func_175598_ae().getSkinMap().entrySet()) {
            render = (PlayerRenderer)entry.getValue();
            render.func_177094_a(new LayerPlague(render));
        }
        Field renderingRegistryField = ObfuscationReflectionHelper.findField(RenderingRegistry.class, (String)"INSTANCE");
        Field entityRendersField = ObfuscationReflectionHelper.findField(RenderingRegistry.class, (String)"entityRenderers");
        RenderingRegistry registry = null;
        try {
            Field modifier = Field.class.getDeclaredField("modifiers");
            modifier.setAccessible(true);
            registry = (RenderingRegistry)renderingRegistryField.get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (registry != null) {
            Map entityRenders = null;
            try {
                Field modifier1 = Field.class.getDeclaredField("modifiers");
                modifier1.setAccessible(true);
                entityRenders = (Map)entityRendersField.get(registry);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (entityRenders != null) {
                for (Map.Entry entry : entityRenders.entrySet()) {
                    if (entry.getValue() == null) continue;
                    try {
                        EntityRenderer render2 = ((IRenderFactory)entry.getValue()).createRenderFor(Minecraft.func_71410_x().func_175598_ae());
                        if (render2 == null || !(render2 instanceof LivingRenderer) || !LivingEntity.class.isAssignableFrom((Class)entry.getKey())) continue;
                        ((LivingRenderer)render2).func_177094_a(new LayerPlague((LivingRenderer)render2));
                    }
                    catch (NullPointerException exp) {
                        RatsMod.LOGGER.warn("Rats: Could not apply plague render layer to " + ((Class)entry.getKey()).getSimpleName() + ", someone isn't registering their renderer properly... <.<");
                    }
                }
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderNameplates() {
        return Minecraft.func_71410_x().field_71462_r == null || !(Minecraft.func_71410_x().field_71462_r instanceof GuiRat) && !(Minecraft.func_71410_x().field_71462_r instanceof GuiCheeseStaff);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Object getArmorModel(int index) {
        if (index == 0) {
            return new ModelChefToque(1.0f);
        }
        if (index == 1) {
            return new ModelPiperHat(1.0f);
        }
        if (index == 2) {
            return new ModelPiratHat(1.0f);
        }
        if (index == 3) {
            return new ModelArcheologistHat(1.0f);
        }
        if (index == 4) {
            return new ModelFarmerHat(1.0f);
        }
        if (index == 5) {
            return new ModelPlagueDoctorMask(1.0f);
        }
        if (index == 6) {
            return new ModelRatFez(1.0f);
        }
        if (index == 7) {
            return new ModelTopHat(1.0f);
        }
        if (index == 8) {
            return new ModelSantaHat(1.0f);
        }
        if (index == 9) {
            return new ModelGhostPiratHat(1.0f);
        }
        if (index == 10) {
            return new ModelHaloHat(0.5f);
        }
        return new ModelPartyHat(1.0f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void openCheeseStaffGui() {
        if (refrencedRat != null) {
            Minecraft.func_71410_x().func_147108_a((Screen)new GuiCheeseStaff(refrencedRat));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public EntityRat getRefrencedRat() {
        return refrencedRat;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setRefrencedRat(EntityRat rat) {
        refrencedRat = rat;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setCheeseStaffContext(BlockPos pos, Direction facing) {
        refrencedPos = pos;
        refrencedFacing = facing;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addParticle(String name, double x, double y, double z, double motX, double motY, double motZ) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        if (name.equals("rat_ghost")) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleRatGhost((World)world, x, y, z, (float)motX, (float)motY, (float)motZ));
        }
        if (name.equals("pirat_ghost")) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticlePiratGhost((World)world, x, y, z, (float)motX, (float)motY, (float)motZ));
        }
        if (name.equals("rat_lightning")) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleLightning((World)world, x, y, z, (float)motX, (float)motY, (float)motZ));
        }
        if (name.equals("flea")) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleFlea((World)world, x, y, z, (float)motX, (float)motY, (float)motZ));
        }
        if (name.equals("upgrade_combiner")) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleUpgradeCombiner((World)world, x, y, z, (float)motX, (float)motY, (float)motZ));
        }
        if (name.equals("saliva")) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleSaliva((World)world, x, y, z, (Fluid)Fluids.field_204546_a));
        }
        if (name.equals("black_death")) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleBlackDeath((World)world, x, y, z, (float)motX, (float)motY, (float)motZ));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TileEntity getRefrencedTE() {
        return refrencedTileEntity;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setRefrencedTE(TileEntity te) {
        refrencedTileEntity = te;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getRefrencedItem() {
        return refrencedItem;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setRefrencedItem(ItemStack stack) {
        refrencedItem = stack;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public World getWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handlePacketAutoCurdlerFluid(long blockPos, FluidStack fluid) {
        BlockPos pos = BlockPos.func_218283_e((long)blockPos);
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null && world.func_175625_s(pos) instanceof TileEntityAutoCurdler) {
            TileEntityAutoCurdler table = (TileEntityAutoCurdler)world.func_175625_s(pos);
            table.tank.setFluid(fluid);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handlePacketCheeseStaffRat(int entityId, boolean clear) {
        Entity e = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_73045_a(entityId);
        if (e instanceof EntityRat) {
            this.setRefrencedRat((EntityRat)e);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handlePacketUpdateTileSlots(long blockPos, CompoundNBT tag) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        BlockPos pos = BlockPos.func_218283_e((long)blockPos);
        if (world.func_175625_s(pos) != null) {
            TileEntity te = world.func_175625_s(pos);
            te.func_145839_a(tag);
        }
    }

    @Override
    public void setupTEISR(Item.Properties props) {
        props.setTEISR(ClientProxy::getTEISR);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Callable<ItemStackTileEntityRenderer> getTEISR() {
        return RatsTEISR::new;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void openRadiusStaffGui() {
        if (refrencedRat != null) {
            Minecraft.func_71410_x().func_147108_a((Screen)new GuiRadiusStaff(refrencedRat));
        }
    }
}

