/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.gui;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.client.gui.ChangeCommandButton;
import com.github.alexthe666.rats.server.entity.tile.TileEntityAutoCurdler;
import com.github.alexthe666.rats.server.inventory.ContainerAutoCurdler;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.client.config.GuiUtils;

public class GuiAutoCurdler
extends ContainerScreen<ContainerAutoCurdler> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("rats:textures/gui/auto_curdler.png");
    private final PlayerInventory playerInventory;
    private final IInventory tileFurnace;
    public ChangeCommandButton previousCommand;
    public ChangeCommandButton nextCommand;
    public ITextComponent name;
    private int cookTime;
    private int totalCookTime;

    public GuiAutoCurdler(ContainerAutoCurdler container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        this.playerInventory = inv;
        this.tileFurnace = container.tileRatCraftingTable;
        this.name = name;
    }

    public static void renderFluidStack(int x, int y, int width, int height, float depth, FluidStack fluidStack) {
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_195424_a(fluidStack.getFluid().getAttributes().getStillTexture());
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        float u1 = sprite.func_94209_e();
        float v1 = sprite.func_94206_g();
        do {
            int currentHeight = Math.min(sprite.func_94216_b(), height);
            height -= currentHeight;
            float v2 = sprite.func_94207_b((double)((float)(16 * currentHeight) / (float)sprite.func_94216_b()));
            int x2 = x;
            int width2 = width;
            do {
                int currentWidth = Math.min(sprite.func_94211_a(), width2);
                width2 -= currentWidth;
                float u2 = sprite.func_94214_a((double)((float)(16 * currentWidth) / (float)sprite.func_94211_a()));
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                bufferbuilder.func_181662_b((double)x2, (double)y, (double)depth).func_187315_a((double)u1, (double)v1).func_181675_d();
                bufferbuilder.func_181662_b((double)x2, (double)(y + currentHeight), (double)depth).func_187315_a((double)u1, (double)v2).func_181675_d();
                bufferbuilder.func_181662_b((double)(x2 + currentWidth), (double)(y + currentHeight), (double)depth).func_187315_a((double)u2, (double)v2).func_181675_d();
                bufferbuilder.func_181662_b((double)(x2 + currentWidth), (double)y, (double)depth).func_187315_a((double)u2, (double)v1).func_181675_d();
                tessellator.func_78381_a();
                x2 += currentWidth;
            } while (width2 > 0);
            y += currentHeight;
        } while (height > 0);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String s = this.getTitle().func_150254_d();
        this.font.func_211126_b(s, (float)(this.field_146999_f / 2 - this.font.func_78256_a(s) / 2), 5.0f, 0x404040);
        this.font.func_211126_b(this.getTitle().func_150254_d(), 8.0f, (float)(this.field_147000_g - 94 + 2), 0x404040);
        int screenW = (this.width - this.field_146999_f) / 2;
        int screenH = (this.height - this.field_147000_g) / 2;
        if (RatsMod.PROXY.getRefrencedTE() instanceof TileEntityAutoCurdler && ((TileEntityAutoCurdler)RatsMod.PROXY.getRefrencedTE()).tank.getFluid() != null && mouseX > screenW + 29 && mouseX < screenW + 53 && mouseY > screenH + 15 && mouseY < screenH + 73) {
            String fluidName = TextFormatting.BLUE.toString() + ((TileEntityAutoCurdler)RatsMod.PROXY.getRefrencedTE()).tank.getFluid().getDisplayName().func_150254_d();
            String fluidSize = TextFormatting.GRAY.toString() + ((TileEntityAutoCurdler)RatsMod.PROXY.getRefrencedTE()).tank.getFluidAmount() + " " + I18n.func_135052_a((String)"container.auto_curdler.mb", (Object[])new Object[0]);
            GuiUtils.drawHoveringText(Arrays.asList(fluidName, fluidSize), (int)(mouseX - screenW), (int)(mouseY - screenH + 10), (int)this.width, (int)this.height, (int)120, (FontRenderer)this.font);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(TEXTURE);
        int i = (this.width - this.field_146999_f) / 2;
        int j = (this.height - this.field_147000_g) / 2;
        this.blit(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        int l = ((ContainerAutoCurdler)this.field_147002_h).getCookProgressionScaled();
        this.blit(i + 63, j + 35, 176, 0, l + 1, 16);
        if (RatsMod.PROXY.getRefrencedTE() instanceof TileEntityAutoCurdler && ((TileEntityAutoCurdler)RatsMod.PROXY.getRefrencedTE()).tank.getFluid() != null) {
            FluidTank tank = ((TileEntityAutoCurdler)RatsMod.PROXY.getRefrencedTE()).tank;
            int textureYPos = (int)(57.0f * ((float)tank.getFluidAmount() / (float)tank.getCapacity()));
            GuiAutoCurdler.renderFluidStack(i + 29, j + 15 - textureYPos + 57, 24, textureYPos, 0.0f, tank.getFluid());
            this.getMinecraft().func_110434_K().func_110577_a(TEXTURE);
        }
        this.blit(i + 29, j + 15, 0, 166, 24, 58);
    }
}

