/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.gui;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.client.ClientProxy;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.message.MessageCheeseStaffSync;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiCheeseStaff
extends Screen {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("rats:textures/gui/cheese_staff.png");
    private EntityRat rat;

    public GuiCheeseStaff(EntityRat rat) {
        super((ITextComponent)new TranslationTextComponent("cheese_staff", new Object[0]));
        this.rat = rat;
        this.init();
    }

    public static void drawEntityOnScreen(int posX, int posY, int scale, float mouseX, float mouseY, EntityRat entity) {
        GlStateManager.enableColorMaterial();
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)posX, (float)posY, (float)30.0f);
        GlStateManager.scalef((float)(-scale), (float)scale, (float)scale);
        GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f2 = entity.field_70761_aq;
        float f3 = entity.field_70177_z;
        float f4 = entity.field_70125_A;
        float f5 = entity.field_70758_at;
        float f6 = entity.field_70759_as;
        GlStateManager.rotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.rotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.translatef((float)0.0f, (float)0.0f, (float)0.0f);
        EntityRendererManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        GlStateManager.rotatef((float)(Minecraft.func_71410_x().field_71439_g.field_70173_aa % 360), (float)0.0f, (float)1.0f, (float)0.0f);
        rendermanager.func_178633_a(false);
        entity.field_70761_aq = 0.0f;
        entity.field_70177_z = 0.0f;
        entity.field_70125_A = 0.0f;
        entity.field_70758_at = 0.0f;
        entity.field_70759_as = 0.0f;
        rendermanager.func_188391_a((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        entity.field_70761_aq = f2;
        entity.field_70177_z = f3;
        entity.field_70125_A = f4;
        entity.field_70758_at = f5;
        entity.field_70759_as = f6;
        GlStateManager.popMatrix();
        RenderHelper.func_74518_a();
        GlStateManager.disableRescaleNormal();
        GlStateManager.activeTexture((int)GLX.GL_TEXTURE1);
        GlStateManager.disableTexture();
        GlStateManager.activeTexture((int)GLX.GL_TEXTURE0);
    }

    public void init() {
        super.init();
        this.buttons.clear();
        int i = this.width / 2;
        int j = (this.height - 166) / 2;
        String topText = I18n.func_135052_a((String)"entity.rats.rat.staff.mark_block_deposit", (Object[])new Object[]{this.getPosName()}) + " " + I18n.func_135052_a((String)("rats.direction." + ClientProxy.refrencedFacing.func_176610_l()), (Object[])new Object[0]);
        int maxLength = Math.max(150, Minecraft.func_71410_x().field_71466_p.func_78256_a(topText) + 20);
        this.addButton((Widget)new Button(i - maxLength / 2, j + 60, maxLength, 20, topText, p_214132_1_ -> {
            BlockPos pos = ClientProxy.refrencedPos;
            RatsMod.NETWORK_WRAPPER.sendToServer((Object)new MessageCheeseStaffSync(this.rat.func_145782_y(), pos, ClientProxy.refrencedFacing, 0));
            Minecraft.func_71410_x().func_147108_a(null);
            this.init();
        }));
        this.addButton((Widget)new Button(i - maxLength / 2, j + 85, maxLength, 20, I18n.func_135052_a((String)"entity.rats.rat.staff.mark_block_pickup", (Object[])new Object[]{this.getPosName()}), p_214132_1_ -> {
            BlockPos pos = ClientProxy.refrencedPos;
            RatsMod.NETWORK_WRAPPER.sendToServer((Object)new MessageCheeseStaffSync(this.rat.func_145782_y(), pos, Direction.UP, 1));
            Minecraft.func_71410_x().func_147108_a(null);
            this.init();
        }));
        this.addButton((Widget)new Button(i - maxLength / 2, j + 110, maxLength, 20, I18n.func_135052_a((String)"entity.rats.rat.staff.set_home_point", (Object[])new Object[]{this.getPosName()}), p_214132_1_ -> {
            BlockPos pos = ClientProxy.refrencedPos;
            this.rat.func_213390_a(pos, 32);
            RatsMod.NETWORK_WRAPPER.sendToServer((Object)new MessageCheeseStaffSync(this.rat.func_145782_y(), pos, Direction.UP, 2));
            this.init();
        }));
        this.addButton((Widget)new Button(i - maxLength / 2, j + 135, maxLength, 20, I18n.func_135052_a((String)"entity.rats.rat.staff.un_set_home_point", (Object[])new Object[0]), p_214132_1_ -> {
            BlockPos pos = ClientProxy.refrencedPos;
            this.rat.func_213394_dL();
            RatsMod.NETWORK_WRAPPER.sendToServer((Object)new MessageCheeseStaffSync(this.rat.func_145782_y(), pos, Direction.UP, 3));
            this.init();
        }));
        ((Widget)this.buttons.get((int)0)).active = !this.isNoInventoryAtPos();
        ((Widget)this.buttons.get((int)1)).active = !this.isNoInventoryAtPos();
        ((Widget)this.buttons.get((int)2)).active = !ClientProxy.refrencedPos.equals((Object)this.rat.func_213384_dI()) || !this.rat.func_213394_dL();
        ((Widget)this.buttons.get((int)3)).active = this.rat.func_213394_dL();
    }

    private String getPosName() {
        if (ClientProxy.refrencedPos != null) {
            BlockState state = this.rat.field_70170_p.func_180495_p(ClientProxy.refrencedPos);
            List namelist = null;
            ItemStack pick = state.func_177230_c().func_185473_a((IBlockReader)Minecraft.func_71410_x().field_71441_e, ClientProxy.refrencedPos, state);
            try {
                namelist = pick.func_82840_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (namelist != null && !namelist.isEmpty()) {
                return ((ITextComponent)namelist.get(0)).func_150254_d();
            }
        }
        return "";
    }

    private boolean isNoInventoryAtPos() {
        BlockPos pos = ClientProxy.refrencedPos;
        if (pos != null) {
            World worldIn = this.rat.field_70170_p;
            return worldIn.func_175625_s(pos) == null;
        }
        return true;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        if (this.getMinecraft() != null) {
            try {
                this.renderBackground();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.render(mouseX, mouseY, partialTicks);
        int i = (this.width - 248) / 2 + 10;
        int j = (this.height - 166) / 2 + 8;
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)0.0f, (float)0.0f, (float)10.0f);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiCheeseStaff.drawEntityOnScreen(i + 114, j + 40, 70, 0.0f, 0.0f, this.rat);
        GlStateManager.popMatrix();
    }

    public boolean isPauseScreen() {
        return false;
    }
}

