/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.gui;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.client.ClientProxy;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.message.MessageCheeseStaffSync;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.config.GuiSlider;

public class GuiRadiusStaff
extends Screen {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("rats:textures/gui/cheese_staff.png");
    private final GuiSlider.ISlider sliderResponder;
    private final EntityRat rat;
    private int sliderValue;
    private int prevSliderValue;

    public GuiRadiusStaff(EntityRat rat) {
        super((ITextComponent)new TranslationTextComponent("radius_staff", new Object[0]));
        this.prevSliderValue = this.sliderValue;
        this.rat = rat;
        this.prevSliderValue = this.sliderValue = rat.getSearchRadius();
        this.init();
        this.sliderResponder = new GuiSlider.ISlider(){

            public void onChangeSliderValue(GuiSlider slider) {
                GuiRadiusStaff.this.setSliderValue(0, (float)slider.sliderValue);
            }
        };
    }

    public static void drawEntityOnScreen(int posX, int posY, int scale, float mouseX, float mouseY, EntityRat entity) {
        GlStateManager.enableColorMaterial();
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)posX, (float)posY, (float)30.0f);
        GlStateManager.scalef((float)(-scale), (float)scale, (float)scale);
        GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f2 = entity.field_70761_aq;
        float f3 = entity.field_70177_z;
        float f4 = entity.field_70125_A;
        float f5 = entity.field_70758_at;
        float f6 = entity.field_70759_as;
        GlStateManager.rotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.rotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.translatef((float)0.0f, (float)0.0f, (float)0.0f);
        EntityRendererManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        GlStateManager.rotatef((float)(Minecraft.func_71410_x().field_71439_g.field_70173_aa % 360), (float)0.0f, (float)1.0f, (float)0.0f);
        rendermanager.func_178633_a(false);
        entity.field_70761_aq = 0.0f;
        entity.field_70177_z = 0.0f;
        entity.field_70125_A = 0.0f;
        entity.field_70758_at = 0.0f;
        entity.field_70759_as = 0.0f;
        rendermanager.func_188391_a((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        entity.field_70761_aq = f2;
        entity.field_70177_z = f3;
        entity.field_70125_A = f4;
        entity.field_70758_at = f5;
        entity.field_70759_as = f6;
        GlStateManager.popMatrix();
        RenderHelper.func_74518_a();
        GlStateManager.disableRescaleNormal();
        GlStateManager.activeTexture((int)GLX.GL_TEXTURE1);
        GlStateManager.disableTexture();
        GlStateManager.activeTexture((int)GLX.GL_TEXTURE0);
    }

    private void setSliderValue(int id, float value) {
        this.sliderValue = Math.round(value *= (float)RatConfig.maxRatRadius);
        if (this.prevSliderValue != this.sliderValue) {
            RatsMod.NETWORK_WRAPPER.sendToServer((Object)new MessageCheeseStaffSync(this.rat.func_145782_y(), BlockPos.field_177992_a, Direction.UP, 5, this.sliderValue));
            this.rat.setSearchRadius(Math.round(this.sliderValue));
        }
        this.prevSliderValue = this.sliderValue;
    }

    public void init() {
        super.init();
        this.buttons.clear();
        int i = this.width / 2;
        int j = (this.height - 166) / 2;
        String topText = I18n.func_135052_a((String)"entity.rat.staff.set_radius_loc", (Object[])new Object[]{this.getPosName()});
        String secondText = I18n.func_135052_a((String)"entity.rat.staff.reset_radius", (Object[])new Object[0]);
        int maxLength = Math.max(150, Minecraft.func_71410_x().field_71466_p.func_78256_a(topText) + 20);
        this.addButton((Widget)new Button(i - maxLength / 2, j + 60, maxLength, 20, topText, p_214132_1_ -> {
            BlockPos pos = ClientProxy.refrencedPos;
            RatsMod.NETWORK_WRAPPER.sendToServer((Object)new MessageCheeseStaffSync(this.rat.func_145782_y(), pos, Direction.UP, 4, 0));
            this.rat.setSearchRadiusCenter(pos);
        }));
        this.addButton((Widget)new GuiSlider(i - 75, j + 85, 150, 20, I18n.func_135052_a((String)"entity.rat.staff.radius", (Object[])new Object[0]) + ": ", "", 1.0, RatConfig.maxRatRadius, this.sliderValue, false, true, p_214132_1_ -> {}, this.sliderResponder){});
        this.addButton((Widget)new Button(i - maxLength / 2, j + 110, maxLength, 20, secondText, p_214132_1_ -> {
            RatsMod.NETWORK_WRAPPER.sendToServer((Object)new MessageCheeseStaffSync(this.rat.func_145782_y(), BlockPos.field_177992_a, Direction.UP, 6, 0));
            this.rat.setSearchRadiusCenter(null);
            this.rat.setSearchRadius(RatConfig.defaultRatRadius);
        }));
    }

    private String getPosName() {
        return "(" + ClientProxy.refrencedPos.func_177958_n() + ", " + ClientProxy.refrencedPos.func_177956_o() + ", " + ClientProxy.refrencedPos.func_177952_p() + ")";
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        if (this.getMinecraft() != null) {
            try {
                this.renderBackground();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.render(mouseX, mouseY, partialTicks);
        int i = (this.width - 248) / 2 + 10;
        int j = (this.height - 166) / 2 + 8;
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)0.0f, (float)0.0f, (float)10.0f);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiRadiusStaff.drawEntityOnScreen(i + 114, j + 40, 70, 0.0f, 0.0f, this.rat);
        GlStateManager.popMatrix();
    }

    public boolean isPauseScreen() {
        return false;
    }
}

