/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.gui;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.client.gui.ChangeCommandButton;
import com.github.alexthe666.rats.client.gui.CommandPressButton;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.entity.RatUtils;
import com.github.alexthe666.rats.server.inventory.ContainerRat;
import com.github.alexthe666.rats.server.message.MessageRatCommand;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.config.GuiUtils;

@OnlyIn(value=Dist.CLIENT)
public class GuiRat
extends ContainerScreen<ContainerRat> {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("rats:textures/gui/rat_inventory.png");
    private static final ResourceLocation TEXTURE_BACKDROP = new ResourceLocation("rats:textures/gui/rat_inventory_backdrop.png");
    private int currentDisplayCommand = 0;
    private EntityRat rat = RatsMod.PROXY.getRefrencedRat();
    private float mousePosx;
    private float mousePosY;

    public GuiRat(ContainerRat container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
    }

    public static void drawEntityOnScreen(int posX, int posY, int scale, float mouseX, float mouseY, EntityRat entity) {
        GlStateManager.enableColorMaterial();
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)posX, (float)posY, (float)30.0f);
        GlStateManager.scalef((float)(-scale), (float)scale, (float)scale);
        GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f2 = entity.field_70761_aq;
        float f3 = entity.field_70177_z;
        float f4 = entity.field_70125_A;
        float f5 = entity.field_70758_at;
        float f6 = entity.field_70759_as;
        GlStateManager.rotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.rotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)(-((float)Math.atan(mouseY / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        entity.field_70761_aq = (float)Math.atan(mouseX / 40.0f) * 20.0f;
        entity.field_70177_z = (float)Math.atan(mouseX / 40.0f) * 40.0f;
        entity.field_70125_A = -((float)Math.atan(mouseY / 40.0f)) * 20.0f;
        entity.field_70759_as = entity.field_70177_z;
        entity.field_70758_at = entity.field_70177_z;
        GlStateManager.translatef((float)0.0f, (float)0.0f, (float)0.0f);
        EntityRendererManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        rendermanager.func_188391_a((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        entity.field_70761_aq = f2;
        entity.field_70177_z = f3;
        entity.field_70125_A = f4;
        entity.field_70758_at = f5;
        entity.field_70759_as = f6;
        GlStateManager.popMatrix();
        RenderHelper.func_74518_a();
        GlStateManager.disableRescaleNormal();
        GlStateManager.activeTexture((int)GLX.GL_TEXTURE1);
        GlStateManager.disableTexture();
        GlStateManager.activeTexture((int)GLX.GL_TEXTURE0);
    }

    public void init() {
        super.init();
        this.buttons.clear();
        int i = (this.width - 248) / 2;
        int j = (this.height - 166) / 2;
        this.addButton((Widget)new ChangeCommandButton(1, i + 115, j + 54, false, p_214132_1_ -> {
            --this.currentDisplayCommand;
            this.currentDisplayCommand = RatUtils.wrapCommand(this.currentDisplayCommand).ordinal();
        }));
        this.addButton((Widget)new ChangeCommandButton(2, i + 198, j + 54, true, p_214132_1_ -> {
            ++this.currentDisplayCommand;
            this.currentDisplayCommand = RatUtils.wrapCommand(this.currentDisplayCommand).ordinal();
        }));
        this.addButton((Widget)new CommandPressButton(3, i + 122, j + 52, p_214132_1_ -> {
            this.rat.setCommand(RatCommand.values()[this.currentDisplayCommand]);
            RatsMod.NETWORK_WRAPPER.sendToServer((Object)new MessageRatCommand(this.rat.func_145782_y(), this.currentDisplayCommand));
        }));
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String commandText;
        String name = this.getTitle().func_150254_d().length() == 0 ? I18n.func_135052_a((String)"entity.rats.rat.name", (Object[])new Object[0]) : this.getTitle().func_150254_d();
        this.font.func_211126_b(name, (float)(this.field_146999_f / 2 - this.font.func_78256_a(name) / 2), 6.0f, 0x404040);
        String commandDesc = I18n.func_135052_a((String)"entity.rats.rat.command.current", (Object[])new Object[0]);
        this.font.func_211126_b(commandDesc, (float)(this.field_146999_f / 2 - this.font.func_78256_a(commandDesc) / 2 + 36), 19.0f, 0x404040);
        String command = I18n.func_135052_a((String)this.rat.getCommand().getTranslateName(), (Object[])new Object[0]);
        this.font.func_211126_b(command, (float)(this.field_146999_f / 2 - this.font.func_78256_a(command) / 2 + 36), 31.0f, 0xFFFFFF);
        String statusDesc = I18n.func_135052_a((String)"entity.rats.rat.command.set", (Object[])new Object[0]);
        this.font.func_211126_b(statusDesc, (float)(this.field_146999_f / 2 - this.font.func_78256_a(statusDesc) / 2 + 36), 44.0f, 0x404040);
        RatCommand command1 = RatUtils.wrapCommand(this.currentDisplayCommand);
        String command2 = I18n.func_135052_a((String)command1.getTranslateName(), (Object[])new Object[0]);
        this.font.func_211126_b(command2, (float)(this.field_146999_f / 2 - this.font.func_78256_a(command2) / 2 + 36), 56.0f, 0xFFFFFF);
        int i = (this.width - 248) / 2;
        int j = (this.height - 166) / 2;
        if (mouseX > i + 116 && mouseX < i + 198 && mouseY > j + 22 && mouseY < j + 45) {
            commandText = I18n.func_135052_a((String)this.rat.getCommand().getTranslateDescription(), (Object[])new Object[0]);
            GuiUtils.drawHoveringText(Arrays.asList(commandText), (int)(mouseX - i - 40), (int)(mouseY - j + 10), (int)this.width, (int)this.height, (int)120, (FontRenderer)this.font);
        }
        if (mouseX > i + 116 && mouseX < i + 198 && mouseY > j + 53 && mouseY < j + 69) {
            commandText = I18n.func_135052_a((String)command1.getTranslateDescription(), (Object[])new Object[0]);
            GuiUtils.drawHoveringText(Arrays.asList(commandText), (int)(mouseX - i - 40), (int)(mouseY - j + 10), (int)this.width, (int)this.height, (int)120, (FontRenderer)this.font);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int k = (this.width - this.field_146999_f) / 2;
        int l = (this.height - this.field_147000_g) / 2;
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(TEXTURE_BACKDROP);
        this.blit(k, l, 0, 0, this.field_146999_f, this.field_147000_g);
        GlStateManager.pushMatrix();
        GuiRat.drawEntityOnScreen(k + 35, l + 60, 70, (float)(k + 51) - this.mousePosx, (float)(l + 75 - 50) - this.mousePosY, this.rat);
        GlStateManager.popMatrix();
        this.getMinecraft().func_110434_K().func_110577_a(TEXTURE);
        GlStateManager.translatef((float)0.0f, (float)0.0f, (float)65.0f);
        this.blit(k, l, 0, 0, this.field_146999_f, this.field_147000_g);
        this.blit(k + 9, l + 20, this.rat.isMale() ? 176 : 192, 0, 16, this.height);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.mousePosx = mouseX;
        this.mousePosY = mouseY;
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }
}

