/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render.entity;

import com.github.alexthe666.rats.client.model.ModelRat;
import com.github.alexthe666.rats.client.render.entity.LayerPiratBoatSail;
import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.github.alexthe666.rats.server.entity.EntityGhostPirat;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.items.ItemRatUpgradeBucket;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.model.ChestModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class LayerRatHeldItem
extends LayerRenderer<EntityRat, ModelRat<EntityRat>> {
    protected static final ChestModel MODEL_CHEST = new ChestModel();
    private static final ResourceLocation TEXTURE_CHRISTMAS_CHEST = new ResourceLocation("textures/entity/chest/christmas.png");
    private static ItemStack PLATTER_STACK = new ItemStack((IItemProvider)Blocks.field_150443_bT);
    private static ItemStack AXE_STACK = new ItemStack((IItemProvider)Items.field_151049_t);
    private static ItemStack PICKAXE_STACK = new ItemStack((IItemProvider)Items.field_151050_s);
    private static ItemStack IRON_AXE_STACK = new ItemStack((IItemProvider)Items.field_151036_c);
    private static ItemStack IRON_HOE_STACK = new ItemStack((IItemProvider)Items.field_151019_K);
    private static ItemStack SHEARS_STACK = new ItemStack((IItemProvider)Items.field_151097_aZ);
    private static ItemStack TNT_STACK = new ItemStack((IItemProvider)Blocks.field_150335_W);
    private static ItemStack FISHING_ROD_STACK = new ItemStack((IItemProvider)Items.field_151112_aM);
    private static ItemStack WING_STACK = new ItemStack((IItemProvider)RatsItemRegistry.FEATHERY_WING);
    private static ItemStack DRAGON_WING_STACK = new ItemStack((IItemProvider)RatsItemRegistry.DRAGON_WING);
    private static ItemStack CARROT_STACK = new ItemStack((IItemProvider)Blocks.field_196554_aH);
    private final IEntityRenderer<EntityRat, ModelRat<EntityRat>> renderer;

    public LayerRatHeldItem(IEntityRenderer<EntityRat, ModelRat<EntityRat>> renderer) {
        super(renderer);
        this.renderer = renderer;
    }

    public void render(EntityRat entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        float wingFold;
        float wingAngle;
        Minecraft minecraft;
        if (!(this.renderer.func_217764_d() instanceof ModelRat)) {
            return;
        }
        ItemStack itemstack = entity.func_184586_b(Hand.MAIN_HAND);
        if (!itemstack.func_190926_b()) {
            GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.pushMatrix();
            if (((ModelRat)this.renderer.func_217764_d()).field_217114_e) {
                GlStateManager.translatef((float)0.0f, (float)0.625f, (float)0.0f);
                GlStateManager.rotatef((float)-20.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                float f = 0.5f;
                GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            }
            minecraft = Minecraft.func_71410_x();
            if (entity.shouldNotIdleAnimation()) {
                this.translateToHead();
                GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.translatef((float)0.0f, (float)0.25f, (float)0.05f);
            } else {
                this.translateToHand(true);
                GlStateManager.rotatef((float)190.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.rotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.translatef((float)-0.155f, (float)-0.025f, (float)0.125f);
                if (entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_PLATTER)) {
                    GlStateManager.translatef((float)0.0f, (float)0.25f, (float)0.0f);
                    if (itemstack.func_77973_b() instanceof BlockItem) {
                        GlStateManager.rotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    } else {
                        GlStateManager.translatef((float)0.0f, (float)-0.1f, (float)-0.075f);
                    }
                }
                if (entity.holdsItemInHandUpgrade()) {
                    GlStateManager.translatef((float)0.15f, (float)-0.075f, (float)0.0f);
                }
            }
            if (entity instanceof EntityGhostPirat) {
                GlStateManager.disableLighting();
                GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)240.0f, (float)0.0f);
            }
            minecraft.func_175599_af().func_184392_a(itemstack, (LivingEntity)entity, ItemCameraTransforms.TransformType.GROUND, false);
            GlStateManager.popMatrix();
        }
        if (entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_BUCCANEER)) {
            GlStateManager.pushMatrix();
            ((ModelRat)this.renderer.func_217764_d()).body1.func_78794_c(0.0625f);
            GlStateManager.pushMatrix();
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)0.0f, (float)-0.925f, (float)0.2f);
            GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            this.renderer.func_110776_a(LayerPiratBoatSail.TEXTURE_PIRATE_CANNON);
            LayerPiratBoatSail.MODEL_PIRAT_CANNON.func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            GlStateManager.popMatrix();
            if (entity.getVisualFlag()) {
                GlStateManager.pushMatrix();
                GlStateManager.translatef((float)0.0f, (float)-0.925f, (float)0.2f);
                GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
                GlStateManager.disableLighting();
                GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)61680.0f, (float)0.0f);
                this.renderer.func_110776_a(LayerPiratBoatSail.TEXTURE_PIRATE_CANNON_FIRE);
                LayerPiratBoatSail.MODEL_PIRAT_CANNON.func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                GlStateManager.enableLighting();
                GlStateManager.popMatrix();
            }
            GlStateManager.popMatrix();
            GlStateManager.popMatrix();
        }
        if (entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_CHRISTMAS)) {
            GlStateManager.pushMatrix();
            if (((ModelRat)this.renderer.func_217764_d()).field_217114_e) {
                GlStateManager.translatef((float)0.0f, (float)0.625f, (float)0.0f);
                GlStateManager.rotatef((float)-20.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                float f = 0.5f;
                GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            }
            minecraft = Minecraft.func_71410_x();
            this.translateToHand(false);
            GlStateManager.rotatef((float)-80.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.rotatef((float)10.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.translatef((float)0.15f, (float)-0.4f, (float)-0.5f);
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)-0.175f, (float)0.25f, (float)0.2f);
            GlStateManager.scalef((float)0.35f, (float)0.35f, (float)0.35f);
            this.renderer.func_110776_a(TEXTURE_CHRISTMAS_CHEST);
            MODEL_CHEST.func_78231_a();
            GlStateManager.popMatrix();
            GlStateManager.popMatrix();
        }
        if (entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_PLATTER)) {
            GlStateManager.pushMatrix();
            if (((ModelRat)this.renderer.func_217764_d()).field_217114_e) {
                GlStateManager.translatef((float)0.0f, (float)0.625f, (float)0.0f);
                GlStateManager.rotatef((float)-20.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                float f = 0.5f;
                GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            }
            minecraft = Minecraft.func_71410_x();
            this.translateToHand(true);
            GlStateManager.rotatef((float)190.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)-70.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.translatef((float)-0.155f, (float)-0.225f, (float)0.2f);
            GlStateManager.scalef((float)2.0f, (float)2.0f, (float)2.0f);
            minecraft.func_175599_af().func_184392_a(PLATTER_STACK, (LivingEntity)entity, ItemCameraTransforms.TransformType.GROUND, false);
            GlStateManager.popMatrix();
        }
        if (entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_BUCKET) || entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_BIG_BUCKET) || entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_MILKER)) {
            GlStateManager.pushMatrix();
            if (((ModelRat)this.renderer.func_217764_d()).field_217114_e) {
                GlStateManager.translatef((float)0.0f, (float)0.625f, (float)0.0f);
                GlStateManager.rotatef((float)-20.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                float f = 0.5f;
                GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            }
            minecraft = Minecraft.func_71410_x();
            this.translateToHand(true);
            GlStateManager.rotatef((float)190.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)-40.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.translatef((float)-0.155f, (float)-0.225f, (float)0.1f);
            GlStateManager.scalef((float)1.75f, (float)1.75f, (float)1.75f);
            minecraft.func_175599_af().func_184392_a(ItemRatUpgradeBucket.getBucketFromFluid(entity.transportingFluid), (LivingEntity)entity, ItemCameraTransforms.TransformType.GROUND, false);
            GlStateManager.popMatrix();
        }
        if (entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_CRAFTING)) {
            minecraft = Minecraft.func_71410_x();
            GlStateManager.pushMatrix();
            this.translateToHand(true);
            GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.rotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            minecraft.func_175599_af().func_184392_a(AXE_STACK, (LivingEntity)entity, ItemCameraTransforms.TransformType.GROUND, false);
            GlStateManager.popMatrix();
            GlStateManager.pushMatrix();
            this.translateToHand(false);
            GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.rotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            minecraft.func_175599_af().func_184392_a(PICKAXE_STACK, (LivingEntity)entity, ItemCameraTransforms.TransformType.GROUND, false);
            GlStateManager.popMatrix();
        }
        if (entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_LUMBERJACK)) {
            minecraft = Minecraft.func_71410_x();
            GlStateManager.pushMatrix();
            this.translateToHand(false);
            GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.rotatef((float)-15.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            minecraft.func_175599_af().func_184392_a(IRON_AXE_STACK, (LivingEntity)entity, ItemCameraTransforms.TransformType.GROUND, false);
            GlStateManager.popMatrix();
        }
        if (entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_MINER)) {
            minecraft = Minecraft.func_71410_x();
            GlStateManager.pushMatrix();
            this.translateToHand(false);
            GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.rotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            minecraft.func_175599_af().func_184392_a(new ItemStack((IItemProvider)Items.field_151046_w), (LivingEntity)entity, ItemCameraTransforms.TransformType.GROUND, false);
            GlStateManager.popMatrix();
        }
        if (entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FARMER)) {
            minecraft = Minecraft.func_71410_x();
            GlStateManager.pushMatrix();
            this.translateToHand(false);
            GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.rotatef((float)-15.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            minecraft.func_175599_af().func_184392_a(IRON_HOE_STACK, (LivingEntity)entity, ItemCameraTransforms.TransformType.GROUND, false);
            GlStateManager.popMatrix();
        }
        if (entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_SHEARS)) {
            minecraft = Minecraft.func_71410_x();
            GlStateManager.pushMatrix();
            this.translateToHand(false);
            GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.rotatef((float)15.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.translatef((float)0.1f, (float)0.0f, (float)0.0f);
            minecraft.func_175599_af().func_184392_a(SHEARS_STACK, (LivingEntity)entity, ItemCameraTransforms.TransformType.GROUND, false);
            GlStateManager.popMatrix();
        }
        if (entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FISHERMAN)) {
            minecraft = Minecraft.func_71410_x();
            GlStateManager.pushMatrix();
            this.translateToHand(false);
            GlStateManager.rotatef((float)-180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.translatef((float)0.2f, (float)0.0f, (float)0.0f);
            minecraft.func_175599_af().func_184392_a(FISHING_ROD_STACK, (LivingEntity)entity, ItemCameraTransforms.TransformType.GROUND, false);
            GlStateManager.popMatrix();
        }
        if (entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FLIGHT)) {
            GlStateManager.pushMatrix();
            minecraft = Minecraft.func_71410_x();
            wingAngle = entity.field_70122_E ? 0.0f : MathHelper.func_76126_a((float)ageInTicks) * 30.0f;
            wingFold = entity.field_70122_E ? -45.0f : 0.0f;
            ((ModelRat)this.renderer.func_217764_d()).body1.func_78794_c(0.0625f);
            ((ModelRat)this.renderer.func_217764_d()).body2.func_78794_c(0.0625f);
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)0.0f, (float)-0.1f, (float)0.0f);
            GlStateManager.rotatef((float)wingAngle, (float)0.0f, (float)0.0f, (float)-1.0f);
            GlStateManager.rotatef((float)wingFold, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.translatef((float)0.55f, (float)0.0f, (float)0.2f);
            GlStateManager.rotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.scalef((float)2.0f, (float)2.0f, (float)1.0f);
            minecraft.func_175599_af().func_184392_a(WING_STACK, (LivingEntity)entity, ItemCameraTransforms.TransformType.GROUND, false);
            GlStateManager.popMatrix();
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)0.0f, (float)-0.1f, (float)0.0f);
            GlStateManager.rotatef((float)wingAngle, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.rotatef((float)wingFold, (float)0.0f, (float)-1.0f, (float)0.0f);
            GlStateManager.translatef((float)-0.55f, (float)0.0f, (float)0.2f);
            GlStateManager.rotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.scalef((float)2.0f, (float)2.0f, (float)1.0f);
            minecraft.func_175599_af().func_184392_a(WING_STACK, (LivingEntity)entity, ItemCameraTransforms.TransformType.GROUND, false);
            GlStateManager.popMatrix();
            GlStateManager.popMatrix();
        }
        if (entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_DRAGON)) {
            GlStateManager.pushMatrix();
            minecraft = Minecraft.func_71410_x();
            wingAngle = entity.field_70122_E ? 0.0f : MathHelper.func_76126_a((float)ageInTicks) * 30.0f;
            wingFold = entity.field_70122_E ? -45.0f : 0.0f;
            ((ModelRat)this.renderer.func_217764_d()).body1.func_78794_c(0.0625f);
            ((ModelRat)this.renderer.func_217764_d()).body2.func_78794_c(0.0625f);
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)0.0f, (float)-0.1f, (float)0.0f);
            GlStateManager.rotatef((float)wingAngle, (float)0.0f, (float)0.0f, (float)-1.0f);
            GlStateManager.rotatef((float)wingFold, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.translatef((float)0.55f, (float)0.0f, (float)0.2f);
            GlStateManager.rotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.scalef((float)2.0f, (float)2.0f, (float)1.0f);
            minecraft.func_175599_af().func_184392_a(DRAGON_WING_STACK, (LivingEntity)entity, ItemCameraTransforms.TransformType.GROUND, false);
            GlStateManager.popMatrix();
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)0.0f, (float)-0.1f, (float)0.0f);
            GlStateManager.rotatef((float)wingAngle, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.rotatef((float)wingFold, (float)0.0f, (float)-1.0f, (float)0.0f);
            GlStateManager.translatef((float)-0.55f, (float)0.0f, (float)0.2f);
            GlStateManager.rotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.scalef((float)2.0f, (float)2.0f, (float)1.0f);
            minecraft.func_175599_af().func_184392_a(DRAGON_WING_STACK, (LivingEntity)entity, ItemCameraTransforms.TransformType.GROUND, false);
            GlStateManager.popMatrix();
            GlStateManager.popMatrix();
        }
        if (entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_TNT) || entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_TNT_SURVIVOR)) {
            minecraft = Minecraft.func_71410_x();
            ((ModelRat)this.renderer.func_217764_d()).body1.func_78794_c(0.0625f);
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)0.0f, (float)0.1f, (float)0.1f);
            GlStateManager.rotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.scalef((float)2.0f, (float)2.0f, (float)2.0f);
            minecraft.func_175599_af().func_184392_a(TNT_STACK, (LivingEntity)entity, ItemCameraTransforms.TransformType.GROUND, false);
            GlStateManager.popMatrix();
        }
        if (entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_CARRAT)) {
            minecraft = Minecraft.func_71410_x();
            ((ModelRat)this.renderer.func_217764_d()).body1.func_78794_c(0.0625f);
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)0.0f, (float)-0.05f, (float)0.5f);
            GlStateManager.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.scalef((float)2.0f, (float)2.0f, (float)2.0f);
            minecraft.func_175599_af().func_184392_a(CARROT_STACK, (LivingEntity)entity, ItemCameraTransforms.TransformType.GROUND, false);
            GlStateManager.popMatrix();
        }
        if (entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_PSYCHIC)) {
            minecraft = Minecraft.func_71410_x();
            GlStateManager.pushMatrix();
            this.translateToHead();
            GlStateManager.translatef((float)0.0f, (float)0.1f, (float)0.035f);
            GlStateManager.rotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.scalef((float)0.9f, (float)0.9f, (float)0.9f);
            minecraft.func_175599_af().func_184392_a(new ItemStack((IItemProvider)RatsBlockRegistry.BRAIN_BLOCK), (LivingEntity)entity, ItemCameraTransforms.TransformType.GROUND, false);
            GlStateManager.popMatrix();
        }
    }

    protected void translateToHead() {
        ((ModelRat)this.renderer.func_217764_d()).body1.func_78794_c(0.0625f);
        ((ModelRat)this.renderer.func_217764_d()).body2.func_78794_c(0.0625f);
        ((ModelRat)this.renderer.func_217764_d()).neck.func_78794_c(0.0625f);
        ((ModelRat)this.renderer.func_217764_d()).head.func_78794_c(0.0625f);
    }

    protected void translateToHand(boolean left) {
        ((ModelRat)this.renderer.func_217764_d()).body1.func_78794_c(0.0625f);
        ((ModelRat)this.renderer.func_217764_d()).body2.func_78794_c(0.0625f);
        if (left) {
            ((ModelRat)this.renderer.func_217764_d()).leftArm.func_78794_c(0.0625f);
            ((ModelRat)this.renderer.func_217764_d()).leftHand.func_78794_c(0.0625f);
        } else {
            ((ModelRat)this.renderer.func_217764_d()).rightArm.func_78794_c(0.0625f);
            ((ModelRat)this.renderer.func_217764_d()).rightHand.func_78794_c(0.0625f);
        }
    }

    public boolean func_177142_b() {
        return false;
    }
}

