/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render.entity;

import com.github.alexthe666.rats.client.model.ModelRat;
import com.github.alexthe666.rats.server.entity.EntityGhostPirat;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.items.ItemChefToque;
import com.github.alexthe666.rats.server.items.ItemPiperHat;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.ArmorLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.BannerItem;
import net.minecraft.item.DyeableArmorItem;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;

@OnlyIn(value=Dist.CLIENT)
public class LayerRatHelmet<T extends EntityRat, M extends ModelRat<T>>
extends LayerRenderer<T, M> {
    private float alpha = 1.0f;
    private float colorR = 1.0f;
    private float colorG = 1.0f;
    private float colorB = 1.0f;
    private final IEntityRenderer<T, M> renderer;
    private final BipedModel defaultBipedModel = new BipedModel(1.0f);
    private static final Map<String, ResourceLocation> ARMOR_TEXTURE_RES_MAP = Maps.newHashMap();
    protected static final ResourceLocation ENCHANTED_ITEM_GLINT_RES = new ResourceLocation("textures/misc/enchanted_item_glint.png");

    public LayerRatHelmet(IEntityRenderer<T, M> rendererIn) {
        super(rendererIn);
        this.renderer = rendererIn;
    }

    public void render(T rat, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        ItemStack itemstack;
        GlStateManager.pushMatrix();
        if (((EntityRat)((Object)rat)).hasUpgrade(RatsItemRegistry.RAT_UPGRADE_GOD)) {
            ((ModelRat)this.renderer.func_217764_d()).func_78088_a((Entity)rat, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            ArmorLayer.func_215338_a(arg_0 -> ((LayerRatHelmet)this).func_215333_a(arg_0), rat, (EntityModel)this.renderer.func_217764_d(), (float)limbSwing, (float)limbSwingAmount, (float)partialTicks, (float)ageInTicks, (float)netHeadYaw, (float)headPitch, (float)scale);
            GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (((EntityRat)((Object)rat)).hasUpgrade(RatsItemRegistry.RAT_UPGRADE_NONBELIEVER)) {
            ((ModelRat)this.renderer.func_217764_d()).func_78088_a((Entity)rat, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            LayerRatHelmet.renderEnchanted(arg_0 -> ((LayerRatHelmet)this).func_215333_a(arg_0), rat, this.renderer.func_217764_d(), limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, 0.0f, 1.0f, 0.0f);
            GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
        if ((itemstack = ((EntityRat)((Object)rat)).func_184582_a(EquipmentSlotType.HEAD)).func_77973_b() instanceof ArmorItem) {
            ArmorItem armoritem = (ArmorItem)itemstack.func_77973_b();
            if (armoritem.func_185083_B_() == EquipmentSlotType.HEAD) {
                BipedModel<?> a = this.defaultBipedModel;
                a = this.getArmorModelHook((LivingEntity)rat, itemstack, EquipmentSlotType.HEAD, (BipedModel)a);
                this.setModelSlotVisible(a, EquipmentSlotType.HEAD);
                boolean flag = false;
                ((ModelRat)this.renderer.func_217764_d()).body1.func_78794_c(0.0625f);
                ((ModelRat)this.renderer.func_217764_d()).body2.func_78794_c(0.0625f);
                ((ModelRat)this.renderer.func_217764_d()).neck.func_78794_c(0.0625f);
                ((ModelRat)this.renderer.func_217764_d()).head.func_78794_c(0.0625f);
                GlStateManager.translatef((float)0.0f, (float)-0.375f, (float)-0.045f);
                GlStateManager.rotatef((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.scalef((float)0.55f, (float)0.55f, (float)0.55f);
                if (itemstack.func_77973_b() instanceof ItemChefToque) {
                    GlStateManager.rotatef((float)-25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.translatef((float)0.0f, (float)0.1f, (float)0.3f);
                }
                if (itemstack.func_77973_b() instanceof ItemPiperHat) {
                    GlStateManager.rotatef((float)-10.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.translatef((float)0.0f, (float)0.1f, (float)0.1f);
                }
                if (itemstack.func_77973_b() == RatsItemRegistry.PIRAT_HAT) {
                    GlStateManager.rotatef((float)-5.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.translatef((float)0.0f, (float)-0.125f, (float)0.0f);
                    GlStateManager.scalef((float)1.425f, (float)1.425f, (float)1.425f);
                }
                if (itemstack.func_77973_b() == RatsItemRegistry.GHOST_PIRAT_HAT) {
                    float piratScale = rat instanceof EntityGhostPirat ? 1.1f : 1.425f;
                    float piratTranslate = rat instanceof EntityGhostPirat ? 0.05f : -0.125f;
                    GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.3f);
                    GlStateManager.rotatef((float)-5.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.translatef((float)0.0f, (float)piratTranslate, (float)0.0f);
                    GlStateManager.scalef((float)piratScale, (float)piratScale, (float)piratScale);
                }
                if (itemstack.func_77973_b() == RatsItemRegistry.ARCHEOLOGIST_HAT) {
                    GlStateManager.rotatef((float)-5.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.scalef((float)1.425f, (float)1.425f, (float)1.425f);
                }
                if (itemstack.func_77973_b() == RatsItemRegistry.FARMER_HAT || itemstack.func_77973_b() == RatsItemRegistry.FISHERMAN_HAT) {
                    GlStateManager.rotatef((float)-5.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.scalef((float)1.425f, (float)1.425f, (float)1.425f);
                }
                if (itemstack.func_77973_b() == RatsItemRegistry.PLAGUE_DOCTOR_MASK || itemstack.func_77973_b() == RatsItemRegistry.BLACK_DEATH_MASK) {
                    GlStateManager.rotatef((float)-15.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.translatef((float)0.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.scalef((float)1.5f, (float)1.2f, (float)1.5f);
                }
                if (itemstack.func_77973_b() == RatsItemRegistry.RAT_FEZ) {
                    GlStateManager.translatef((float)-0.15f, (float)-0.05f, (float)-0.1f);
                    GlStateManager.scalef((float)1.425f, (float)1.425f, (float)1.425f);
                }
                if (itemstack.func_77973_b() == RatsItemRegistry.TOP_HAT) {
                    GlStateManager.rotatef((float)-5.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.scalef((float)1.425f, (float)1.425f, (float)1.425f);
                }
                if (itemstack.func_77973_b() == RatsItemRegistry.SANTA_HAT) {
                    GlStateManager.rotatef((float)-5.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.translatef((float)0.0f, (float)0.0f, (float)0.1f);
                    GlStateManager.scalef((float)1.25f, (float)1.25f, (float)1.25f);
                }
                if (itemstack.func_77973_b() == RatsItemRegistry.PARTY_HAT_1 || itemstack.func_77973_b() == RatsItemRegistry.PARTY_HAT_2 || itemstack.func_77973_b() == RatsItemRegistry.PARTY_HAT_3 || itemstack.func_77973_b() == RatsItemRegistry.PARTY_HAT_4) {
                    GlStateManager.translatef((float)0.0f, (float)0.075f, (float)-0.05f);
                    GlStateManager.scalef((float)1.25f, (float)1.25f, (float)1.25f);
                }
                this.func_215333_a(LayerRatHelmet.getArmorResource(rat, itemstack, EquipmentSlotType.HEAD, null));
                if (armoritem instanceof IDyeableArmorItem) {
                    int i = ((DyeableArmorItem)armoritem).func_200886_f(itemstack);
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    GlStateManager.color4f((float)(this.colorR * f), (float)(this.colorG * f1), (float)(this.colorB * f2), (float)this.alpha);
                    a.func_78088_a(rat, limbSwing, limbSwingAmount, ageInTicks, 0.0f, 0.0f, scale);
                    this.func_215333_a(LayerRatHelmet.getArmorResource(rat, itemstack, EquipmentSlotType.HEAD, "overlay"));
                }
                GlStateManager.color4f((float)this.colorR, (float)this.colorG, (float)this.colorB, (float)this.alpha);
                a.func_78088_a(rat, limbSwing, limbSwingAmount, ageInTicks, 0.0f, 0.0f, scale);
                if (itemstack.func_77962_s()) {
                    ArmorLayer.func_215338_a(arg_0 -> ((LayerRatHelmet)this).func_215333_a(arg_0), rat, a, (float)limbSwing, (float)limbSwingAmount, (float)partialTicks, (float)ageInTicks, (float)0.0f, (float)0.0f, (float)scale);
                    GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
        } else if (itemstack.func_77973_b() instanceof BannerItem) {
            ((ModelRat)this.renderer.func_217764_d()).body1.func_78794_c(0.0625f);
            ((ModelRat)this.renderer.func_217764_d()).body2.func_78794_c(0.0625f);
            GlStateManager.translatef((float)0.0f, (float)-0.5f, (float)-0.2f);
            GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            float sitProgress = ((EntityRat)((Object)rat)).sitProgress / 20.0f;
            GlStateManager.rotatef((float)(sitProgress * -40.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.translatef((float)0.0f, (float)0.0f, (float)(-sitProgress * 0.04f));
            GlStateManager.scalef((float)1.7f, (float)1.7f, (float)1.7f);
            Minecraft.func_71410_x().func_175599_af().func_184392_a(itemstack, rat, ItemCameraTransforms.TransformType.FIXED, false);
        } else {
            ((ModelRat)this.renderer.func_217764_d()).body1.func_78794_c(0.0625f);
            ((ModelRat)this.renderer.func_217764_d()).body2.func_78794_c(0.0625f);
            ((ModelRat)this.renderer.func_217764_d()).neck.func_78794_c(0.0625f);
            ((ModelRat)this.renderer.func_217764_d()).head.func_78794_c(0.0625f);
            GlStateManager.translatef((float)0.0f, (float)0.025f, (float)-0.2f);
            GlStateManager.rotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.scalef((float)0.8f, (float)0.8f, (float)0.8f);
            Minecraft.func_71410_x().func_175599_af().func_184392_a(itemstack, rat, ItemCameraTransforms.TransformType.FIXED, false);
        }
        GlStateManager.popMatrix();
    }

    public boolean func_177142_b() {
        return false;
    }

    public static ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlotType slot, @Nullable String type) {
        ArmorItem item = (ArmorItem)stack.func_77973_b();
        String texture = item.func_200880_d().func_200897_d();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, 1, type == null ? "" : String.format("_%s", type));
        ResourceLocation resourcelocation = ARMOR_TEXTURE_RES_MAP.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlotType)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            ARMOR_TEXTURE_RES_MAP.put(s1, resourcelocation);
        }
        return resourcelocation;
    }

    protected BipedModel<?> getArmorModelHook(LivingEntity entity, ItemStack itemStack, EquipmentSlotType slot, BipedModel model) {
        return ForgeHooksClient.getArmorModel((LivingEntity)entity, (ItemStack)itemStack, (EquipmentSlotType)slot, (BipedModel)model);
    }

    protected void setModelSlotVisible(BipedModel p_188359_1_, EquipmentSlotType slotIn) {
        this.setModelVisible(p_188359_1_);
        switch (slotIn) {
            case HEAD: {
                p_188359_1_.field_78116_c.field_78806_j = true;
                p_188359_1_.field_178720_f.field_78806_j = true;
                break;
            }
            case CHEST: {
                p_188359_1_.field_78115_e.field_78806_j = true;
                p_188359_1_.field_178723_h.field_78806_j = true;
                p_188359_1_.field_178724_i.field_78806_j = true;
                break;
            }
            case LEGS: {
                p_188359_1_.field_78115_e.field_78806_j = true;
                p_188359_1_.field_178721_j.field_78806_j = true;
                p_188359_1_.field_178722_k.field_78806_j = true;
                break;
            }
            case FEET: {
                p_188359_1_.field_178721_j.field_78806_j = true;
                p_188359_1_.field_178722_k.field_78806_j = true;
            }
        }
    }

    protected void setModelVisible(BipedModel model) {
        model.func_178719_a(false);
    }

    public static <T extends Entity> void renderEnchanted(Consumer<ResourceLocation> p_215338_0_, T p_215338_1_, EntityModel<T> p_215338_2_, float p_215338_3_, float p_215338_4_, float p_215338_5_, float p_215338_6_, float p_215338_7_, float p_215338_8_, float p_215338_9_, float r, float g, float b) {
        float f = (float)p_215338_1_.field_70173_aa + p_215338_5_;
        p_215338_0_.accept(ENCHANTED_ITEM_GLINT_RES);
        GameRenderer gamerenderer = Minecraft.func_71410_x().field_71460_t;
        gamerenderer.func_191514_d(true);
        GlStateManager.enableBlend();
        GlStateManager.depthFunc((int)514);
        GlStateManager.depthMask((boolean)false);
        float f1 = 0.5f;
        GlStateManager.color4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        for (int i = 0; i < 2; ++i) {
            GlStateManager.disableLighting();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            float f2 = 0.76f;
            GlStateManager.color4f((float)r, (float)g, (float)b, (float)1.0f);
            GlStateManager.matrixMode((int)5890);
            GlStateManager.loadIdentity();
            float f3 = 0.33333334f;
            GlStateManager.scalef((float)0.33333334f, (float)0.33333334f, (float)0.33333334f);
            GlStateManager.rotatef((float)(30.0f - (float)i * 60.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.translatef((float)0.0f, (float)(f * (0.001f + (float)i * 0.003f) * 20.0f), (float)0.0f);
            GlStateManager.matrixMode((int)5888);
            p_215338_2_.func_78088_a(p_215338_1_, p_215338_3_, p_215338_4_, p_215338_6_, p_215338_7_, p_215338_8_, p_215338_9_);
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }
        GlStateManager.matrixMode((int)5890);
        GlStateManager.loadIdentity();
        GlStateManager.matrixMode((int)5888);
        GlStateManager.enableLighting();
        GlStateManager.depthMask((boolean)true);
        GlStateManager.depthFunc((int)515);
        GlStateManager.disableBlend();
        gamerenderer.func_191514_d(false);
    }
}

