/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render.entity;

import com.github.alexthe666.rats.client.model.ModelRat;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;

public class LayerRatPlague
extends LayerRenderer<EntityRat, ModelRat<EntityRat>> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("rats:textures/entity/rat/rat_plague_overlay.png");
    private static final ResourceLocation TEXTURE_LUMBERJACK = new ResourceLocation("rats:textures/entity/rat/rat_lumberjack_upgrade.png");
    private static final ResourceLocation TEXTURE_TOGA = new ResourceLocation("rats:textures/entity/rat/toga.png");
    private static final ResourceLocation TEXTURE_RATINATOR = new ResourceLocation("rats:textures/entity/rat/rat_ratinator_upgrade.png");
    private static final ResourceLocation TEXTURE_PSYCHIC = new ResourceLocation("rats:textures/entity/ratlantis/psychic.png");
    private ResourceLocation TEXTURE_GHOST = new ResourceLocation("rats:textures/entity/ratlantis/ghost_pirat_overlay.png");
    private static final ModelRat RAT_MODEL = new ModelRat(0.5f);
    private final IEntityRenderer<EntityRat, ModelRat<EntityRat>> ratRenderer;

    public LayerRatPlague(IEntityRenderer<EntityRat, ModelRat<EntityRat>> ratRendererIn) {
        super(ratRendererIn);
        this.ratRenderer = ratRendererIn;
    }

    public void render(EntityRat rat, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        GameRenderer gamerenderer;
        if (!(this.ratRenderer.func_217764_d() instanceof ModelRat)) {
            return;
        }
        if (rat.hasPlague()) {
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.enableNormalize();
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.ratRenderer.func_110776_a(TEXTURE);
            ((ModelRat)this.ratRenderer.func_217764_d()).func_78088_a((Entity)rat, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            GlStateManager.disableBlend();
            GlStateManager.disableNormalize();
        }
        if (rat.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_BASIC_ENERGY) && rat.getHeldRF() > 0) {
            float alpha = (float)rat.getHeldRF() / Math.max(1.0f, (float)rat.getRFTransferRate());
            GlStateManager.pushMatrix();
            boolean flag = true;
            GlStateManager.depthMask((!flag ? 1 : 0) != 0);
            this.ratRenderer.func_110776_a(TEXTURE_PSYCHIC);
            GlStateManager.matrixMode((int)5890);
            GlStateManager.loadIdentity();
            float f = (float)rat.field_70173_aa + partialTicks;
            GlStateManager.translatef((float)(f * 0.01f), (float)(f * 0.01f), (float)0.0f);
            GlStateManager.matrixMode((int)5888);
            GlStateManager.enableBlend();
            GlStateManager.color4f((float)0.5f, (float)0.5f, (float)0.5f, (float)alpha);
            GlStateManager.disableLighting();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            gamerenderer = Minecraft.func_71410_x().field_71460_t;
            gamerenderer.func_191514_d(false);
            RAT_MODEL.func_78088_a((Entity)rat, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            gamerenderer.func_191514_d(true);
            GlStateManager.matrixMode((int)5890);
            GlStateManager.loadIdentity();
            GlStateManager.matrixMode((int)5888);
            GlStateManager.enableLighting();
            GlStateManager.disableBlend();
            GlStateManager.depthMask((boolean)flag);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.popMatrix();
        }
        if (rat.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_RATINATOR)) {
            this.ratRenderer.func_110776_a(TEXTURE_RATINATOR);
            ((ModelRat)this.ratRenderer.func_217764_d()).func_78088_a((Entity)rat, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        }
        if (rat.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_LUMBERJACK)) {
            this.ratRenderer.func_110776_a(TEXTURE_LUMBERJACK);
            ((ModelRat)this.ratRenderer.func_217764_d()).func_78088_a((Entity)rat, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        }
        if (rat.hasToga()) {
            this.ratRenderer.func_110776_a(TEXTURE_TOGA);
            ((ModelRat)this.ratRenderer.func_217764_d()).func_78088_a((Entity)rat, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        }
        if (rat.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ETHEREAL)) {
            boolean flag = rat.func_82150_aj();
            GlStateManager.depthMask((!flag ? 1 : 0) != 0);
            this.func_215333_a(this.TEXTURE_GHOST);
            GlStateManager.matrixMode((int)5890);
            GlStateManager.loadIdentity();
            float f = (float)rat.field_70173_aa + partialTicks;
            GlStateManager.translatef((float)(f * 0.01f), (float)(f * 0.01f), (float)0.0f);
            GlStateManager.matrixMode((int)5888);
            GlStateManager.enableBlend();
            float f1 = 0.5f;
            GlStateManager.color4f((float)0.5f, (float)0.5f, (float)0.5f, (float)0.8f);
            GlStateManager.disableLighting();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            ((ModelRat)this.func_215332_c()).func_217111_a(this.ratRenderer.func_217764_d());
            gamerenderer = Minecraft.func_71410_x().field_71460_t;
            gamerenderer.func_191514_d(true);
            ((ModelRat)this.ratRenderer.func_217764_d()).renderNoWiskers((Entity)rat, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            gamerenderer.func_191514_d(false);
            this.ratRenderer.func_217758_e((Entity)rat);
            GlStateManager.matrixMode((int)5890);
            GlStateManager.loadIdentity();
            GlStateManager.matrixMode((int)5888);
            GlStateManager.enableLighting();
            GlStateManager.disableBlend();
            GlStateManager.depthMask((boolean)true);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public boolean func_177142_b() {
        return false;
    }
}

