/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render.entity;

import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.client.model.ModelPinkie;
import com.github.alexthe666.rats.client.model.ModelRat;
import com.github.alexthe666.rats.client.render.entity.LayerRatEyes;
import com.github.alexthe666.rats.client.render.entity.LayerRatHeldItem;
import com.github.alexthe666.rats.client.render.entity.LayerRatHelmet;
import com.github.alexthe666.rats.client.render.entity.LayerRatPlague;
import com.github.alexthe666.rats.client.render.entity.RenderRattlingGun;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.EntityRattlingGun;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class RenderRat
extends MobRenderer<EntityRat, ModelRat<EntityRat>> {
    private static final Map<String, ResourceLocation> LAYERED_LOCATION_CACHE = Maps.newHashMap();
    private static final ModelRat RAT_MODEL = new ModelRat(0.0f);
    private static final ModelPinkie PINKIE_MODEL = new ModelPinkie();
    private static final ResourceLocation PINKIE_TEXTURE = new ResourceLocation("rats:textures/entity/rat/baby.png");
    private static final ResourceLocation ENDER_UPGRADE_TEXTURE = new ResourceLocation("rats:textures/entity/rat/rat_ender_upgrade.png");
    private static final ResourceLocation AQUATIC_UPGRADE_TEXTURE = new ResourceLocation("rats:textures/entity/rat/rat_aquatic_upgrade.png");
    private static final ResourceLocation DRAGON_UPGRADE_TEXTURE = new ResourceLocation("rats:textures/entity/rat/rat_dragon_upgrade.png");
    private static final ResourceLocation CARRAT_UPGRADE_TEXTURE = new ResourceLocation("rats:textures/entity/rat/rat_carrat_upgrade.png");
    private static final ResourceLocation ETHEREAL_UPGRADE_TEXTURE = new ResourceLocation("rats:textures/entity/ratlantis/ghost_pirat.png");
    private static final ResourceLocation UNDEAD_UPGRADE_TEXTURE = new ResourceLocation("rats:textures/entity/rat/rat_skeleton.png");
    private static final ResourceLocation JULIAN = new ResourceLocation("rats:textures/entity/rat/patreon/rat_julian.png");
    private static final ResourceLocation SHIZUKA = new ResourceLocation("rats:textures/entity/rat/patreon/rat_shizuka.png");
    private static final ResourceLocation SHARVA = new ResourceLocation("rats:textures/entity/rat/patreon/rat_sharva.png");
    private static final ResourceLocation DINO = new ResourceLocation("rats:textures/entity/rat/patreon/rat_dino.png");
    private static final ResourceLocation RATATLA = new ResourceLocation("rats:textures/entity/rat/patreon/rat_ratatla.png");
    private static final ResourceLocation FRIAR = new ResourceLocation("rats:textures/entity/rat/patreon/rat_friar.png");
    private static final ResourceLocation RIDDLER = new ResourceLocation("rats:textures/entity/rat/patreon/rat_riddler.png");
    private static final ResourceLocation JOKER = new ResourceLocation("rats:textures/entity/rat/patreon/rat_joker.png");

    public RenderRat() {
        super(Minecraft.func_71410_x().func_175598_ae(), (EntityModel)RAT_MODEL, 0.15f);
        this.func_177094_a(new LayerRatPlague((IEntityRenderer<EntityRat, ModelRat<EntityRat>>)this));
        this.func_177094_a(new LayerRatEyes((IEntityRenderer<EntityRat, ModelRat<EntityRat>>)this));
        this.func_177094_a(new LayerRatHelmet(this));
        this.func_177094_a(new LayerRatHeldItem((IEntityRenderer<EntityRat, ModelRat<EntityRat>>)this));
    }

    protected boolean canRenderName(EntityRat entity) {
        return RatsMod.PROXY.shouldRenderNameplates() && super.func_177070_b((MobEntity)entity);
    }

    protected void renderModel(EntityRat rat, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        boolean flag1;
        boolean flag = this.func_193115_c((LivingEntity)rat);
        boolean bl = flag1 = !flag && !rat.func_98034_c((PlayerEntity)Minecraft.func_71410_x().field_71439_g) || rat.getRespawnCountdown() > 0;
        if (flag || flag1) {
            if (!this.func_180548_c((Entity)rat)) {
                return;
            }
            if (flag1) {
                GlStateManager.setProfile((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
            AdvancedEntityModel model = rat.func_70631_g_() ? PINKIE_MODEL : RAT_MODEL;
            model.func_78088_a((Entity)rat, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
            if (flag1) {
                GlStateManager.unsetProfile((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
        }
    }

    public boolean shouldRender(EntityRat rat, ICamera camera, double camX, double camY, double camZ) {
        if (rat.func_184218_aH() && rat.func_184187_bx() != null && rat.func_184187_bx().func_184188_bt().size() >= 1 && rat.func_184187_bx().func_184188_bt().get(0) == rat && rat.func_184187_bx() instanceof LivingEntity && ((LivingEntity)rat.func_184187_bx()).func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == RatsItemRegistry.CHEF_TOQUE) {
            return false;
        }
        return super.func_177071_a((MobEntity)rat, camera, camX, camY, camZ);
    }

    protected void preRenderCallback(EntityRat rat, float partialTickTime) {
        GL11.glScaled((double)0.6f, (double)0.6f, (double)0.6f);
        if (rat.func_184218_aH() && rat.func_184187_bx() != null && rat.func_184187_bx().func_184188_bt().size() >= 1) {
            EntityRenderer playerRender;
            Entity riding;
            if (rat.func_184187_bx() instanceof PlayerEntity && (riding = rat.func_184187_bx()).func_184188_bt().get(0) != null && riding.func_184188_bt().get(0) == rat && (playerRender = Minecraft.func_71410_x().func_175598_ae().func_78713_a(riding)) instanceof LivingRenderer && ((LivingRenderer)playerRender).func_217764_d() instanceof BipedModel) {
                ((BipedModel)((LivingRenderer)playerRender).func_217764_d()).field_78116_c.func_78794_c(0.0625f);
                GlStateManager.translatef((float)0.0f, (float)-0.7f, (float)0.25f);
            }
            if (rat.func_184187_bx() instanceof EntityRattlingGun && (riding = rat.func_184187_bx()).func_184188_bt().get(0) != null && riding.func_184188_bt().get(0) == rat && (playerRender = Minecraft.func_71410_x().func_175598_ae().func_78713_a(riding)) instanceof LivingRenderer && ((LivingRenderer)playerRender).func_217764_d() instanceof BipedModel) {
                RenderRattlingGun.GUN_MODEL.pivot.func_78794_c(0.0625f);
            }
        } else {
            float f7 = rat.prevFlyingPitch + (rat.flyingPitch - rat.prevFlyingPitch) * partialTickTime;
            GL11.glRotatef((float)rat.flyingPitch, (float)1.0f, (float)0.0f, (float)0.0f);
        }
    }

    protected ResourceLocation getEntityTexture(EntityRat entity) {
        ResourceLocation resourcelocation;
        String s = entity.getRatTexture();
        if (entity.func_70631_g_()) {
            return PINKIE_TEXTURE;
        }
        if (entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ETHEREAL)) {
            return ETHEREAL_UPGRADE_TEXTURE;
        }
        if (entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_UNDEAD)) {
            return UNDEAD_UPGRADE_TEXTURE;
        }
        if (entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_CARRAT)) {
            return CARRAT_UPGRADE_TEXTURE;
        }
        if (entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_DRAGON)) {
            return DRAGON_UPGRADE_TEXTURE;
        }
        if (entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ENDER)) {
            return ENDER_UPGRADE_TEXTURE;
        }
        if (entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_AQUATIC)) {
            return AQUATIC_UPGRADE_TEXTURE;
        }
        if (entity.func_145818_k_()) {
            String str = entity.func_200201_e().func_150254_d();
            if (str.contains("julian") || str.contains("Julian")) {
                return JULIAN;
            }
            if (str.contains("shizuka") || str.contains("Shizuka")) {
                return SHIZUKA;
            }
            if (str.contains("sharva") || str.contains("Sharva")) {
                return SHARVA;
            }
            if (str.contains("dino") || str.contains("Dino")) {
                return DINO;
            }
            if (str.contains("ratatla") || str.contains("Ratatla")) {
                return RATATLA;
            }
            if (str.contains("friar") || str.contains("Friar")) {
                return FRIAR;
            }
            if (str.contains("riddler") || str.contains("Riddler")) {
                return RIDDLER;
            }
            if (str.contains("joker") || str.contains("Joker")) {
                return JOKER;
            }
        }
        if ((resourcelocation = LAYERED_LOCATION_CACHE.get(s)) == null) {
            resourcelocation = new ResourceLocation(s);
            LAYERED_LOCATION_CACHE.put(s, resourcelocation);
        }
        return resourcelocation;
    }

    protected float getDeathMaxRotation(EntityRat rat) {
        return rat.isDeadInTrap ? 0.0f : 90.0f;
    }
}

