/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render.entity;

import com.github.alexthe666.rats.client.model.ModelRattlingGun;
import com.github.alexthe666.rats.server.entity.EntityRattlingGun;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderRattlingGun
extends EntityRenderer<EntityRattlingGun> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("rats:textures/entity/rattling_gun.png");
    private static final ResourceLocation TEXTURE_FIRING = new ResourceLocation("rats:textures/entity/rattling_gun_firing.png");
    public static final ModelRattlingGun GUN_MODEL = new ModelRattlingGun();

    public RenderRattlingGun() {
        super(Minecraft.func_71410_x().func_175598_ae());
    }

    protected void preRenderCallback(EntityRattlingGun rat, float partialTickTime) {
    }

    public void doRender(EntityRattlingGun entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.renderGun(entity, x, y, z, entityYaw, partialTicks, TEXTURE, false);
        if (entity.isFiring()) {
            this.renderGun(entity, x, y, z, entityYaw, partialTicks, TEXTURE_FIRING, true);
        }
    }

    public void renderGun(EntityRattlingGun entity, double x, double y, double z, float entityYaw, float partialTicks, ResourceLocation texture, boolean glow) {
        GlStateManager.pushMatrix();
        if (glow) {
            GlStateManager.disableLighting();
            GlStateManager.disableCull();
            GlStateManager.enableRescaleNormal();
            GlStateManager.enableAlphaTest();
            GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)240.0f, (float)0.0f);
        }
        GlStateManager.translatef((float)((float)x), (float)((float)y), (float)((float)z));
        float f = 0.0625f;
        this.func_110776_a(texture);
        if (this.field_188301_f) {
            GlStateManager.enableColorMaterial();
            GlStateManager.setupSolidRenderingTextureCombine((int)this.func_188298_c((Entity)entity));
        }
        GUN_MODEL.setRotationAngles(entity, 0.0f, 0.0f, (float)entity.field_70173_aa + partialTicks, 0.0f, 0.0f, 0.0625f);
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)0.0f, (float)1.5f, (float)0.0f);
        GlStateManager.rotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderRattlingGun.GUN_MODEL.base1.func_78785_a(0.0625f);
        GL11.glPushMatrix();
        GlStateManager.rotatef((float)(90.0f + entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * partialTicks - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderRattlingGun.GUN_MODEL.pivot.func_78785_a(0.0625f);
        GL11.glPopMatrix();
        GlStateManager.popMatrix();
        if (this.field_188301_f) {
            GlStateManager.tearDownSolidRenderingTextureCombine();
            GlStateManager.disableColorMaterial();
        }
        if (glow) {
            GlStateManager.enableLighting();
        }
        GlStateManager.popMatrix();
        super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
    }

    private float interpolateValue(float start, float end, float pct) {
        return start + (end - start) * pct;
    }

    protected ResourceLocation getEntityTexture(EntityRattlingGun entity) {
        return TEXTURE;
    }
}

